/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.registrationWindows;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.common.datetime.InstantExtensionsKt;
import com.jetbrains.toolbox.common.io.FileSize;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.Vendor;
import com.jetbrains.toolbox.interop.Win32Integration;
import com.jetbrains.toolbox.interop.Win32Registry;
import com.jetbrains.toolbox.registrationWindows.UtilKt;
import com.jetbrains.toolbox.registrationWindows.WindowsInstalledAppScanner;
import com.jetbrains.toolbox.registrationWindows.WindowsRegistrationChannelExtension;
import com.jetbrains.toolbox.registrationWindows.model.InstalledWindowsApp;
import com.jetbrains.toolbox.tools.ExtensionsKt;
import com.jetbrains.toolbox.tools.model.AvailableTool;
import com.jetbrains.toolbox.tools.model.AvailableTools;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.ChannelBackupOptions;
import com.jetbrains.toolbox.tools.model.ChannelExtension;
import com.jetbrains.toolbox.tools.model.ChannelHistory;
import com.jetbrains.toolbox.tools.model.InstallSource;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.OsIntegration;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.UniversalToolConfigurator;
import com.jetbrains.toolbox.tools.model.UpdateFilter;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nWindowsRegistrationConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsRegistrationConfigurator.kt\ncom/jetbrains/toolbox/registrationWindows/WindowsRegistrationConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ChannelExtension.kt\ncom/jetbrains/toolbox/tools/model/ChannelExtensionKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1#2:127\n23#3:128\n11#3:132\n1761#4,3:129\n1563#4:133\n1634#4,3:134\n774#4:137\n865#4,2:138\n*S KotlinDebug\n*F\n+ 1 WindowsRegistrationConfigurator.kt\ncom/jetbrains/toolbox/registrationWindows/WindowsRegistrationConfigurator\n*L\n63#1:128\n63#1:132\n63#1:129,3\n63#1:133\n63#1:134,3\n110#1:137\n110#1:138,2\n*E\n"})
public final class WindowsRegistrationConfigurator
extends UniversalToolConfigurator
implements OsIntegration {
    @NotNull
    private final Win32Registry win32Registry;
    @NotNull
    private final WindowsInstalledAppScanner installedAppScanner;
    @NotNull
    private final StateFlow<AvailableTools> availableTools;
    @NotNull
    private final Clock clock;
    @NotNull
    private final FileSystem fileSystem;
    private final DateTimeFormatter windowsInstallDateFormatter;

    public WindowsRegistrationConfigurator(@NotNull Win32Registry win32Registry, @NotNull WindowsInstalledAppScanner installedAppScanner, @NotNull StateFlow<AvailableTools> availableTools2, @NotNull Clock clock, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)win32Registry, (String)"win32Registry");
        Intrinsics.checkNotNullParameter((Object)installedAppScanner, (String)"installedAppScanner");
        Intrinsics.checkNotNullParameter(availableTools2, (String)"availableTools");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.win32Registry = win32Registry;
        this.installedAppScanner = installedAppScanner;
        this.availableTools = availableTools2;
        this.clock = clock;
        this.fileSystem = fileSystem;
        this.windowsInstallDateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object configure(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        Channel channel;
        boolean bl;
        void $this$withExtension$iv;
        ToolInstance toolInstance2;
        WindowsRegistrationChannelExtension extension2;
        block11: {
            WindowsRegistrationChannelExtension windowsRegistrationChannelExtension;
            ChannelHistory it = toolInstance.getChannel().getHistory();
            boolean bl2 = false;
            boolean isJustDetected = it.getSource() == InstallSource.Detected && it.getToolBuilds().isEmpty();
            InstalledWindowsApp existingApp = this.installedAppScanner.findApp(toolInstance.getChannel().getInstallationDirectory());
            Logger.INSTANCE.debug("Tool '" + toolInstance.getChannel().getInstallationDirectory() + "': justDetected=" + isJustDetected + ", existingApp=" + existingApp);
            if (isJustDetected && existingApp != null) {
                boolean managedByToolbox = existingApp.getManagedByToolbox-12qw-PM() != null;
                Logger.INSTANCE.debug("Tool '" + toolInstance.getChannel().getInstallationDirectory() + "': managedByToolbox=" + managedByToolbox);
                windowsRegistrationChannelExtension = new WindowsRegistrationChannelExtension(existingApp.getId(), managedByToolbox, existingApp.getUninstallString());
            } else {
                Object object = existingApp;
                if (object == null || (object = ((InstalledWindowsApp)object).getId()) == null) {
                    WindowsRegistrationChannelExtension windowsRegistrationChannelExtension2 = UtilKt.getWindowsRegistrationExtension(toolInstance.getChannel());
                    object = windowsRegistrationChannelExtension2 != null ? windowsRegistrationChannelExtension2.getUninstallId() : this.generateUninstallId-lOMW6pk$registration_windows(toolInstance.getTool().getToolId-UtVBrGo());
                }
                Object uninstallId = object;
                this.ensureRegistryEntry((String)uninstallId, toolInstance);
                windowsRegistrationChannelExtension = new WindowsRegistrationChannelExtension((String)uninstallId, true, null);
            }
            extension2 = windowsRegistrationChannelExtension;
            Channel uninstallId = toolInstance.getChannel();
            toolInstance2 = toolInstance;
            boolean $i$f$withExtension = false;
            Iterable $this$any$iv$iv = $this$withExtension$iv.getExtensions();
            boolean $i$f$any = false;
            if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv$iv : $this$any$iv$iv) {
                    ChannelExtension it$iv = (ChannelExtension)element$iv$iv;
                    boolean bl3 = false;
                    if (!(it$iv instanceof WindowsRegistrationChannelExtension)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            Collection<void> collection;
            void $this$mapTo$iv$iv$iv$iv;
            void $this$map$iv$iv$iv;
            void $this$withModifiedExtension$iv$iv = $this$withExtension$iv;
            boolean $i$f$withModifiedExtension = false;
            Iterable iterable = $this$withModifiedExtension$iv$iv.getExtensions();
            ChannelHistory channelHistory = null;
            boolean bl4 = false;
            List list2 = null;
            boolean bl5 = false;
            ChannelBackupOptions channelBackupOptions = null;
            boolean bl6 = false;
            Path path2 = null;
            UpdateFilter updateFilter = null;
            String string = null;
            void var20_25 = $this$withModifiedExtension$iv$iv;
            boolean $i$f$map = false;
            void var22_27 = $this$map$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                ChannelExtension channelExtension;
                void it$iv$iv;
                ChannelExtension channelExtension2 = (ChannelExtension)item$iv$iv$iv$iv;
                collection = destination$iv$iv$iv$iv;
                boolean bl7 = false;
                if (it$iv$iv instanceof WindowsRegistrationChannelExtension) {
                    WindowsRegistrationChannelExtension it = (WindowsRegistrationChannelExtension)it$iv$iv;
                    boolean bl8 = false;
                    channelExtension = extension2;
                } else {
                    channelExtension = it$iv$iv;
                }
                collection.add((void)channelExtension);
            }
            collection = (List)destination$iv$iv$iv$iv;
            channel = Channel.copy$default((Channel)var20_25, string, updateFilter, path2, bl6, channelBackupOptions, bl5, list2, bl4, channelHistory, collection, null, 1535, null);
        } else {
            Object it = null;
            Collection collection = $this$withExtension$iv.getExtensions();
            ChannelHistory channelHistory = null;
            boolean bl9 = false;
            List list3 = null;
            boolean bl10 = false;
            ChannelBackupOptions channelBackupOptions = null;
            boolean bl11 = false;
            Path path3 = null;
            UpdateFilter updateFilter = null;
            String string = null;
            void var33_49 = $this$withExtension$iv;
            boolean bl12 = false;
            WindowsRegistrationChannelExtension windowsRegistrationChannelExtension = extension2;
            channel = Channel.copy$default((Channel)var33_49, string, updateFilter, path3, bl11, channelBackupOptions, bl10, list3, bl9, channelHistory, CollectionsKt.plus((Collection)collection, (Object)windowsRegistrationChannelExtension), null, 1535, null);
        }
        return ToolInstance.copy$default(toolInstance2, channel, null, 2, null);
    }

    private final void ensureRegistryEntry(String uninstallId, ToolInstance toolInstance) {
        Logger.INSTANCE.debug("Updating registry entries for tool '" + toolInstance.getChannel().getInstallationDirectory() + "'");
        Win32Registry.Hive.HKCU hKey = Win32Registry.Hive.HKCU.INSTANCE;
        String subKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + uninstallId;
        InstalledTool it = toolInstance.getTool();
        boolean bl = false;
        ToolBuild availableTool2 = ((AvailableTools)this.availableTools.getValue()).get-pxhtFfg(it.getToolId-UtVBrGo(), it.getVersionName(), it.getBuildNumber-Y_E1uuk());
        Win32Registry $this$ensureRegistryEntry_u24lambda_u244 = this.win32Registry;
        boolean bl2 = false;
        Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, (Win32Registry.Hive)hKey, subKey, "DisplayVersion", toolInstance.getTool().getVersionName(), false, 16, null);
        Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, (Win32Registry.Hive)hKey, subKey, "EstimatedSize", (int)FileSize.getKibibytes-impl(FileSystemExtKt.calculateSizeRecursively(this.fileSystem, toolInstance.getChannel().getInstallationDirectory())), false, 16, null);
        if (availableTool2 != null) {
            Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, (Win32Registry.Hive)hKey, subKey, "HelpLink", availableTool2.getTool().getHomeUrl(), false, 16, null);
        }
        Win32Registry.Hive hive = hKey;
        Instant instant = this.clock.now();
        DateTimeFormatter dateTimeFormatter = this.windowsInstallDateFormatter;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"windowsInstallDateFormatter");
        Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, hive, subKey, "InstallDate", InstantExtensionsKt.toString$default(instant, dateTimeFormatter, null, 2, null), false, 16, null);
        Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, (Win32Registry.Hive)hKey, subKey, "NoRepair", 1, false, 16, null);
        String string = this.getIconPath$registration_windows(this.fileSystem, toolInstance);
        if (string != null) {
            String it2 = string;
            boolean bl3 = false;
            Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, (Win32Registry.Hive)hKey, subKey, "DisplayIcon", it2, false, 16, null);
        }
        Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, (Win32Registry.Hive)hKey, subKey, "DisplayName", InstalledToolKt.displayNameWithoutVersion(toolInstance.getChannel(), toolInstance.getTool()), false, 16, null);
        Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, (Win32Registry.Hive)hKey, subKey, "InstallLocation", toolInstance.getChannel().getInstallationDirectory().toString(), false, 16, null);
        Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, (Win32Registry.Hive)hKey, subKey, "ModifyPath", String.valueOf(OS.getApplicationExecutable$default(OS.INSTANCE, null, 1, null)), false, 16, null);
        Object object = availableTool2;
        if (object == null || (object = ((ToolBuild)object).getTool()) == null || (object = ((AvailableTool)object).getVendor()) == null || (object = ((Vendor)object).getName()) == null) {
            object = "JetBrains s.r.o.";
        }
        Object vendor = object;
        Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, (Win32Registry.Hive)hKey, subKey, "Publisher", (String)vendor, false, 16, null);
        Win32Registry.writeValue$default($this$ensureRegistryEntry_u24lambda_u244, (Win32Registry.Hive)hKey, subKey, "ManagedByToolbox", BuildNumber.toString-impl(Build.INSTANCE.getBuildNumber-Y_E1uuk()), false, 16, null);
        $this$ensureRegistryEntry_u24lambda_u244.deleteValue(hKey, subKey, "NoModify");
        $this$ensureRegistryEntry_u24lambda_u244.deleteValue(hKey, subKey, "UninstallString");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getIconPath$registration_windows(@NotNull FileSystem $this$getIconPath, @NotNull ToolInstance toolInstance) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getIconPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
        Path command2 = ExtensionsKt.getLaunchCommand(toolInstance);
        if (command2 != null) {
            Path iconPath = command2;
            String iconPathString = iconPath.toString();
            String string = Win32Integration.INSTANCE.getExternalIconPathForExecutable(iconPathString);
            if (string == null) {
                string = iconPathString;
            }
            return string;
        }
        Iterable $this$filter$iv = $this$getIconPath.list(toolInstance.getChannel().getInstallationDirectory());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path path2 = (Path)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith((String)path2.name(), (String)".exe", (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List contents = (List)destination$iv$iv;
        Path singleExe = (Path)CollectionsKt.singleOrNull((List)contents);
        if (singleExe != null) {
            return singleExe.toString();
        }
        Logger.INSTANCE.debug(() -> WindowsRegistrationConfigurator.getIconPath$lambda$6(contents, toolInstance));
        return null;
    }

    @NotNull
    public final String generateUninstallId-lOMW6pk$registration_windows(@NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        return "JetBrains Toolbox (" + ApplicationType.toString-impl(toolId) + ") " + UUID.randomUUID();
    }

    private static final String getIconPath$lambda$6(List $contents, ToolInstance $toolInstance) {
        return "Not single .exe file: " + CollectionsKt.joinToString$default((Iterable)$contents, null, null, null, (int)0, null, null, (int)63, null) + " for tool '" + $toolInstance.getChannel().getInstallationDirectory() + "'";
    }
}

