/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.registrationWindows;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.interop.Win32Registry;
import com.jetbrains.toolbox.registrationWindows.WindowsInstalledAppScanner;
import com.jetbrains.toolbox.registrationWindows.model.InstalledWindowsApp;
import com.jetbrains.toolbox.tools.provider.LocalToolPathProvider;
import com.jetbrains.toolbox.tools.provider.PathToScan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nWindowsInstalledAppScannerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsInstalledAppScannerImpl.kt\ncom/jetbrains/toolbox/registrationWindows/WindowsInstalledAppScannerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1563#2:67\n1634#2,3:68\n774#2:72\n865#2,2:73\n295#2,2:75\n1#3:71\n*S KotlinDebug\n*F\n+ 1 WindowsInstalledAppScannerImpl.kt\ncom/jetbrains/toolbox/registrationWindows/WindowsInstalledAppScannerImpl\n*L\n18#1:67\n18#1:68,3\n57#1:72\n57#1:73,2\n59#1:75,2\n*E\n"})
public final class WindowsInstalledAppScannerImpl
implements WindowsInstalledAppScanner,
LocalToolPathProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Win32Registry win32Registry;

    public WindowsInstalledAppScannerImpl(@NotNull Win32Registry win32Registry) {
        Intrinsics.checkNotNullParameter((Object)win32Registry, (String)"win32Registry");
        this.win32Registry = win32Registry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PathToScan> getPathsToScan() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.scan();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InstalledWindowsApp installedWindowsApp = (InstalledWindowsApp)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PathToScan(it.getInstallationDirectory(), 0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<InstalledWindowsApp> scan() {
        Set set2;
        Set $this$scan_u24lambda_u241 = set2 = SetsKt.createSetBuilder();
        boolean bl = false;
        try {
            Object[] objectArray = new Win32Registry.Hive[]{Win32Registry.Hive.HKCU.INSTANCE, Win32Registry.Hive.HKLM.INSTANCE};
            for (Win32Registry.Hive hkey : CollectionsKt.listOf((Object[])objectArray)) {
                Object[] objectArray2 = new Boolean[]{true, false};
                Iterator iterator2 = CollectionsKt.listOf((Object[])objectArray2).iterator();
                while (iterator2.hasNext()) {
                    boolean wow6432 = (Boolean)iterator2.next();
                    for (String appName : this.win32Registry.listKeys(hkey, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", wow6432)) {
                        try {
                            String string;
                            Path installPath;
                            Path path2;
                            char[] cArray;
                            String installLocation;
                            if (WindowsInstalledAppScannerImpl.scan$lambda$1$readValue(this, hkey, appName, wow6432, "InstallLocation") == null) continue;
                            if (((CharSequence)installLocation).length() > 0) {
                                cArray = new char[]{'\"'};
                                path2 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)StringsKt.trim((String)installLocation, (char[])cArray), (boolean)false, (int)1, null);
                            } else {
                                String icon2 = WindowsInstalledAppScannerImpl.scan$lambda$1$readValue(this, hkey, appName, wow6432, "DisplayIcon");
                                String string2 = icon2;
                                path2 = string2 != null && (string2 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string2, (boolean)false, (int)1, null)) != null && (string2 = string2.parent()) != null ? string2.parent() : null;
                            }
                            if ((installPath = path2) == null) continue;
                            Set set3 = $this$scan_u24lambda_u241;
                            if (WindowsInstalledAppScannerImpl.scan$lambda$1$readValue(this, hkey, appName, wow6432, "ManagedByToolbox") != null) {
                                void p0;
                                Set set4 = set3;
                                boolean bl2 = false;
                                set3 = set4;
                                string = BuildNumber.box-impl(BuildNumber.constructor-impl((String)p0)).unbox-impl();
                            } else {
                                string = null;
                            }
                            cArray = string;
                            String string3 = WindowsInstalledAppScannerImpl.scan$lambda$1$readValue(this, hkey, appName, wow6432, "UninstallString");
                            set3.add(new InstalledWindowsApp(appName, (String)cArray, installPath, string3, null));
                        }
                        catch (Throwable t2) {
                            Logger.INSTANCE.debug(t2, "Failed to process " + appName + " from " + hkey + " registry (wow6432=" + wow6432 + ")");
                        }
                    }
                }
            }
        }
        catch (Throwable t3) {
            Logger.INSTANCE.error(t3, "Failed to list SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall: " + t3.getMessage());
        }
        return SetsKt.build((Set)set2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public InstalledWindowsApp findApp(@NotNull Path installationDirectory) {
        InstalledWindowsApp installedWindowsApp;
        Object v0;
        List existingApps;
        block3: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)installationDirectory, (String)"installationDirectory");
            Iterable $this$filter$iv = this.scan();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                InstalledWindowsApp it = (InstalledWindowsApp)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getInstallationDirectory(), (Object)installationDirectory)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            existingApps = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = existingApps;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                InstalledWindowsApp it = (InstalledWindowsApp)element$iv;
                boolean bl = false;
                if (!(it.getUninstallString() != null)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((installedWindowsApp = (InstalledWindowsApp)v0) == null) {
            installedWindowsApp = (InstalledWindowsApp)CollectionsKt.firstOrNull((List)existingApps);
        }
        return installedWindowsApp;
    }

    private static final String scan$lambda$1$readValue(WindowsInstalledAppScannerImpl this$0, Win32Registry.Hive hkey, String appName, boolean wow6432, String valueName) {
        return this$0.win32Registry.readValue(hkey, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + appName, valueName, wow6432);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

