/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.protocolhandler;

import com.jetbrains.toolbox.protocolhandler.JetBrainsProtocolHandler;
import com.jetbrains.toolbox.protocolhandler.ProtocolHandler;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nJetBrainsProtocolHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetBrainsProtocolHandler.kt\ncom/jetbrains/toolbox/protocolhandler/JetBrainsProtocolHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n295#2,2:48\n*S KotlinDebug\n*F\n+ 1 JetBrainsProtocolHandler.kt\ncom/jetbrains/toolbox/protocolhandler/JetBrainsProtocolHandler\n*L\n25#1:48,2\n*E\n"})
public final class JetBrainsProtocolHandler {
    @NotNull
    private final List<ProtocolHandler> protocolHandlers;

    public JetBrainsProtocolHandler(@NotNull List<? extends ProtocolHandler> protocolHandlers) {
        Intrinsics.checkNotNullParameter(protocolHandlers, (String)"protocolHandlers");
        this.protocolHandlers = protocolHandlers;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object handle(@NotNull String protocolUrl, @NotNull Continuation<? super ProtocolHandlingResult> $completion) {
        if (!($completion instanceof handle.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ JetBrainsProtocolHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handle(null, (Continuation<? super ProtocolHandlingResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    var4_6 = new URI(protocolUrl);
                }
                catch (Throwable t) {
                    Logger.INSTANCE.warn(t, "Incorrect activation URL");
                    return new ProtocolHandlingResult(false, false);
                }
                uri = var4_6;
                if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"jetbrains")) {
                    Logger.INSTANCE.info("Unknown protocol scheme: " + uri.getScheme() + " for URL: " + protocolUrl);
                    return new ProtocolHandlingResult(false, false);
                }
                $this$firstOrNull$iv = this.protocolHandlers;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (ProtocolHandler)element$iv;
                    $i$a$-firstOrNull-JetBrainsProtocolHandler$handle$handler$1 = false;
                    if (!it.canHandle(uri)) continue;
                    v0 = element$iv;
                    ** GOTO lbl32
                }
                v0 = null;
lbl32:
                // 2 sources

                handler = v0;
                if (handler == null) {
                    Logger.INSTANCE.warn("Cannot handle URL: " + protocolUrl);
                    return new ProtocolHandlingResult(false, false);
                }
                $continuation.L$0 = protocolUrl;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.L$2 = handler;
                $continuation.label = 1;
                v1 = handler.handle(uri, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var13_5) goto lbl45
lbl44:
                // 1 sources

                return var13_5;
lbl45:
                // 1 sources

                ** GOTO lbl54
            }
            case 1: {
                handler = (ProtocolHandler)$continuation.L$2;
                uri = (URI)$continuation.L$1;
                protocolUrl = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl54:
                    // 2 sources

                    Logger.INSTANCE.info("Handled URL: " + StringsKt.take((String)protocolUrl, (int)20) + "...");
                    return new ProtocolHandlingResult(true, handler.getImpliesUiMode());
                }
                catch (CancellationException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    Logger.INSTANCE.error(ex, "Failed to handle URL " + protocolUrl);
                    return new ProtocolHandlingResult(true, false);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final class ProtocolHandlingResult {
        private final boolean handlerFound;
        private final boolean shouldAllowUi;

        public ProtocolHandlingResult(boolean handlerFound, boolean shouldAllowUi) {
            this.handlerFound = handlerFound;
            this.shouldAllowUi = shouldAllowUi;
        }

        public final boolean getShouldAllowUi() {
            return this.shouldAllowUi;
        }

        @NotNull
        public String toString() {
            return "ProtocolHandlingResult(handlerFound=" + this.handlerFound + ", shouldAllowUi=" + this.shouldAllowUi + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.handlerFound);
            result2 = result2 * 31 + Boolean.hashCode(this.shouldAllowUi);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProtocolHandlingResult)) {
                return false;
            }
            ProtocolHandlingResult protocolHandlingResult = (ProtocolHandlingResult)other;
            if (this.handlerFound != protocolHandlingResult.handlerFound) {
                return false;
            }
            return this.shouldAllowUi == protocolHandlingResult.shouldAllowUi;
        }
    }
}

