/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.project.fleet;

import com.jetbrains.toolbox.fleet.core.FleetPathsKt;
import com.jetbrains.toolbox.fleet.core.RecentShipInfo;
import com.jetbrains.toolbox.fleet.core.ShipsStateData;
import com.jetbrains.toolbox.project.AvailableToolProjectSource;
import com.jetbrains.toolbox.project.CheckedOutProject;
import com.jetbrains.toolbox.project.DetectedProject;
import com.jetbrains.toolbox.project.FileSystemProject;
import com.jetbrains.toolbox.project.FleetWorkspace;
import com.jetbrains.toolbox.project.IconSet;
import com.jetbrains.toolbox.project.InstalledToolProjectSource;
import com.jetbrains.toolbox.project.ManagedToolProjectSource;
import com.jetbrains.toolbox.project.fleet.FleetSource;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.model.ProjectId;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlinx.datetime.Instant;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nFleetProjectScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetProjectScanner.kt\ncom/jetbrains/toolbox/project/fleet/FleetProjectScanner\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,87:1\n66#2:88\n52#2,4:90\n60#2,10:96\n56#2,3:106\n71#2,3:109\n67#3:89\n68#3:94\n80#4:95\n1617#5,9:112\n1869#5:121\n1563#5:124\n1634#5,3:125\n1563#5:128\n1634#5,3:129\n1870#5:133\n1626#5:134\n1#6:122\n1#6:132\n222#7:123\n*S KotlinDebug\n*F\n+ 1 FleetProjectScanner.kt\ncom/jetbrains/toolbox/project/fleet/FleetProjectScanner\n*L\n48#1:88\n48#1:90,4\n48#1:96,10\n48#1:106,3\n48#1:109,3\n48#1:89\n48#1:94\n48#1:95\n50#1:112,9\n50#1:121\n53#1:124\n53#1:125,3\n70#1:128\n70#1:129,3\n50#1:133\n50#1:134\n50#1:132\n52#1:123\n*E\n"})
public final class FleetProjectScanner {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path localStorage;
    @NotNull
    private final Path recentShips;
    @NotNull
    private final Json json;

    public FleetProjectScanner(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.localStorage = FleetPathsKt.fleetConfigDirectoryPath().resolve("localStorage");
        this.recentShips = this.localStorage.resolve("recent_ships.2.json");
        this.json = JsonKt.Json$default(null, FleetProjectScanner::json$lambda$0, (int)1, null);
    }

    @NotNull
    public final Path getLocalStorage$project_fleet() {
        return this.localStorage;
    }

    public static /* synthetic */ void getLocalStorage$project_fleet$annotations() {
    }

    @NotNull
    public final Path getRecentShips$project_fleet() {
        return this.recentShips;
    }

    public static /* synthetic */ void getRecentShips$project_fleet$annotations() {
    }

    private static /* synthetic */ void getJson$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Set<DetectedProject> scanSources$project_fleet(@NotNull Collection<FleetSource> sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        try {
            void $this$mapNotNullTo$iv$iv;
            Object object;
            Throwable thrown$iv$iv;
            block39: {
                void this_$iv;
                if (sources.isEmpty()) {
                    Logger.INSTANCE.debug("No Fleet available or installed, won't detect Fleet projects");
                    return SetsKt.emptySet();
                }
                if (!this.fileSystem.exists(this.recentShips)) {
                    Logger.INSTANCE.debug("Can't detect Fleet projects, '" + this.recentShips + "' doesn't exist");
                    return SetsKt.emptySet();
                }
                Logger.INSTANCE.info("Detecting Fleet projects from '" + this.recentShips + "'");
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = this.recentShips;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void $this$decodeFromStream$iv;
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$scanSources_u24lambda_u241 = it$iv;
                    boolean bl3 = false;
                    Json json2 = this.json;
                    InputStream stream$iv = $this$scanSources_u24lambda_u241.inputStream();
                    boolean $i$f$decodeFromStream = false;
                    SerializersModule serializersModule = $this$decodeFromStream$iv.getSerializersModule();
                    KType kType = Reflection.typeOf(ShipsStateData.class);
                    MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                    object = (ShipsStateData)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType)), (InputStream)stream$iv);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        object = null;
                        break block39;
                    }
                    catch (Throwable t$iv$iv2) {
                        throw t$iv$iv2;
                    }
                    finally {
                        block40: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block40;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            ShipsStateData result$iv$iv = object;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            ShipsStateData shipsMap = result$iv$iv;
            Iterable $this$mapNotNull$iv = shipsMap.getShips().values();
            boolean $i$f$mapNotNull = false;
            Iterable bl = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                DetectedProject detectedProject;
                String name2;
                String string;
                String lastModified;
                List locations;
                Iterable it;
                Collection collection;
                Map<String, String> data2;
                block44: {
                    String string2;
                    block43: {
                        void $this$mapTo$iv$iv;
                        Object object2;
                        Object it2;
                        Object object3;
                        block42: {
                            block41: {
                                void this_$iv;
                                Object element$iv$iv$iv;
                                Object element$iv$iv = element$iv$iv$iv = object.next();
                                boolean bl4 = false;
                                RecentShipInfo info = (RecentShipInfo)element$iv$iv;
                                boolean bl5 = false;
                                data2 = info.getShipState().getData();
                                object3 = data2.get("locations");
                                if (object3 == null) break block41;
                                it2 = object3;
                                boolean bl6 = false;
                                Json json3 = (Json)Json.Default;
                                Object string$iv = it2;
                                boolean $i$f$decodeFromString = false;
                                object2 = this_$iv.getSerializersModule();
                                KType kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)));
                                MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                                List list2 = (List)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)object2, (KType)kType), (String)string$iv);
                                object3 = list2;
                                if (list2 != null) break block42;
                            }
                            object3 = CollectionsKt.emptyList();
                        }
                        Object locationStrings = object3;
                        Iterable $this$map$iv = (Iterable)locationStrings;
                        boolean $i$f$map = false;
                        it2 = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            object2 = (String)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl7 = false;
                            collection.add(Path.Companion.get$default((Path.Companion)Path.Companion, (String)((Object)it), (boolean)false, (int)1, null));
                        }
                        locations = (List)destination$iv$iv2;
                        string2 = data2.get("lastLoadedTime");
                        if (string2 == null) break block43;
                        long it3 = Long.parseLong(string2);
                        boolean bl8 = false;
                        Instant instant = Instant.Companion.fromEpochMilliseconds(it3);
                        string2 = instant;
                        if (instant != null) break block44;
                    }
                    string2 = lastModified = Instant.Companion.getDISTANT_PAST();
                }
                if ((string = data2.get("name")) == null) {
                    Path path2 = (Path)CollectionsKt.firstOrNull((List)locations);
                    string = path2 != null ? path2.name() : null;
                    if (string == null) {
                        Object object4;
                        if (data2.get("workspaceId") != null) {
                            boolean bl9 = false;
                            object4 = "Fleet Workspace " + (String)((Object)it);
                        } else {
                            object4 = string = null;
                        }
                        if (object4 == null) {
                            string = name2 = "Fleet Workspace";
                        }
                    }
                }
                if (locations.isEmpty()) {
                    detectedProject = null;
                } else {
                    void $this$mapTo$iv$iv;
                    Path location = (Path)CollectionsKt.singleOrNull((List)locations);
                    CheckedOutProject project2 = location != null ? (CheckedOutProject)new FileSystemProject(ProjectId.constructor-impl(location.toString()), name2, IconSet.Companion.getEMPTY(), location, null, (Instant)lastModified, false, 64, null) : (CheckedOutProject)new FleetWorkspace(ProjectId.constructor-impl(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)locations), (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), name2, CollectionsKt.toSet((Iterable)locations), (Instant)lastModified, false, 16, null);
                    Iterable $this$map$iv = sources;
                    boolean $i$f$map = false;
                    it = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it4;
                        FleetSource fleetSource = (FleetSource)item$iv$iv;
                        collection = destination$iv$iv3;
                        boolean bl10 = false;
                        collection.add(it4.getChannelId-5lgeRk0() != null ? (ManagedToolProjectSource)new InstalledToolProjectSource((Instant)lastModified, WellKnownApplications.INSTANCE.getFleet-UtVBrGo(), this.recentShips, it4.getChannelId-5lgeRk0(), null) : (ManagedToolProjectSource)new AvailableToolProjectSource((Instant)lastModified, WellKnownApplications.INSTANCE.getFleet-UtVBrGo(), this.recentShips, it4.getMajorVersion(), null));
                    }
                    Set source = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
                    detectedProject = new DetectedProject(project2, source);
                }
                if (detectedProject == null) continue;
                DetectedProject it$iv$iv = detectedProject;
                boolean bl11 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Can't detect Fleet projects");
            return SetsKt.emptySet();
        }
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }
}

