/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.project;

import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.project.AvailableToolInstallAndOpenProject;
import com.jetbrains.toolbox.project.FileSystemProject;
import com.jetbrains.toolbox.project.InstalledToolOpenProject;
import com.jetbrains.toolbox.project.LaunchMethod;
import com.jetbrains.toolbox.project.Project;
import com.jetbrains.toolbox.project.ProjectLauncher;
import com.jetbrains.toolbox.project.ProjectPathDoesNotExistException;
import com.jetbrains.toolbox.project.RemoteProject;
import com.jetbrains.toolbox.project.ToolNotInstalledException;
import com.jetbrains.toolbox.project.VcsRepository;
import com.jetbrains.toolbox.tools.ToolLaunchManager;
import com.jetbrains.toolbox.tools.model.AvailableTools;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import java.util.Map;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import okio.FileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalProjectLauncher
implements ProjectLauncher {
    @NotNull
    private final ToolLaunchManager toolLaunchManager;
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final StateFlow<AvailableTools> availableToolFlow;
    @NotNull
    private final FileSystem fileSystem;

    public LocalProjectLauncher(@NotNull ToolLaunchManager toolLaunchManager, @NotNull ToolManager toolManager, @NotNull StateFlow<AvailableTools> availableToolFlow, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)toolLaunchManager, (String)"toolLaunchManager");
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter(availableToolFlow, (String)"availableToolFlow");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.toolLaunchManager = toolLaunchManager;
        this.toolManager = toolManager;
        this.availableToolFlow = availableToolFlow;
        this.fileSystem = fileSystem;
    }

    @Override
    public boolean canLaunch(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return !(project2 instanceof RemoteProject);
    }

    @Override
    @Nullable
    public Object launch(@NotNull Project project2, @NotNull LaunchMethod launchMethod, @NotNull Continuation<? super Unit> $completion) {
        block8: {
            Object object;
            block10: {
                block9: {
                    LaunchMethod launchMethod2 = launchMethod;
                    if (launchMethod2 instanceof InstalledToolOpenProject) {
                        Project project3 = project2;
                        if (project3 instanceof FileSystemProject) {
                            Object object2 = this.openWithInstalled((FileSystemProject)project2, (InstalledToolOpenProject)launchMethod, $completion);
                            if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                return object2;
                            }
                            return Unit.INSTANCE;
                        }
                        if (project3 instanceof VcsRepository) {
                            Object object3 = this.cloneWithInstalled((VcsRepository)project2, (InstalledToolOpenProject)launchMethod, $completion);
                            if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                return object3;
                            }
                            return Unit.INSTANCE;
                        }
                        return Unit.INSTANCE;
                    }
                    if (!(launchMethod2 instanceof AvailableToolInstallAndOpenProject)) break block8;
                    object = ((AvailableTools)this.availableToolFlow.getValue()).getTools().get(ApplicationType.box-impl(((AvailableToolInstallAndOpenProject)launchMethod).getToolId-UtVBrGo()));
                    if (object == null || (object = ((ToolWithVersions)object).getStableToolBuild()) == null) break block9;
                    Object it = object;
                    boolean bl = false;
                    String string = ((ToolBuild)it).getTool().getName() + " " + ((ToolBuild)it).getVersion().getName();
                    object = string;
                    if (string != null) break block10;
                }
                object = ((AvailableToolInstallAndOpenProject)launchMethod).getToolId-UtVBrGo();
            }
            Object toolName = object;
            throw new ToolNotInstalledException((String)toolName);
        }
        return Unit.INSTANCE;
    }

    private final Object openWithInstalled(FileSystemProject project2, InstalledToolOpenProject installedToolOpenProject, Continuation<? super Unit> $completion) {
        if (!this.fileSystem.exists(project2.getPath())) {
            throw new ProjectPathDoesNotExistException(project2.getId-kZr3Ip4(), project2.getPath(), null);
        }
        String channelId = installedToolOpenProject.getChannelId-5CZByfs();
        Object object = (ChannelState)((Map)this.toolManager.getModel().getValue()).get(ChannelId.box-impl(channelId));
        if (object == null || (object = object.getTool()) == null) {
            throw new IllegalStateException(("Channel " + ChannelId.toString-impl(channelId) + " not found").toString());
        }
        String appType = object.getToolId-UtVBrGo();
        Object object2 = ToolLaunchManager.launchTool-ZTOvLac$default(this.toolLaunchManager, channelId, appType, project2.getPath().toString(), null, false, null, null, 120, null).await($completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    private final Object cloneWithInstalled(VcsRepository project2, InstalledToolOpenProject installedToolOpenProject, Continuation<? super Unit> $completion) {
        String channelId = installedToolOpenProject.getChannelId-5CZByfs();
        Object object = (ChannelState)((Map)this.toolManager.getModel().getValue()).get(ChannelId.box-impl(channelId));
        if (object == null || (object = object.getTool()) == null) {
            throw new IllegalStateException(("Channel " + ChannelId.toString-impl(channelId) + " not found").toString());
        }
        String appType = object.getToolId-UtVBrGo();
        Object object2 = ToolLaunchManager.launchTool-ZTOvLac$default(this.toolLaunchManager, channelId, appType, "jetbrains://idea/checkout/git?checkout.repo=" + project2.getCloneUrl() + "&idea.required.plugins.id=Git4Idea", null, false, null, null, 120, null).await($completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$openWithInstalled(LocalProjectLauncher $this, FileSystemProject project2, InstalledToolOpenProject installedToolOpenProject, Continuation $completion) {
        return $this.openWithInstalled(project2, installedToolOpenProject, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$cloneWithInstalled(LocalProjectLauncher $this, VcsRepository project2, InstalledToolOpenProject installedToolOpenProject, Continuation $completion) {
        return $this.cloneWithInstalled(project2, installedToolOpenProject, (Continuation<? super Unit>)$completion);
    }
}

