/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.ui.images.impl;

import com.jetbrains.toolbox.platform.image.ImageKey;
import com.jetbrains.toolbox.platform.ui.images.ImageProvider;
import com.jetbrains.toolbox.platform.ui.images.SourceImage;
import com.jetbrains.toolbox.platform.ui.images.impl.SpiImageProvider;
import com.jetbrains.toolbox.platform.ui.theme.Theme;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ImageResolver {
    @NotNull
    private final Theme theme;
    @NotNull
    private final ImageProvider provider;
    @NotNull
    private final ConcurrentHashMap<ImageKey, SourceImage> _cache;
    public static final int $stable = 8;

    public ImageResolver(@NotNull Theme theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.theme = theme;
        this.provider = new SpiImageProvider();
        this._cache = new ConcurrentHashMap();
    }

    @NotNull
    public final SourceImage resolveImage(@NotNull ImageKey key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        SourceImage sourceImage = this._cache.computeIfAbsent(key2, arg_0 -> ImageResolver.resolveImage$lambda$0((Function1)new Function1<ImageKey, SourceImage>((Object)this){

            public final SourceImage invoke(ImageKey p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ImageResolver.access$doResolveImage((ImageResolver)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sourceImage, (String)"computeIfAbsent(...)");
        return sourceImage;
    }

    private final SourceImage doResolveImage(ImageKey key2) {
        SourceImage sourceImage = this.provider.resolveImage(key2, this.theme.isDark());
        if (sourceImage == null) {
            sourceImage = SourceImage.Blank.INSTANCE;
        }
        return sourceImage;
    }

    private static final SourceImage resolveImage$lambda$0(Function1 $tmp0, Object p0) {
        return (SourceImage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ SourceImage access$doResolveImage(ImageResolver $this, ImageKey key2) {
        return $this.doResolveImage(key2);
    }
}

