/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.ui.images;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.graphics.vector.ImageVector;
import androidx.compose.ui.graphics.vector.VectorPainter;
import androidx.compose.ui.graphics.vector.VectorPainterKt;
import com.jetbrains.toolbox.platform.ui.images.impl.EmptyPainter;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class SourceImage {
    private final boolean allowTint;

    private SourceImage(boolean allowTint) {
        this.allowTint = allowTint;
    }

    public final boolean getAllowTint() {
        return this.allowTint;
    }

    @NotNull
    public abstract SourceImage noTint();

    @NotNull
    public abstract Painter painter(@Nullable Composer var1, int var2);

    public /* synthetic */ SourceImage(boolean allowTint, DefaultConstructorMarker $constructor_marker) {
        this(allowTint);
    }

    public static final class Blank
    extends SourceImage {
        @NotNull
        public static final Blank INSTANCE = new Blank();

        private Blank() {
            super(false, null);
        }

        @Override
        @NotNull
        public SourceImage noTint() {
            return this;
        }

        @Override
        @NotNull
        public Painter painter(@Nullable Composer $composer, int $changed) {
            $composer.startReplaceGroup(423263143);
            ComposerKt.sourceInformation($composer, "C(painter):SourceImage.kt#qftcdl");
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart(423263143, $changed, -1, "com.jetbrains.toolbox.platform.ui.images.SourceImage.Blank.painter (SourceImage.kt:32)");
            }
            EmptyPainter emptyPainter = EmptyPainter.INSTANCE;
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceGroup();
            return emptyPainter;
        }
    }

    public static final class PainterSourceImage
    extends SourceImage {
        @NotNull
        private final Painter painter;

        public PainterSourceImage(@NotNull Painter painter, boolean allowTint) {
            Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
            super(allowTint, null);
            this.painter = painter;
        }

        @Override
        @NotNull
        public SourceImage noTint() {
            if (!this.getAllowTint()) {
                return this;
            }
            return new PainterSourceImage(this.painter, false);
        }

        @Override
        @NotNull
        public Painter painter(@Nullable Composer $composer, int $changed) {
            $composer.startReplaceGroup(-230450088);
            ComposerKt.sourceInformation($composer, "C(painter):SourceImage.kt#qftcdl");
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart(-230450088, $changed, -1, "com.jetbrains.toolbox.platform.ui.images.SourceImage.PainterSourceImage.painter (SourceImage.kt:72)");
            }
            Painter painter = this.painter;
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceGroup();
            return painter;
        }
    }

    public static final class VectorSourceImage
    extends SourceImage {
        @NotNull
        private final ImageVector imageVector;

        public VectorSourceImage(@NotNull ImageVector imageVector, boolean allowTint) {
            Intrinsics.checkNotNullParameter((Object)imageVector, (String)"imageVector");
            super(allowTint, null);
            this.imageVector = imageVector;
        }

        @Override
        @NotNull
        public SourceImage noTint() {
            if (!this.getAllowTint()) {
                return this;
            }
            return new VectorSourceImage(this.imageVector, false);
        }

        @Override
        @NotNull
        public Painter painter(@Nullable Composer $composer, int $changed) {
            $composer.startReplaceGroup(-22229218);
            ComposerKt.sourceInformation($composer, "C(painter)53@1321L34:SourceImage.kt#qftcdl");
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart(-22229218, $changed, -1, "com.jetbrains.toolbox.platform.ui.images.SourceImage.VectorSourceImage.painter (SourceImage.kt:52)");
            }
            VectorPainter vectorPainter = VectorPainterKt.rememberVectorPainter(this.imageVector, $composer, 0);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceGroup();
            return vectorPainter;
        }
    }
}

