/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.packageextractor;

import com.jetbrains.toolbox.common.FileExtension;
import com.jetbrains.toolbox.interop.ProcessOutputHandler;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.packageextractor.PackageExtractor;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
public final class UnixTarGzExtractor
implements PackageExtractor {
    @NotNull
    private final ShellEnvironment shellEnvironment;
    @NotNull
    private final ProcessRunner processRunner;

    public UnixTarGzExtractor(@NotNull ShellEnvironment shellEnvironment, @NotNull ProcessRunner processRunner) {
        Intrinsics.checkNotNullParameter((Object)shellEnvironment, (String)"shellEnvironment");
        Intrinsics.checkNotNullParameter((Object)processRunner, (String)"processRunner");
        this.shellEnvironment = shellEnvironment;
        this.processRunner = processRunner;
    }

    @Override
    @NotNull
    public Set<FileExtension> getSupportedArchiveExtensions() {
        Object[] objectArray = new FileExtension[]{FileExtension.box-impl(FileExtension.constructor-impl("tar.gz")), FileExtension.box-impl(FileExtension.constructor-impl("tgz"))};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public Object extract(@NotNull Path archive, @NotNull Path destinationDirectory, int stripDirectories, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new String[]{"-xzf", archive.toString(), "-C", destinationDirectory.toString()};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        if (stripDirectories > 0) {
            ((Collection)arguments).add("--strip-components=" + stripDirectories);
        }
        Path path2 = this.shellEnvironment.findExecutable("tar");
        if (path2 == null) {
            throw new IllegalStateException("Cannot find tar command".toString());
        }
        Path tar = path2;
        Object object = this.processRunner.runProcessCancellable(tar, arguments, ProcessOutputHandler.Discard.INSTANCE, UnixTarGzExtractor::extract$lambda$0, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final void extract$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger.INSTANCE.warn(it);
    }
}

