/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.opensshAskpass;

import com.jetbrains.toolbox.Log_utilsKt;
import com.jetbrains.toolbox.common.UnixDomainSocketsUtil;
import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.opensshAskpass.AskpassHandler;
import com.jetbrains.toolbox.opensshAskpass.AskpassSocketImpl;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.KotlinNothingValueException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nAskpassSocketImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AskpassSocketImpl.kt\ncom/jetbrains/toolbox/opensshAskpass/AskpassSocketImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class AskpassSocketImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AskpassHandler askpassHandler;
    @NotNull
    private final String separator;
    @NotNull
    private final String socketUuid;
    @NotNull
    private final Path socketPath;
    @NotNull
    private final ServerSocketChannel serverSocketChannel;
    @NotNull
    private final Selector selector;
    @NotNull
    private final Map<SocketChannel, String> answers;
    private static final long connectionTimeout = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);

    /*
     * WARNING - void declaration
     */
    public AskpassSocketImpl(@NotNull AskpassHandler askpassHandler, @NotNull WellKnownPaths wellKnownPaths) {
        Object it;
        void it2;
        Intrinsics.checkNotNullParameter((Object)askpassHandler, (String)"askpassHandler");
        Intrinsics.checkNotNullParameter((Object)wellKnownPaths, (String)"wellKnownPaths");
        this.askpassHandler = askpassHandler;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.separator = string;
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Object object = string2;
        int n = 0;
        int n2 = 8;
        String string3 = ((String)object).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        this.socketUuid = string3;
        Object object2 = object = UnixDomainSocketsUtil.INSTANCE.getSocketPath(wellKnownPaths, "s-" + this.socketUuid).toNioPath();
        AskpassSocketImpl askpassSocketImpl = this;
        boolean $i$a$-also-AskpassSocketImpl$socketPath$22 = false;
        PathsKt.createParentDirectories((Path)it2, (FileAttribute[])new FileAttribute[0]);
        if (Files.exists((Path)it2, new LinkOption[0])) {
            Files.delete((Path)it2);
        }
        askpassSocketImpl.socketPath = object;
        Object $i$a$-also-AskpassSocketImpl$socketPath$22 = object2 = SelectorProvider.provider().openServerSocketChannel(StandardProtocolFamily.UNIX);
        askpassSocketImpl = this;
        boolean bl = false;
        ((AbstractSelectableChannel)it).configureBlocking(false);
        it = object2 = ((ServerSocketChannel)object2).bind(UnixDomainSocketAddress.of(this.socketPath));
        boolean bl2 = false;
        if (OS.INSTANCE.isUnix()) {
            Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwx------");
            Files.setPosixFilePermissions(this.socketPath, permissions);
        }
        Logger.INSTANCE.debug("Server socket channel created for " + this.socketPath);
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"also(...)");
        askpassSocketImpl.serverSocketChannel = object3;
        Selector selector = Selector.open();
        Intrinsics.checkNotNullExpressionValue((Object)selector, (String)"open(...)");
        this.selector = selector;
        this.answers = new LinkedHashMap();
        this.serverSocketChannel.register(this.selector, 16);
    }

    @NotNull
    public final String getSeparator() {
        return this.separator;
    }

    @NotNull
    public final Path getSocketPath() {
        return this.socketPath;
    }

    @NotNull
    public final Job runInScope(@NotNull CoroutineScope coroutineScope) {
        Job job2;
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        MutableSharedFlow requestInput2 = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        Job it = job2 = BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)Log_utilsKt.logPrefixContext("Unix socket " + this.socketUuid)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (MutableSharedFlow<RequestInput>)requestInput2, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AskpassSocketImpl this$0;
            final /* synthetic */ MutableSharedFlow<RequestInput> $requestInput;
            {
                this.this$0 = $receiver;
                this.$requestInput = $requestInput;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var13_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        readBuffer = ByteBuffer.allocate(16384);
                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            Logger.INSTANCE.trace("Going to select " + this.this$0.getSocketPath());
                            if (AskpassSocketImpl.access$getSelector$p(this.this$0).select(2000L) <= 0) continue;
                            keys = AskpassSocketImpl.access$getSelector$p(this.this$0).selectedKeys().iterator();
lbl11:
                            // 5 sources

                            while (keys.hasNext()) {
                                key = keys.next();
                                keys.remove();
                                if (!key.isValid()) continue;
                                if (key.isAcceptable()) {
                                    conn = AskpassSocketImpl.access$getServerSocketChannel$p(this.this$0).accept();
                                    Logger.INSTANCE.info("Accepted connection");
                                    conn.configureBlocking(false);
                                    conn.register(AskpassSocketImpl.access$getSelector$p(this.this$0), 1);
                                }
                                if (!key.isReadable()) ** GOTO lbl94
                                v0 = key.channel();
                                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type java.nio.channels.SocketChannel");
                                conn = (SocketChannel)v0;
                                Logger.INSTANCE.info("Started reading");
                                readBuffer.clear();
                                this.L$0 = $this$launch;
                                this.L$1 = readBuffer;
                                this.L$2 = keys;
                                this.L$3 = key;
                                this.L$4 = conn;
                                this.L$5 = null;
                                this.L$6 = null;
                                this.L$7 = null;
                                this.L$8 = null;
                                this.label = 1;
                                v1 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)AskpassSocketImpl.access$getConnectionTimeout$cp(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(conn, readBuffer, null){
                                    int label;
                                    final /* synthetic */ SocketChannel $conn;
                                    final /* synthetic */ ByteBuffer $readBuffer;
                                    {
                                        this.$conn = $conn;
                                        this.$readBuffer = $readBuffer;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = InterruptibleKt.runInterruptible$default(null, () -> runInScope.timedOut.1.invokeSuspend$lambda$0(this.$conn, this.$readBuffer), (Continuation)((Continuation)this), (int)1, null);
                                                if (object2 != object) return Boxing.boxBoolean((boolean)false);
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return Boxing.boxBoolean((boolean)false);
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }

                                    private static final int invokeSuspend$lambda$0(SocketChannel $conn, ByteBuffer $readBuffer) {
                                        return $conn.read($readBuffer);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v1 == var13_3) {
                                    return var13_3;
                                }
                                ** GOTO lbl52
                            }
                        }
                        break;
                    }
                    case 1: {
                        conn = (SocketChannel)this.L$4;
                        key = (SelectionKey)this.L$3;
                        keys = (Iterator)this.L$2;
                        readBuffer = (ByteBuffer)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl52:
                        // 2 sources

                        v2 = (Boolean)v1;
                        timedOut = (int)(v2 != null ? v2 : true);
                        Logger.INSTANCE.info("Finished reading, timed out: " + (timedOut != 0));
                        length = readBuffer.position();
                        Intrinsics.checkNotNullExpressionValue((Object)StandardCharsets.UTF_8.decode(readBuffer.flip()).toString(), (String)"toString(...)");
                        Logger.INSTANCE.debug("Got prompt of length " + length + ":\n" + full);
                        var11_13 = new String[]{this.this$0.getSeparator()};
                        split = StringsKt.split$default((CharSequence)full, (String[])var11_13, (boolean)false, (int)0, (int)6, null);
                        if (split.size() == 2) ** GOTO lbl63
                        Logger.INSTANCE.warn("Got incorrect prompt: " + full);
                        ** GOTO lbl11
lbl63:
                        // 1 sources

                        sessionId = (String)split.get(0);
                        prompt = (String)split.get(1);
                        this.L$0 = $this$launch;
                        this.L$1 = readBuffer;
                        this.L$2 = keys;
                        this.L$3 = key;
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)conn);
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)full);
                        this.L$6 = SpillingKt.nullOutSpilledVariable((Object)split);
                        this.L$7 = SpillingKt.nullOutSpilledVariable((Object)sessionId);
                        this.L$8 = SpillingKt.nullOutSpilledVariable((Object)prompt);
                        this.I$0 = timedOut;
                        this.I$1 = length;
                        this.label = 2;
                        v3 = this.$requestInput.emit((Object)new RequestInput(conn, sessionId, full, prompt), (Continuation)this);
                        if (v3 == var13_3) {
                            return var13_3;
                        }
                        ** GOTO lbl94
                    }
                    case 2: {
                        length = this.I$1;
                        timedOut = this.I$0;
                        prompt = (String)this.L$8;
                        sessionId = (String)this.L$7;
                        split = (List)this.L$6;
                        full = (String)this.L$5;
                        conn = (SocketChannel)this.L$4;
                        key = (SelectionKey)this.L$3;
                        keys = (Iterator)this.L$2;
                        readBuffer = (ByteBuffer)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl94:
                        // 3 sources

                        if (!key.isWritable()) ** GOTO lbl11
                        v4 = key.channel();
                        Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type java.nio.channels.SocketChannel");
                        conn = (SocketChannel)v4;
                        if ((String)AskpassSocketImpl.access$getAnswers$p(this.this$0).get(conn) != null) {
                            $i$a$-let-AskpassSocketImpl$runInScope$1$1 = false;
                            v5 = answer.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getBytes(...)");
                            data = ByteBuffer.wrap(v5);
                            while (data.hasRemaining()) {
                                conn.write(data);
                            }
                        }
                        AskpassSocketImpl.access$getAnswers$p(this.this$0).remove(conn);
                        conn.close();
                        ** GOTO lbl11
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        boolean bl = false;
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)it), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableSharedFlow<RequestInput>)requestInput2, this, null){
            int label;
            final /* synthetic */ MutableSharedFlow<RequestInput> $requestInput;
            final /* synthetic */ AskpassSocketImpl this$0;
            {
                this.$requestInput = $requestInput;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$requestInput.collect(new FlowCollector(this.this$0){
                            final /* synthetic */ AskpassSocketImpl this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(RequestInput requestInput2, Continuation<? super Unit> $completion) {
                                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(requestInput2, this.this$0, null){
                                    Object L$0;
                                    Object L$1;
                                    Object L$2;
                                    Object L$3;
                                    int label;
                                    final /* synthetic */ RequestInput $requestInput;
                                    final /* synthetic */ AskpassSocketImpl this$0;
                                    {
                                        this.$requestInput = $requestInput;
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                var2_3 = this.$requestInput;
                                                conn = var2_3.component1();
                                                sessionId = var2_3.component2();
                                                full = var2_3.component3();
                                                prompt = var2_3.component4();
                                                this.L$0 = conn;
                                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)sessionId);
                                                this.L$2 = full;
                                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)prompt);
                                                this.label = 1;
                                                v0 = AskpassSocketImpl.access$getAskpassHandler$p(this.this$0).handleAskpass(sessionId, prompt, (Continuation<? super String>)((Continuation)this));
                                                if (v0 == var12_2) {
                                                    return var12_2;
                                                }
                                                ** GOTO lbl26
                                            }
                                            case 1: {
                                                prompt = (String)this.L$3;
                                                full = (String)this.L$2;
                                                sessionId = (String)this.L$1;
                                                conn = (SocketChannel)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl26:
                                                // 2 sources

                                                v1 = answer = (String)v0;
                                                if (v1 != null) {
                                                    var8_11 = v1;
                                                    var9_12 = this.this$0;
                                                    res = var8_11;
                                                    $i$a$-let-AskpassSocketImpl$runInScope$2$1$1$1$1 = false;
                                                    AskpassSocketImpl.access$getAnswers$p(var9_12).put(conn, res);
                                                } else {
                                                    Logger.INSTANCE.warn("Unhandled prompt:\n" + full);
                                                }
                                                conn.register(AskpassSocketImpl.access$getSelector$p(this.this$0), 4);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return job2;
    }

    public static final /* synthetic */ Selector access$getSelector$p(AskpassSocketImpl $this) {
        return $this.selector;
    }

    public static final /* synthetic */ ServerSocketChannel access$getServerSocketChannel$p(AskpassSocketImpl $this) {
        return $this.serverSocketChannel;
    }

    public static final /* synthetic */ long access$getConnectionTimeout$cp() {
        return connectionTimeout;
    }

    public static final /* synthetic */ Map access$getAnswers$p(AskpassSocketImpl $this) {
        return $this.answers;
    }

    public static final /* synthetic */ AskpassHandler access$getAskpassHandler$p(AskpassSocketImpl $this) {
        return $this.askpassHandler;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private static final class RequestInput {
        @NotNull
        private final SocketChannel conn;
        @NotNull
        private final String sessionId;
        @NotNull
        private final String full;
        @NotNull
        private final String prompt;

        public RequestInput(@NotNull SocketChannel conn, @NotNull String sessionId, @NotNull String full, @NotNull String prompt) {
            Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
            this.conn = conn;
            this.sessionId = sessionId;
            this.full = full;
            this.prompt = prompt;
        }

        @NotNull
        public final SocketChannel component1() {
            return this.conn;
        }

        @NotNull
        public final String component2() {
            return this.sessionId;
        }

        @NotNull
        public final String component3() {
            return this.full;
        }

        @NotNull
        public final String component4() {
            return this.prompt;
        }

        @NotNull
        public String toString() {
            return "RequestInput(conn=" + this.conn + ", sessionId=" + this.sessionId + ", full=" + this.full + ", prompt=" + this.prompt + ")";
        }

        public int hashCode() {
            int result2 = this.conn.hashCode();
            result2 = result2 * 31 + this.sessionId.hashCode();
            result2 = result2 * 31 + this.full.hashCode();
            result2 = result2 * 31 + this.prompt.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RequestInput)) {
                return false;
            }
            RequestInput requestInput2 = (RequestInput)other;
            if (!Intrinsics.areEqual((Object)this.conn, (Object)requestInput2.conn)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sessionId, (Object)requestInput2.sessionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.full, (Object)requestInput2.full)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.prompt, (Object)requestInput2.prompt);
        }
    }
}

