/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.opensshAskpass;

import com.jetbrains.toolbox.TestUtil;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.integration.OSIntegrationManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class AskpassScriptDeployer {
    @NotNull
    private final OSIntegrationManager osIntegrationManager;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Lazy askpassExecutableLocation$delegate;

    public AskpassScriptDeployer(@NotNull OSIntegrationManager osIntegrationManager, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)osIntegrationManager, (String)"osIntegrationManager");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.osIntegrationManager = osIntegrationManager;
        this.fileSystem = fileSystem;
        this.askpassExecutableLocation$delegate = LazyKt.lazy(() -> AskpassScriptDeployer.askpassExecutableLocation_delegate$lambda$0(this));
    }

    @NotNull
    public final Path getAskpassExecutableLocation() {
        Lazy lazy = this.askpassExecutableLocation$delegate;
        return (Path)lazy.getValue();
    }

    private final Path getAskpassExeLocation(FileSystem $this$getAskpassExeLocation) {
        String name2 = OS.INSTANCE.isWindows() ? "askpass.exe" : "askpass";
        Path appParent = this.osIntegrationManager.getApplicationExecutable().parent();
        if (appParent == null) {
            Logger.INSTANCE.warn("Cannot resolve parent of the application file " + appParent);
        } else {
            Path appFileSibling = Path.resolve$default((Path)appParent, (String)name2, (boolean)false, (int)2, null);
            if ($this$getAskpassExeLocation.exists(appFileSibling)) {
                return appFileSibling;
            }
            Logger.INSTANCE.info("Didn't find " + name2 + " near the application file (in " + appParent + ")");
        }
        if (TestUtil.INSTANCE.isLookupAllowed()) {
            Path inAppTestDir;
            Path inNativeBinDir;
            Path inAppBinDir;
            java.nio.file.Path path2 = TestUtil.INSTANCE.resolveFromCheckoutRootOrNull("build/bin/" + name2);
            Path path3 = inAppBinDir = path2 != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (java.nio.file.Path)path2, (boolean)false, (int)1, null) : null;
            if (inAppBinDir != null && $this$getAskpassExeLocation.exists(inAppBinDir)) {
                return inAppBinDir;
            }
            Logger.INSTANCE.info("Didn't find " + name2 + " in inAppBinDir " + inAppBinDir);
            java.nio.file.Path path4 = TestUtil.INSTANCE.resolveFromCheckoutRootOrNull("native/build/cmake-askpass/" + name2);
            Path path5 = inNativeBinDir = path4 != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (java.nio.file.Path)path4, (boolean)false, (int)1, null) : null;
            if (inNativeBinDir != null && $this$getAskpassExeLocation.exists(inNativeBinDir)) {
                return inNativeBinDir;
            }
            Logger.INSTANCE.info("Didn't find " + name2 + " in inNativeBinDir " + inNativeBinDir);
            java.nio.file.Path path6 = TestUtil.INSTANCE.resolveFromCheckoutRootOrNull("build/test/" + name2);
            Path path7 = inAppTestDir = path6 != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (java.nio.file.Path)path6, (boolean)false, (int)1, null) : null;
            if (inAppTestDir != null && $this$getAskpassExeLocation.exists(inAppTestDir)) {
                return inAppTestDir;
            }
            Logger.INSTANCE.info("Didn't find " + name2 + " in inAppTestDir");
        }
        throw new IllegalStateException(("Failed to locate " + name2 + " executable").toString());
    }

    private static final Path askpassExecutableLocation_delegate$lambda$0(AskpassScriptDeployer this$0) {
        return this$0.getAskpassExeLocation(this$0.fileSystem);
    }
}

