/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.openssh;

import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConnectionInfo {
    @NotNull
    private final String id;
    @NotNull
    private final String host;
    @Nullable
    private final String userName;
    @Nullable
    private final Integer port;
    @Nullable
    private final List<String> privateKeyPaths;
    @Nullable
    private final String sshConfigPath;
    private final boolean shouldUseSystemConfiguration;
    private final boolean shouldUseSystemSshAgent;
    private final boolean shouldAskForPassword;
    @Nullable
    private final String sshExecutablePath;
    @Nullable
    private final String sshAddExecutablePath;
    @NotNull
    private final String askpassExecutablePath;
    @NotNull
    private final Map<String, String> environment;

    public ConnectionInfo(@NotNull String id, @NotNull String host, @Nullable String userName, @Nullable Integer port2, @Nullable List<String> privateKeyPaths, @Nullable String sshConfigPath, boolean shouldUseSystemConfiguration, boolean shouldUseSystemSshAgent, boolean shouldAskForPassword, @Nullable String sshExecutablePath, @Nullable String sshAddExecutablePath, @NotNull String askpassExecutablePath, @NotNull Map<String, String> environment) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)askpassExecutablePath, (String)"askpassExecutablePath");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        this.id = id;
        this.host = host;
        this.userName = userName;
        this.port = port2;
        this.privateKeyPaths = privateKeyPaths;
        this.sshConfigPath = sshConfigPath;
        this.shouldUseSystemConfiguration = shouldUseSystemConfiguration;
        this.shouldUseSystemSshAgent = shouldUseSystemSshAgent;
        this.shouldAskForPassword = shouldAskForPassword;
        this.sshExecutablePath = sshExecutablePath;
        this.sshAddExecutablePath = sshAddExecutablePath;
        this.askpassExecutablePath = askpassExecutablePath;
        this.environment = environment;
    }

    public /* synthetic */ ConnectionInfo(String string, String string2, String string3, Integer n, List list2, String string4, boolean bl, boolean bl2, boolean bl3, String string5, String string6, String string7, Map map2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        if ((n2 & 0x80) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x100) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x200) != 0) {
            string5 = null;
        }
        if ((n2 & 0x400) != 0) {
            string6 = null;
        }
        this(string, string2, string3, n, list2, string4, bl, bl2, bl3, string5, string6, string7, map2);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final String getUserName() {
        return this.userName;
    }

    @Nullable
    public final Integer getPort() {
        return this.port;
    }

    @Nullable
    public final List<String> getPrivateKeyPaths() {
        return this.privateKeyPaths;
    }

    @Nullable
    public final String getSshConfigPath() {
        return this.sshConfigPath;
    }

    public final boolean getShouldUseSystemConfiguration() {
        return this.shouldUseSystemConfiguration;
    }

    public final boolean getShouldUseSystemSshAgent() {
        return this.shouldUseSystemSshAgent;
    }

    @Nullable
    public final String getSshExecutablePath() {
        return this.sshExecutablePath;
    }

    @NotNull
    public final String getAskpassExecutablePath() {
        return this.askpassExecutablePath;
    }

    @NotNull
    public final Map<String, String> getEnvironment() {
        return this.environment;
    }

    @NotNull
    public String toString() {
        return "ConnectionInfo(id=" + this.id + ", host=" + this.host + ", userName=" + this.userName + ", port=" + this.port + ", privateKeyPaths=" + this.privateKeyPaths + ", sshConfigPath=" + this.sshConfigPath + ", shouldUseSystemConfiguration=" + this.shouldUseSystemConfiguration + ", shouldUseSystemSshAgent=" + this.shouldUseSystemSshAgent + ", shouldAskForPassword=" + this.shouldAskForPassword + ", sshExecutablePath=" + this.sshExecutablePath + ", sshAddExecutablePath=" + this.sshAddExecutablePath + ", askpassExecutablePath=" + this.askpassExecutablePath + ", environment=" + this.environment + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.host.hashCode();
        result2 = result2 * 31 + (this.userName == null ? 0 : this.userName.hashCode());
        result2 = result2 * 31 + (this.port == null ? 0 : ((Object)this.port).hashCode());
        result2 = result2 * 31 + (this.privateKeyPaths == null ? 0 : ((Object)this.privateKeyPaths).hashCode());
        result2 = result2 * 31 + (this.sshConfigPath == null ? 0 : this.sshConfigPath.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.shouldUseSystemConfiguration);
        result2 = result2 * 31 + Boolean.hashCode(this.shouldUseSystemSshAgent);
        result2 = result2 * 31 + Boolean.hashCode(this.shouldAskForPassword);
        result2 = result2 * 31 + (this.sshExecutablePath == null ? 0 : this.sshExecutablePath.hashCode());
        result2 = result2 * 31 + (this.sshAddExecutablePath == null ? 0 : this.sshAddExecutablePath.hashCode());
        result2 = result2 * 31 + this.askpassExecutablePath.hashCode();
        result2 = result2 * 31 + ((Object)this.environment).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConnectionInfo)) {
            return false;
        }
        ConnectionInfo connectionInfo = (ConnectionInfo)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)connectionInfo.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)connectionInfo.host)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userName, (Object)connectionInfo.userName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.port, (Object)connectionInfo.port)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.privateKeyPaths, connectionInfo.privateKeyPaths)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sshConfigPath, (Object)connectionInfo.sshConfigPath)) {
            return false;
        }
        if (this.shouldUseSystemConfiguration != connectionInfo.shouldUseSystemConfiguration) {
            return false;
        }
        if (this.shouldUseSystemSshAgent != connectionInfo.shouldUseSystemSshAgent) {
            return false;
        }
        if (this.shouldAskForPassword != connectionInfo.shouldAskForPassword) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sshExecutablePath, (Object)connectionInfo.sshExecutablePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sshAddExecutablePath, (Object)connectionInfo.sshAddExecutablePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.askpassExecutablePath, (Object)connectionInfo.askpassExecutablePath)) {
            return false;
        }
        return Intrinsics.areEqual(this.environment, connectionInfo.environment);
    }
}

