/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.openssh;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.common.io.InputStreamRepeatableFlow;
import com.jetbrains.toolbox.openssh.AbstractOpenSshProcess;
import com.jetbrains.toolbox.openssh.AbstractOpenSshProcess$getEvents$;
import com.jetbrains.toolbox.openssh.OpenSshProcess;
import com.jetbrains.toolbox.openssh.SshError;
import com.jetbrains.toolbox.openssh.SshEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CompletionStage;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nAbstractOpenSshProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractOpenSshProcess.kt\ncom/jetbrains/toolbox/openssh/AbstractOpenSshProcess\n+ 2 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 3 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 4 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n49#2:176\n51#2:180\n46#3:177\n51#3:179\n105#4:178\n1#5:181\n*S KotlinDebug\n*F\n+ 1 AbstractOpenSshProcess.kt\ncom/jetbrains/toolbox/openssh/AbstractOpenSshProcess\n*L\n85#1:176\n85#1:180\n85#1:177\n85#1:179\n85#1:178\n*E\n"})
public abstract class AbstractOpenSshProcess
implements OpenSshProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessBuilder processBuilder;
    @Nullable
    private final SshError.SshAgentConflict sshAgentConflict;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MutableStateFlow<Process> process;
    @NotNull
    private final CompletableDeferred<InputStreamRepeatableFlow> stdout;
    @NotNull
    private final CompletableDeferred<InputStreamRepeatableFlow> stderr;
    @NotNull
    private final MutableSharedFlow<EventElement> eventSharedFlow;
    @NotNull
    private final MutableStateFlow<String> currenAuthHost;
    @NotNull
    private static final Regex AUTHENTICATION_FAILED = new Regex("Permission denied|bad passphrase given, try again");
    @NotNull
    private static final Regex AUTH_START_REGEX = new Regex("Authenticating to (.*) as '(.*)'");
    @NotNull
    private static final Regex AUTH_METHOD_REGEX = new Regex("Next authentication method: (.*)");
    @NotNull
    private static final Regex ASKPASS_REQUESTED = new Regex("read_passphrase: requested to askpass|read_passphrase: can't open /dev/tty");
    @NotNull
    private static final Regex CONNECTION_TIMED_OUT = new Regex("ssh: connect to host (.*): Connection timed out");

    public AbstractOpenSshProcess(@NotNull ProcessBuilder processBuilder, @Nullable SshError.SshAgentConflict sshAgentConflict, @NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.processBuilder = processBuilder;
        this.sshAgentConflict = sshAgentConflict;
        this.scope = scope2;
        this.process = StateFlowKt.MutableStateFlow(null);
        this.stdout = CompletableDeferredKt.CompletableDeferred(null);
        this.stderr = CompletableDeferredKt.CompletableDeferred(null);
        this.eventSharedFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.currenAuthHost = StateFlowKt.MutableStateFlow(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void startProcess() {
        AbstractOpenSshProcess abstractOpenSshProcess = this;
        synchronized (abstractOpenSshProcess) {
            boolean bl = false;
            Process startedProcess = this.processBuilder.start();
            this.process.setValue((Object)startedProcess);
            String string = startedProcess.pid() + " stdout";
            InputStream inputStream = startedProcess.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            this.stdout.complete((Object)new InputStreamRepeatableFlow(string, inputStream));
            String string2 = startedProcess.pid() + " stderr";
            InputStream inputStream2 = startedProcess.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
            InputStreamRepeatableFlow error2 = new InputStreamRepeatableFlow(string2, inputStream2);
            this.stderr.complete((Object)error2);
            this.eventsJob(this.scope);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean isFinished() {
        Process process2 = (Process)this.process.getValue();
        return !(process2 != null ? process2.isAlive() : false);
    }

    @Override
    @Nullable
    public Object awaitFinished(@NotNull Continuation<? super Integer> $completion) {
        return AbstractOpenSshProcess.awaitFinished$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object awaitFinished$suspendImpl(AbstractOpenSshProcess $this, Continuation<? super Integer> $completion) {
        if (!($completion instanceof awaitFinished.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractOpenSshProcess this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractOpenSshProcess.awaitFinished$suspendImpl(this.this$0, (Continuation<? super Integer>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.label = 1;
                v0 = FlowExtensionsKt.firstNotNull((StateFlow)$this.process, $continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this = (AbstractOpenSshProcess)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = ((Process)v0).onExit();
                Intrinsics.checkNotNullExpressionValue(v1, (String)"onExit(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.label = 2;
                v2 = FutureKt.await((CompletionStage)v1, (Continuation)$continuation);
                if (v2 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl34
            }
            case 2: {
                $this = (AbstractOpenSshProcess)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl34:
                // 2 sources

                return Boxing.boxInt((int)((Process)v2).exitValue());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void consumeInput(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Process process2 = (Process)this.process.getValue();
        if (process2 == null) {
            throw new IllegalStateException("Cannot write input because process is not yet started");
        }
        Process it = process2;
        boolean bl = false;
        input.transferTo(it.getOutputStream());
        it.getOutputStream().flush();
    }

    @Override
    public void consumeInput(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Process process2 = (Process)this.process.getValue();
        if (process2 == null) {
            throw new IllegalStateException("Cannot write input because process is not yet started");
        }
        Process it = process2;
        boolean bl = false;
        it.getOutputStream().write(array);
        it.getOutputStream().flush();
    }

    @Override
    public void closeInput() {
        Object object = (Process)this.process.getValue();
        if (object == null || (object = ((Process)object).getOutputStream()) == null) {
            throw new IllegalStateException("Cannot close input because process is not yet started");
        }
        ((OutputStream)object).close();
    }

    @Override
    @Nullable
    public Object getOutput(@NotNull Continuation<? super Flow<String>> $completion) {
        return AbstractOpenSshProcess.getOutput$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object getOutput$suspendImpl(AbstractOpenSshProcess $this, Continuation<? super Flow<String>> $completion) {
        if (!($completion instanceof getOutput.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractOpenSshProcess this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractOpenSshProcess.getOutput$suspendImpl(this.this$0, (Continuation<? super Flow<String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.label = 1;
                v0 = $this.stdout.await((Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this = (AbstractOpenSshProcess)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return ((InputStreamRepeatableFlow)v0).getFlow();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object getErrorOutput(@NotNull Continuation<? super Flow<String>> $completion) {
        return AbstractOpenSshProcess.getErrorOutput$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object getErrorOutput$suspendImpl(AbstractOpenSshProcess $this, Continuation<? super Flow<String>> $completion) {
        if (!($completion instanceof getErrorOutput.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractOpenSshProcess this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractOpenSshProcess.getErrorOutput$suspendImpl(this.this$0, (Continuation<? super Flow<String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.label = 1;
                v0 = $this.stderr.await((Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this = (AbstractOpenSshProcess)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return ((InputStreamRepeatableFlow)v0).getFlow();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void close(boolean forcefully) {
        block1: {
            block0: {
                if (!forcefully) break block0;
                Object object = (Process)this.process.getValue();
                if (object == null || (object = ((Process)object).toHandle()) == null) break block1;
                object.destroyForcibly();
                break block1;
            }
            Object object = (Process)this.process.getValue();
            if (object == null || (object = ((Process)object).toHandle()) == null) break block1;
            object.destroy();
        }
    }

    @Override
    @NotNull
    public Flow<SshEvent> getEvents() {
        Flow $this$map$iv = FlowKt.takeWhile((Flow)((Flow)this.eventSharedFlow), (Function2)((Function2)new Function2<EventElement, Continuation<? super Boolean>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                EventElement eventElement = (EventElement)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        return Boxing.boxBoolean((!Intrinsics.areEqual((Object)it, (Object)EventElement.End.INSTANCE) ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(EventElement p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        boolean $i$f$map = false;
        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return (Flow)new Flow<SshEvent>($this$unsafeTransform$iv$iv){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow2;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    {
                        this.$this_unsafeFlow = $receiver;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object value, Continuation $completion) {
                        if (!($completion instanceof getEvents$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ getEvents$$inlined$map$1$2 this$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = $continuation;
                                var7_8 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                var10_14 = $this$map_u24lambda_u245;
                                var11_15 = (Continuation)$continuation;
                                it = (EventElement)value;
                                $i$a$-map-AbstractOpenSshProcess$getEvents$2 = false;
                                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.openssh.AbstractOpenSshProcess.EventElement.Next");
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                $continuation.label = 1;
                                v0 = var10_14.emit((Object)((EventElement.Next)it).getEvent(), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl39
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                value = $continuation.L$2;
                                $completion = $continuation.L$1;
                                value = $continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl39:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
    }

    @Override
    @Nullable
    public Integer getDynamicForwardingPort() {
        return null;
    }

    private final void eventsJob(CoroutineScope $this$eventsJob) {
        BuildersKt.launch$default((CoroutineScope)$this$eventsJob, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int I$0;
            int label;
            final /* synthetic */ AbstractOpenSshProcess this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block21: {
                    block19: {
                        var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = this.this$0.getErrorOutput((Continuation<? super Flow<String>>)((Continuation)this));
                                ** if (v0 != var8_2) goto lbl11
lbl10:
                                // 1 sources

                                return var8_2;
lbl11:
                                // 1 sources

                                ** GOTO lbl17
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl17:
                                // 2 sources

                                this.label = 2;
                                v1 = ((Flow)v0).collect(new FlowCollector(this.this$0){
                                    final /* synthetic */ AbstractOpenSshProcess this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object emit(String line, Continuation<? super Unit> $completion) {
                                        block28: {
                                            block27: {
                                                block26: {
                                                    block25: {
                                                        block24: {
                                                            block23: {
                                                                block22: {
                                                                    if (!($completion instanceof eventsJob.emit.1)) ** GOTO lbl-1000
                                                                    var10_3 = $completion;
                                                                    if ((var10_3.label & -2147483648) != 0) {
                                                                        var10_3.label -= -2147483648;
                                                                    } else lbl-1000:
                                                                    // 2 sources

                                                                    {
                                                                        $continuation = new ContinuationImpl(this, $completion){
                                                                            Object L$0;
                                                                            Object L$1;
                                                                            Object L$2;
                                                                            Object L$3;
                                                                            int I$0;
                                                                            /* synthetic */ Object result;
                                                                            final /* synthetic */ eventsJob.1<T> this$0;
                                                                            int label;
                                                                            {
                                                                                this.this$0 = this$0;
                                                                                super($completion);
                                                                            }

                                                                            public final Object invokeSuspend(Object $result) {
                                                                                this.result = $result;
                                                                                this.label |= Integer.MIN_VALUE;
                                                                                return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                                                            }
                                                                        };
                                                                    }
                                                                    $result = $continuation.result;
                                                                    var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                    switch ($continuation.label) {
                                                                        case 0: {
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            var3_6 = line;
                                                                            if (!AbstractOpenSshProcess.access$getAUTHENTICATION_FAILED$cp().containsMatchIn(var3_6)) break;
                                                                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)line);
                                                                            $continuation.label = 1;
                                                                            v0 = AbstractOpenSshProcess.access$getEventSharedFlow$p(this.this$0).emit((Object)new EventElement.Next(SshEvent.AuthenticationFailed.INSTANCE), (Continuation)$continuation);
                                                                            if (v0 == var11_5) {
                                                                                return var11_5;
                                                                            }
                                                                            ** GOTO lbl24
                                                                        }
                                                                        case 1: {
                                                                            line = (String)$continuation.L$0;
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            v0 = $result;
lbl24:
                                                                            // 2 sources

                                                                            return Unit.INSTANCE;
                                                                        }
                                                                    }
                                                                    if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"Authenticated to", (boolean)false, (int)2, null)) break block22;
                                                                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)line);
                                                                    $continuation.label = 2;
                                                                    v1 = AbstractOpenSshProcess.access$getEventSharedFlow$p(this.this$0).emit((Object)new EventElement.Next(SshEvent.AuthenticationFinished.INSTANCE), (Continuation)$continuation);
                                                                    if (v1 == var11_5) {
                                                                        return var11_5;
                                                                    }
                                                                    ** GOTO lbl36
                                                                    {
                                                                        case 2: {
                                                                            line = (String)$continuation.L$0;
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            v1 = $result;
lbl36:
                                                                            // 2 sources

                                                                            AbstractOpenSshProcess.access$getCurrenAuthHost$p(this.this$0).setValue(null);
                                                                            break;
                                                                        }
                                                                    }
                                                                }
                                                                var3_6 = line;
                                                                if (!AbstractOpenSshProcess.Companion.getASKPASS_REQUESTED().containsMatchIn(var3_6)) break block23;
                                                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)line);
                                                                $continuation.label = 3;
                                                                v2 = AbstractOpenSshProcess.access$getEventSharedFlow$p(this.this$0).emit((Object)new EventElement.Next(SshEvent.AskpassRequested.INSTANCE), (Continuation)$continuation);
                                                                if (v2 == var11_5) {
                                                                    return var11_5;
                                                                }
                                                                ** GOTO lbl51
                                                                {
                                                                    case 3: {
                                                                        line = (String)$continuation.L$0;
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v2 = $result;
lbl51:
                                                                        // 2 sources

                                                                        return Unit.INSTANCE;
                                                                    }
                                                                }
                                                            }
                                                            if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"open failed: administratively prohibited", (boolean)false, (int)2, null)) break block24;
                                                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)line);
                                                            $continuation.label = 4;
                                                            v3 = AbstractOpenSshProcess.access$getEventSharedFlow$p(this.this$0).emit((Object)new EventElement.Next(SshError.ForwardingProhibited.INSTANCE), (Continuation)$continuation);
                                                            if (v3 == var11_5) {
                                                                return var11_5;
                                                            }
                                                            ** GOTO lbl64
                                                            {
                                                                case 4: {
                                                                    line = (String)$continuation.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v3 = $result;
lbl64:
                                                                    // 2 sources

                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                        }
                                                        var3_6 = line;
                                                        if (!AbstractOpenSshProcess.access$getCONNECTION_TIMED_OUT$cp().containsMatchIn(var3_6)) break block25;
                                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)line);
                                                        $continuation.label = 5;
                                                        v4 = AbstractOpenSshProcess.access$getEventSharedFlow$p(this.this$0).emit((Object)new EventElement.Next(SshError.ConnectionTimeout.INSTANCE), (Continuation)$continuation);
                                                        if (v4 == var11_5) {
                                                            return var11_5;
                                                        }
                                                        ** GOTO lbl78
                                                        {
                                                            case 5: {
                                                                line = (String)$continuation.L$0;
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v4 = $result;
lbl78:
                                                                // 2 sources

                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                    }
                                                    authStartMatch = Regex.find$default((Regex)AbstractOpenSshProcess.access$getAUTH_START_REGEX$cp(), (CharSequence)line, (int)0, (int)2, null);
                                                    if (authStartMatch == null) break block26;
                                                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)line);
                                                    $continuation.L$1 = authStartMatch;
                                                    $continuation.label = 6;
                                                    v5 = AbstractOpenSshProcess.access$getEventSharedFlow$p(this.this$0).emit((Object)new EventElement.Next(new SshEvent.AuthenticationStarted((String)authStartMatch.getGroupValues().get(1), (String)authStartMatch.getGroupValues().get(2))), (Continuation)$continuation);
                                                    if (v5 == var11_5) {
                                                        return var11_5;
                                                    }
                                                    ** GOTO lbl94
                                                    {
                                                        case 6: {
                                                            authStartMatch = (MatchResult)$continuation.L$1;
                                                            line = (String)$continuation.L$0;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            v5 = $result;
lbl94:
                                                            // 2 sources

                                                            AbstractOpenSshProcess.access$getCurrenAuthHost$p(this.this$0).setValue(authStartMatch.getGroupValues().get(1));
                                                            break;
                                                        }
                                                    }
                                                }
                                                authMethodMatch = Regex.find$default((Regex)AbstractOpenSshProcess.access$getAUTH_METHOD_REGEX$cp(), (CharSequence)line, (int)0, (int)2, null);
                                                if (authMethodMatch == null) break block27;
                                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)line);
                                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)authStartMatch);
                                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)authMethodMatch);
                                                $continuation.label = 7;
                                                v6 = AbstractOpenSshProcess.access$getEventSharedFlow$p(this.this$0).emit((Object)new EventElement.Next(new SshEvent.AuthenticationMethodStarted((String)authMethodMatch.getGroupValues().get(1))), (Continuation)$continuation);
                                                if (v6 == var11_5) {
                                                    return var11_5;
                                                }
                                                ** GOTO lbl113
                                                {
                                                    case 7: {
                                                        authMethodMatch = (MatchResult)$continuation.L$2;
                                                        authStartMatch = (MatchResult)$continuation.L$1;
                                                        line = (String)$continuation.L$0;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v6 = $result;
lbl113:
                                                        // 2 sources

                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                            }
                                            v7 = AbstractOpenSshProcess.access$findError(this.this$0, line);
                                            if (v7 != null) {
                                                var5_12 = v7;
                                                var6_13 = this.this$0;
                                                it = var5_12;
                                                $i$a$-let-AbstractOpenSshProcess$eventsJob$1$1$1 = 0;
                                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)line);
                                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)authStartMatch);
                                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)authMethodMatch);
                                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)it);
                                                $continuation.I$0 = $i$a$-let-AbstractOpenSshProcess$eventsJob$1$1$1;
                                                $continuation.label = 8;
                                                v8 = AbstractOpenSshProcess.access$getEventSharedFlow$p(var6_13).emit((Object)new EventElement.Next(it), (Continuation)$continuation);
                                                if (v8 == var11_5) {
                                                    return var11_5;
                                                }
                                            }
                                            break block28;
                                            {
                                                case 8: {
                                                    $i$a$-let-AbstractOpenSshProcess$eventsJob$1$1$1 = $continuation.I$0;
                                                    it = (SshError)$continuation.L$3;
                                                    authMethodMatch = (MatchResult)$continuation.L$2;
                                                    authStartMatch = (MatchResult)$continuation.L$1;
                                                    line = (String)$continuation.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v8 = $result;
                                                }
                                            }
                                        }
                                        return Unit.INSTANCE;
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                }, (Continuation)this);
                                ** if (v1 != var8_2) goto lbl21
lbl20:
                                // 1 sources

                                return var8_2;
lbl21:
                                // 1 sources

                                ** GOTO lbl27
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl27:
                                // 2 sources

                                v2 = AbstractOpenSshProcess.access$getSshAgentConflict$p(this.this$0);
                                if (v2 == null) break;
                                var3_3 = v2;
                                var4_4 = this.this$0;
                                it = var3_3;
                                $i$a$-let-AbstractOpenSshProcess$eventsJob$1$2 = 0;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                this.I$0 = $i$a$-let-AbstractOpenSshProcess$eventsJob$1$2;
                                this.label = 3;
                                v3 = AbstractOpenSshProcess.access$getEventSharedFlow$p(var4_4).emit((Object)new EventElement.Next(it), (Continuation)this);
                                if (v3 == var8_2) {
                                    return var8_2;
                                }
                                break;
                            }
                            case 3: {
                                $i$a$-let-AbstractOpenSshProcess$eventsJob$1$2 = this.I$0;
                                it = (SshError.SshAgentConflict)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
                                break;
                            }
                        }
                        this.L$0 = null;
                        this.label = 4;
                        v4 = AbstractOpenSshProcess.access$getEventSharedFlow$p(this.this$0).emit((Object)EventElement.End.INSTANCE, (Continuation)this);
                        if (v4 == var8_2) {
                            return var8_2;
                        }
                        break block21;
                        {
                            case 4: {
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
                                break;
                            }
                        }
                        catch (Throwable var2_13) {
                            v5 = AbstractOpenSshProcess.access$getSshAgentConflict$p(this.this$0);
                            if (v5 == null) break block19;
                            var4_5 = v5;
                            var5_8 = this.this$0;
                            it = var4_5;
                            $i$a$-let-AbstractOpenSshProcess$eventsJob$1$2 = 0;
                            this.L$0 = var2_13;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)it);
                            this.I$0 = $i$a$-let-AbstractOpenSshProcess$eventsJob$1$2;
                            this.label = 5;
                            v6 = AbstractOpenSshProcess.access$getEventSharedFlow$p(var5_8).emit((Object)new EventElement.Next(it), (Continuation)this);
                            if (v6 == var8_2) {
                                return var8_2;
                            }
                            break block19;
                        }
                        {
                            case 5: {
                                $i$a$-let-AbstractOpenSshProcess$eventsJob$1$2 = this.I$0;
                                it = (SshError.SshAgentConflict)this.L$1;
                                var2_14 = (Throwable)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v6 = $result;
                            }
                        }
                    }
                    this.L$0 = var2_14;
                    this.L$1 = null;
                    this.label = 6;
                    v7 = AbstractOpenSshProcess.access$getEventSharedFlow$p(this.this$0).emit((Object)EventElement.End.INSTANCE, (Continuation)this);
                    if (v7 == var8_2) {
                        return var8_2;
                    }
                    ** GOTO lbl91
                    {
                        case 6: {
                            var2_14 = (Throwable)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v7 = $result;
lbl91:
                            // 2 sources

                            throw var2_14;
                        }
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final SshError findError(String line) {
        SshError.HostKeyVerificationFailed hostKeyVerificationFailed;
        SshError.InaccessibleFile inaccessibleFile;
        SshError.InaccessibleFile inaccessibleFile2;
        SshError.InaccessibleFile inaccessibleFile3;
        SshError.TooWidePermissions tooWidePermissions;
        SshError sshError;
        SshError.UnresolvedHostname unresolvedHostname;
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        Object[] objectArray3 = objectArray2 = new SshError[11];
        int n2 = 0;
        MatchResult matchResult = Regex.find$default((Regex)new Regex("Could not resolve hostname (.*): (.*)"), (CharSequence)line, (int)0, (int)2, null);
        if (matchResult != null) {
            void match2;
            MatchResult matchResult2 = matchResult;
            n = n2;
            objectArray = objectArray3;
            boolean bl6 = false;
            SshError.UnresolvedHostname unresolvedHostname2 = new SshError.UnresolvedHostname((String)match2.getGroupValues().get(1), (String)match2.getGroupValues().get(2));
            objectArray3 = objectArray;
            n2 = n;
            unresolvedHostname = unresolvedHostname2;
        } else {
            unresolvedHostname = null;
        }
        objectArray3[n2] = unresolvedHostname;
        SshError.AuthenticationError authenticationError = sshError = SshError.AuthenticationError.INSTANCE;
        n = 1;
        objectArray = objectArray2;
        boolean bl = false;
        boolean bl2 = StringsKt.contains$default((CharSequence)line, (CharSequence)"Too many authentication failures", (boolean)false, (int)2, null);
        objectArray[n] = bl2 ? sshError : null;
        SshError it = sshError = SshError.HostUnreachable.INSTANCE;
        n = 2;
        objectArray = objectArray2;
        boolean bl3 = false;
        bl2 = StringsKt.contains$default((CharSequence)line, (CharSequence)"Network is unreachable", (boolean)false, (int)2, null);
        objectArray[n] = bl2 ? sshError : null;
        it = sshError = SshError.ConnectionRefused.INSTANCE;
        n = 3;
        objectArray = objectArray2;
        boolean bl4 = false;
        bl2 = StringsKt.contains$default((CharSequence)line, (CharSequence)"Connection refused", (boolean)false, (int)2, null);
        objectArray[n] = bl2 ? sshError : null;
        it = sshError = SshError.ConnectionRefused.INSTANCE;
        n = 4;
        objectArray = objectArray2;
        boolean bl52 = false;
        CharSequence bl6 = line;
        bl2 = new Regex("(Connection closed by remote host|Connection to (.*) closed by remote host|Connection reset by peer)").containsMatchIn(bl6);
        objectArray[n] = bl2 ? sshError : null;
        Object[] objectArray4 = objectArray2;
        int n3 = 5;
        MatchResult matchResult3 = Regex.find$default((Regex)new Regex("Load key \"(.*)\": bad permissions"), (CharSequence)line, (int)0, (int)2, null);
        if (matchResult3 != null) {
            void match3;
            MatchResult bl52 = matchResult3;
            n = n3;
            objectArray = objectArray4;
            boolean bl7 = false;
            SshError.TooWidePermissions tooWidePermissions2 = new SshError.TooWidePermissions((String)match3.getGroupValues().get(1));
            objectArray4 = objectArray;
            n3 = n;
            tooWidePermissions = tooWidePermissions2;
        } else {
            tooWidePermissions = null;
        }
        objectArray4[n3] = tooWidePermissions;
        it = sshError = SshError.AuthenticationError.INSTANCE;
        n = 6;
        objectArray = objectArray2;
        boolean bl82 = false;
        boolean bl9 = StringsKt.contains$default((CharSequence)line, (CharSequence)"debug1: No more authentication methods to try.", (boolean)false, (int)2, null);
        objectArray[n] = bl9 ? sshError : null;
        Object[] objectArray5 = objectArray2;
        int n4 = 7;
        MatchResult matchResult4 = Regex.find$default((Regex)new Regex("Identity file (.*) not accessible: (.*)"), (CharSequence)line, (int)0, (int)2, null);
        if (matchResult4 != null) {
            void match4;
            MatchResult bl82 = matchResult4;
            n = n4;
            objectArray = objectArray5;
            boolean bl10 = false;
            SshError.InaccessibleFile inaccessibleFile4 = new SshError.InaccessibleFile("key", (String)match4.getGroupValues().get(1), (String)match4.getGroupValues().get(2));
            objectArray5 = objectArray;
            n4 = n;
            inaccessibleFile3 = inaccessibleFile4;
        } else {
            inaccessibleFile3 = null;
        }
        objectArray5[n4] = inaccessibleFile3;
        Object[] objectArray6 = objectArray2;
        int n5 = 8;
        MatchResult matchResult5 = Regex.find$default((Regex)new Regex("no such identity: (.*): (.*)"), (CharSequence)line, (int)0, (int)2, null);
        if (matchResult5 != null) {
            MatchResult match4 = matchResult5;
            n = n5;
            objectArray = objectArray6;
            boolean bl11 = false;
            SshError.InaccessibleFile inaccessibleFile5 = new SshError.InaccessibleFile("key", (String)match4.getGroupValues().get(1), (String)match4.getGroupValues().get(2));
            objectArray6 = objectArray;
            n5 = n;
            inaccessibleFile2 = inaccessibleFile5;
        } else {
            inaccessibleFile2 = null;
        }
        objectArray6[n5] = inaccessibleFile2;
        Object[] objectArray7 = objectArray2;
        int n6 = 9;
        MatchResult matchResult6 = Regex.find$default((Regex)new Regex("Can't open user config file (.*): (.*)"), (CharSequence)line, (int)0, (int)2, null);
        if (matchResult6 != null) {
            MatchResult match5 = matchResult6;
            n = n6;
            objectArray = objectArray7;
            boolean bl12 = false;
            SshError.InaccessibleFile inaccessibleFile6 = new SshError.InaccessibleFile("config", (String)match5.getGroupValues().get(1), (String)match5.getGroupValues().get(2));
            objectArray7 = objectArray;
            n6 = n;
            inaccessibleFile = inaccessibleFile6;
        } else {
            inaccessibleFile = null;
        }
        objectArray7[n6] = inaccessibleFile;
        Object[] objectArray8 = objectArray2;
        int n7 = 10;
        if (Regex.find$default((Regex)new Regex("Host key verification failed"), (CharSequence)line, (int)0, (int)2, null) != null) {
            n = n7;
            objectArray = objectArray8;
            boolean bl13 = false;
            String string = (String)this.currenAuthHost.getValue();
            if (string == null) {
                AbstractOpenSshProcess $this$findError_u24lambda_u2415_u24lambda_u2414 = this;
                boolean bl14 = false;
                Logger.INSTANCE.warn("Got Host key verification failed error but there's no authentication session present");
                string = "null";
            }
            String host = string;
            SshError.HostKeyVerificationFailed hostKeyVerificationFailed2 = new SshError.HostKeyVerificationFailed(host);
            objectArray8 = objectArray;
            n7 = n;
            hostKeyVerificationFailed = hostKeyVerificationFailed2;
        } else {
            hostKeyVerificationFailed = null;
        }
        objectArray8[n7] = hostKeyVerificationFailed;
        return (SshError)CollectionsKt.firstOrNull((List)CollectionsKt.listOfNotNull((Object[])objectArray2));
    }

    public static final /* synthetic */ Regex access$getAUTHENTICATION_FAILED$cp() {
        return AUTHENTICATION_FAILED;
    }

    public static final /* synthetic */ MutableSharedFlow access$getEventSharedFlow$p(AbstractOpenSshProcess $this) {
        return $this.eventSharedFlow;
    }

    public static final /* synthetic */ MutableStateFlow access$getCurrenAuthHost$p(AbstractOpenSshProcess $this) {
        return $this.currenAuthHost;
    }

    public static final /* synthetic */ Regex access$getCONNECTION_TIMED_OUT$cp() {
        return CONNECTION_TIMED_OUT;
    }

    public static final /* synthetic */ Regex access$getAUTH_START_REGEX$cp() {
        return AUTH_START_REGEX;
    }

    public static final /* synthetic */ Regex access$getAUTH_METHOD_REGEX$cp() {
        return AUTH_METHOD_REGEX;
    }

    public static final /* synthetic */ SshError access$findError(AbstractOpenSshProcess $this, String line) {
        return $this.findError(line);
    }

    public static final /* synthetic */ SshError.SshAgentConflict access$getSshAgentConflict$p(AbstractOpenSshProcess $this) {
        return $this.sshAgentConflict;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getASKPASS_REQUESTED() {
            return ASKPASS_REQUESTED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private static sealed interface EventElement {

        public static final class End
        implements EventElement {
            @NotNull
            public static final End INSTANCE = new End();

            private End() {
            }

            @NotNull
            public String toString() {
                return "End";
            }

            public int hashCode() {
                return 1390026298;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof End)) {
                    return false;
                }
                End cfr_ignored_0 = (End)other;
                return true;
            }
        }

        public static final class Next
        implements EventElement {
            @NotNull
            private final SshEvent event;

            public Next(@NotNull SshEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.event = event;
            }

            @NotNull
            public final SshEvent getEvent() {
                return this.event;
            }

            @NotNull
            public String toString() {
                return "Next(event=" + this.event + ")";
            }

            public int hashCode() {
                return this.event.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Next)) {
                    return false;
                }
                Next next2 = (Next)other;
                return Intrinsics.areEqual((Object)this.event, (Object)next2.event);
            }
        }
    }
}

