/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network;

import com.jetbrains.toolbox.network.CustomHeaderContributor;
import com.jetbrains.toolbox.network.CustomHeaderSource;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class UserProvidedCustomHeaderContributor
implements CustomHeaderContributor {
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final CustomHeaderSource source;

    public UserProvidedCustomHeaderContributor(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        this.settingsManager = settingsManager;
        this.source = CustomHeaderSource.USER_DEFINED;
    }

    @Override
    @NotNull
    public CustomHeaderSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Map<String, String> customHeaders() {
        String apiHeaderName = ((SelfSettings)this.settingsManager.getSettings().getValue()).getAdvanced().getApiKeyHeader();
        if (((CharSequence)apiHeaderName).length() == 0) {
            return MapsKt.emptyMap();
        }
        String apiHeaderValue = this.settingsManager.getApiKeyHeaderValue();
        if (((CharSequence)apiHeaderValue).length() == 0) {
            return MapsKt.emptyMap();
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)apiHeaderName, (Object)apiHeaderValue));
    }
}

