/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.i18n.UIRegion;
import com.jetbrains.toolbox.intellij.IntellijPreferenceManager;
import com.jetbrains.toolbox.network.ProxyAuthenticator;
import com.jetbrains.toolbox.network.RegionUrlMapper$httpClientCache$2$1$invokeSuspend$;
import com.jetbrains.toolbox.network.util.OkHttpClientLoggingVerbosityKt;
import com.jetbrains.toolbox.network.util.OkHttpClientProxyKt;
import com.jetbrains.toolbox.network.util.OkHttpClientTimeoutKt;
import com.jetbrains.toolbox.settings.HttpLoggingVerbosity;
import com.jetbrains.toolbox.settings.NetworkSettings;
import com.jetbrains.toolbox.settings.ProxySettings;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nRegionUrlMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegionUrlMapper.kt\ncom/jetbrains/toolbox/network/RegionUrlMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public final class RegionUrlMapper {
    @NotNull
    private final IntellijPreferenceManager intellijPreferenceManager;
    @NotNull
    private final String defaultConfigUrl;
    @NotNull
    private final Map<UIRegion, String> configUrlTable;
    private final LoadingCache<Unit, OkHttpClient> httpClientCache;
    @NotNull
    private final LoadingCache<UIRegion, List<UrlMapping>> cache;
    @NotNull
    private final Interceptor interceptor;

    /*
     * WARNING - void declaration
     */
    private RegionUrlMapper(SettingsManager settingsManager, IntellijPreferenceManager intellijPreferenceManager, ProxyAuthenticator proxyAuthenticator, CoroutineScope coroutineScope, long cacheDataExpiration, String defaultConfigUrl, Map<UIRegion, String> configUrlTable) {
        void clientCache;
        LoadingCache loadingCache;
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)intellijPreferenceManager, (String)"intellijPreferenceManager");
        Intrinsics.checkNotNullParameter((Object)proxyAuthenticator, (String)"proxyAuthenticator");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)defaultConfigUrl, (String)"defaultConfigUrl");
        Intrinsics.checkNotNullParameter(configUrlTable, (String)"configUrlTable");
        this.intellijPreferenceManager = intellijPreferenceManager;
        this.defaultConfigUrl = defaultConfigUrl;
        this.configUrlTable = configUrlTable;
        LoadingCache loadingCache2 = loadingCache = Caffeine.newBuilder().build(arg_0 -> RegionUrlMapper.httpClientCache$lambda$1(arg_0 -> RegionUrlMapper.httpClientCache$lambda$0(settingsManager, proxyAuthenticator, arg_0), arg_0));
        RegionUrlMapper regionUrlMapper = this;
        boolean bl = false;
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(settingsManager, (LoadingCache<Unit, OkHttpClient>)clientCache, null){
            int label;
            final /* synthetic */ SettingsManager $settingsManager;
            final /* synthetic */ LoadingCache<Unit, OkHttpClient> $clientCache;
            {
                this.$settingsManager = $settingsManager;
                this.$clientCache = $clientCache;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Flow $this$map$iv = (Flow)this.$settingsManager.getSettings();
                        boolean $i$f$map = false;
                        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
                        boolean $i$f$unsafeTransform = false;
                        boolean $i$f$unsafeFlow = false;
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.drop((Flow)FlowKt.distinctUntilChanged((Flow)((Flow)new Flow<Triple<? extends ProxySettings, ? extends NetworkSettings, ? extends HttpLoggingVerbosity>>($this$unsafeTransform$iv$iv){
                            final /* synthetic */ Flow $this_unsafeTransform$inlined;
                            {
                                this.$this_unsafeTransform$inlined = flow2;
                            }

                            public Object collect(FlowCollector collector, Continuation $completion) {
                                Continuation continuation = $completion;
                                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                boolean bl = false;
                                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                                    {
                                        this.$this_unsafeFlow = $receiver;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object emit(Object value, Continuation $completion) {
                                        if (!($completion instanceof httpClientCache$2$1$invokeSuspend$$inlined$map$1$2$1)) ** GOTO lbl-1000
                                        var3_3 = $completion;
                                        if ((var3_3.label & -2147483648) != 0) {
                                            var3_3.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            $continuation = new ContinuationImpl(this, $completion){
                                                /* synthetic */ Object result;
                                                int label;
                                                Object L$0;
                                                final /* synthetic */ httpClientCache$2$1$invokeSuspend$$inlined$map$1$2 this$0;
                                                Object L$1;
                                                Object L$2;
                                                Object L$3;
                                                int I$0;
                                                {
                                                    this.this$0 = this$0;
                                                    super($completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return this.this$0.emit(null, (Continuation)this);
                                                }
                                            };
                                        }
                                        $result = $continuation.result;
                                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch ($continuation.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                var6_6 = $continuation;
                                                var7_8 = value;
                                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                                var10_14 = $this$map_u24lambda_u245;
                                                var11_15 = (Continuation)$continuation;
                                                settings = (SelfSettings)value;
                                                $i$a$-map-RegionUrlMapper$httpClientCache$2$1$1 = false;
                                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                                $continuation.label = 1;
                                                v0 = var10_14.emit((Object)new Triple((Object)settings.getProxy(), (Object)settings.getNetwork(), (Object)settings.getAdvanced().getHttpLoggingVerbosity()), (Continuation)$continuation);
                                                if (v0 == var5_5) {
                                                    return var5_5;
                                                }
                                                ** GOTO lbl39
                                            }
                                            case 1: {
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                                value = $continuation.L$2;
                                                $completion = $continuation.L$1;
                                                value = $continuation.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl39:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                }, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        })), (int)1), (Function2)((Function2)new Function2<Triple<? extends ProxySettings, ? extends NetworkSettings, ? extends HttpLoggingVerbosity>, Continuation<? super Unit>, Object>(this.$clientCache, null){
                            int label;
                            final /* synthetic */ LoadingCache<Unit, OkHttpClient> $clientCache;
                            {
                                this.$clientCache = $clientCache;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$clientCache.invalidate((Object)Unit.INSTANCE);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Triple<ProxySettings, NetworkSettings, ? extends HttpLoggingVerbosity> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        regionUrlMapper.httpClientCache = loadingCache;
        LoadingCache loadingCache3 = Caffeine.newBuilder().expireAfter((Expiry)new Expiry<UIRegion, List<? extends UrlMapping>>(this, cacheDataExpiration){
            final /* synthetic */ RegionUrlMapper this$0;
            final /* synthetic */ long $cacheDataExpiration;
            {
                this.this$0 = $receiver;
                this.$cacheDataExpiration = $cacheDataExpiration;
            }

            public long expireAfterCreate(UIRegion key2, List<UrlMapping> value2, long currentTime) {
                long l;
                Intrinsics.checkNotNullParameter((Object)((Object)key2), (String)"key");
                Intrinsics.checkNotNullParameter(value2, (String)"value");
                if (RegionUrlMapper.access$getConfigUrlTable$p(this.this$0).containsKey((Object)((Object)key2))) {
                    long l2 = this.$cacheDataExpiration;
                    int n = Duration.getNanosecondsComponent-impl((long)l2);
                    long l3 = Duration.getInWholeSeconds-impl((long)l2);
                    java.time.Duration duration = java.time.Duration.ofSeconds(l3, n);
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
                    l = duration.toNanos();
                } else {
                    long l4 = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS);
                    int n = Duration.getNanosecondsComponent-impl((long)l4);
                    long l5 = Duration.getInWholeSeconds-impl((long)l4);
                    java.time.Duration duration = java.time.Duration.ofSeconds(l5, n);
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
                    l = duration.toNanos();
                }
                return l;
            }

            public long expireAfterUpdate(UIRegion key2, List<UrlMapping> value2, long currentTime, long currentDuration) {
                Intrinsics.checkNotNullParameter((Object)((Object)key2), (String)"key");
                Intrinsics.checkNotNullParameter(value2, (String)"value");
                if (!(currentDuration >= 0L)) {
                    boolean bl = false;
                    String string = "currentDuration must be non-negative";
                    throw new IllegalArgumentException(string.toString());
                }
                return this.expireAfterCreate(key2, value2, currentTime);
            }

            public long expireAfterRead(UIRegion key2, List<UrlMapping> value2, long currentTime, long currentDuration) {
                Intrinsics.checkNotNullParameter((Object)((Object)key2), (String)"key");
                Intrinsics.checkNotNullParameter(value2, (String)"value");
                if (!(currentDuration >= 0L)) {
                    boolean bl = false;
                    String string = "currentDuration must be non-negative";
                    throw new IllegalArgumentException(string.toString());
                }
                return currentDuration;
            }
        }).build(arg_0 -> RegionUrlMapper.cache$lambda$4(arg_0 -> RegionUrlMapper.cache$lambda$3(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache3, (String)"build(...)");
        this.cache = loadingCache3;
        this.interceptor = new Interceptor(this){
            final /* synthetic */ RegionUrlMapper this$0;
            {
                this.this$0 = $receiver;
            }

            public Response intercept(Interceptor.Chain chain) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                String oldUrl = chain.request().url().toString();
                String newUrl = this.this$0.mapUrl(oldUrl);
                return chain.proceed(!Intrinsics.areEqual((Object)newUrl, (Object)oldUrl) ? chain.request().newBuilder().url(newUrl).build() : chain.request());
            }
        };
    }

    public /* synthetic */ RegionUrlMapper(SettingsManager settingsManager, IntellijPreferenceManager intellijPreferenceManager, ProxyAuthenticator proxyAuthenticator, CoroutineScope coroutineScope, long l, String string, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            l = DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES);
        }
        if ((n & 0x20) != 0) {
            string = "https://www.jetbrains.com/config/JetBrainsResourceMapping.json";
        }
        if ((n & 0x40) != 0) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)UIRegion.CHINA_MAINLAND), (Object)"https://www.jetbrains.com.cn/config/JetBrainsResourceMapping.json"));
        }
        this(settingsManager, intellijPreferenceManager, proxyAuthenticator, coroutineScope, l, string, map2, null);
    }

    private final OkHttpClient getHttpClient() {
        Object object = this.httpClientCache.get((Object)Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (OkHttpClient)object;
    }

    @NotNull
    public final Interceptor getInterceptor() {
        return this.interceptor;
    }

    @NotNull
    public final String mapUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        UIRegion region = (UIRegion)((Object)this.intellijPreferenceManager.getRegion().getValue());
        return this.mapUrl(url, region);
    }

    private final String mapUrl(String url, UIRegion region) {
        for (UrlMapping urlMapping : (List)this.cache.get((Object)region)) {
            String pattern = urlMapping.component1();
            String replacement = urlMapping.component2();
            int entry = StringsKt.indexOf$default((CharSequence)url, (String)pattern, (int)0, (boolean)true, (int)2, null);
            if (entry < 0) continue;
            String string = url.substring(0, entry);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = url.substring(entry + pattern.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String mappedUrl = string + replacement + string2;
            Logger.INSTANCE.trace("Region specific URL mapping " + url + " -> " + mappedUrl + " for region " + region + " by pattern " + pattern + " -> " + replacement);
            return mappedUrl;
        }
        Logger.INSTANCE.trace("Region specific URL mapping for " + url + " for region " + region + " was not found. The original URL will be used.");
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<UrlMapping> loadMappings(UIRegion region) {
        List list2;
        String string = this.configUrlTable.get((Object)region);
        if (string == null) {
            string = this.defaultConfigUrl;
        }
        String configUrl = string;
        Logger.INSTANCE.trace("Loading region-specific url mappings for region " + region + " from " + configUrl);
        try {
            List list3;
            Object response2;
            Closeable closeable = this.getHttpClient().newCall(new Request.Builder().get().url(configUrl).build()).execute();
            Throwable throwable = null;
            try {
                String string2;
                response2 = (Response)closeable;
                boolean bl3 = false;
                if (!((Response)response2).isSuccessful()) {
                    boolean $i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$32 = false;
                    String $i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$32 = "Region URL mapping request to " + configUrl + " failed with status code " + ((Response)response2).code();
                    throw new IllegalStateException($i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$32.toString());
                }
                ResponseBody responseBody = ((Response)response2).body();
                if (!(responseBody != null)) {
                    boolean $i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$42 = false;
                    String $i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$42 = "Region URL mapping request to " + configUrl + " returned an empty response";
                    throw new IllegalStateException($i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$42.toString());
                }
                Closeable $i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$32 = responseBody;
                Throwable $i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$42 = null;
                try {
                    ResponseBody it = (ResponseBody)$i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$32;
                    boolean bl2 = false;
                    string2 = it.string();
                }
                catch (Throwable throwable2) {
                    $i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$42 = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)$i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$32, (Throwable)$i$a$-check-RegionUrlMapper$loadMappings$jsonMappingArray$1$42);
                }
                response2 = string2;
            }
            catch (Throwable bl3) {
                throwable = bl3;
                throw bl3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object stringBody = response2;
            boolean bl = false;
            JsonElement bl3 = JsonKt.getJsonx().parseToJsonElement((String)stringBody);
            JsonArray jsonArray = bl3 instanceof JsonArray ? (JsonArray)bl3 : null;
            if (jsonArray == null) {
                throw new IllegalStateException("Region URL mapping response from " + configUrl + " is not a JSON array");
            }
            JsonArray jsonMappingArray = jsonArray;
            List $this$loadMappings_u24lambda_u2410 = list3 = CollectionsKt.createListBuilder();
            boolean bl4 = false;
            for (JsonElement mapping : jsonMappingArray) {
                Object object = mapping instanceof JsonObject ? (JsonObject)mapping : null;
                Map.Entry entry = object != null && (object = object.entrySet()) != null ? (Map.Entry)CollectionsKt.singleOrNull((Iterable)((Iterable)object)) : null;
                if (entry == null) continue;
                String pattern = (String)entry.getKey();
                JsonElement replacement = (JsonElement)entry.getValue();
                if (!(((CharSequence)pattern).length() > 0)) continue;
                JsonPrimitive jsonPrimitive = replacement instanceof JsonPrimitive ? (JsonPrimitive)replacement : null;
                boolean bl5 = jsonPrimitive != null ? jsonPrimitive.isString() : false;
                if (!bl5) continue;
                $this$loadMappings_u24lambda_u2410.add(new UrlMapping(pattern, ((JsonPrimitive)replacement).getContent()));
            }
            list2 = CollectionsKt.build((List)list3);
        }
        catch (Exception e) {
            Logger.INSTANCE.info((Throwable)e, "Failed to load region-specific url mappings for region " + region + " from " + configUrl);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final OkHttpClient httpClientCache$lambda$0(SettingsManager $settingsManager, ProxyAuthenticator $proxyAuthenticator, Unit it) {
        SelfSettings settings2 = (SelfSettings)$settingsManager.getSettings().getValue();
        return OkHttpClientLoggingVerbosityKt.setupLoggingVerbosity(OkHttpClientTimeoutKt.setupTimeouts-HG0u8IE(OkHttpClientProxyKt.setupProxy(new OkHttpClient().newBuilder(), settings2.getProxy(), $proxyAuthenticator).protocols(CollectionsKt.listOf((Object)((Object)Protocol.HTTP_1_1))).retryOnConnectionFailure(true), settings2.getNetwork().getConnectTimeout-UwyO8pc()), settings2.getAdvanced().getHttpLoggingVerbosity()).build();
    }

    private static final OkHttpClient httpClientCache$lambda$1(Function1 $tmp0, Object p0) {
        return (OkHttpClient)$tmp0.invoke(p0);
    }

    private static final List cache$lambda$3(RegionUrlMapper this$0, UIRegion region) {
        Intrinsics.checkNotNull((Object)((Object)region));
        return this$0.loadMappings(region);
    }

    private static final List cache$lambda$4(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public /* synthetic */ RegionUrlMapper(SettingsManager settingsManager, IntellijPreferenceManager intellijPreferenceManager, ProxyAuthenticator proxyAuthenticator, CoroutineScope coroutineScope, long cacheDataExpiration, String defaultConfigUrl, Map configUrlTable, DefaultConstructorMarker $constructor_marker) {
        this(settingsManager, intellijPreferenceManager, proxyAuthenticator, coroutineScope, cacheDataExpiration, defaultConfigUrl, configUrlTable);
    }

    public static final /* synthetic */ Map access$getConfigUrlTable$p(RegionUrlMapper $this) {
        return $this.configUrlTable;
    }

    private static final class UrlMapping {
        @NotNull
        private final String pattern;
        @NotNull
        private final String replacement;

        public UrlMapping(@NotNull String pattern, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            this.pattern = pattern;
            this.replacement = replacement;
        }

        @NotNull
        public final String component1() {
            return this.pattern;
        }

        @NotNull
        public final String component2() {
            return this.replacement;
        }

        @NotNull
        public String toString() {
            return "UrlMapping(pattern=" + this.pattern + ", replacement=" + this.replacement + ")";
        }

        public int hashCode() {
            int result2 = this.pattern.hashCode();
            result2 = result2 * 31 + this.replacement.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UrlMapping)) {
                return false;
            }
            UrlMapping urlMapping = (UrlMapping)other;
            if (!Intrinsics.areEqual((Object)this.pattern, (Object)urlMapping.pattern)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.replacement, (Object)urlMapping.replacement);
        }
    }
}

