/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network;

import com.jetbrains.toolbox.settings.HttpLoggingVerbosity;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class HttpLogger
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final HttpLoggingVerbosity level;

    private HttpLogger(String type2, HttpLoggingVerbosity level) {
        this.type = type2;
        this.level = level;
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request2 = chain.request();
        if (this.level != HttpLoggingVerbosity.None) {
            StringBuilder stringBuilder;
            StringBuilder $this$intercept_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Request $this$intercept_u24lambda_u241_u24lambda_u240 = request2;
            boolean bl2 = false;
            $this$intercept_u24lambda_u241.append(this.type + " request --> " + $this$intercept_u24lambda_u241_u24lambda_u240.method() + " " + $this$intercept_u24lambda_u241_u24lambda_u240.url());
            this.logHeaders($this$intercept_u24lambda_u241, $this$intercept_u24lambda_u241_u24lambda_u240.headers());
            String requestLog = stringBuilder.toString();
            Logger.INSTANCE.info(requestLog);
        }
        Response response2 = chain.proceed(request2);
        if (this.level != HttpLoggingVerbosity.None) {
            StringBuilder stringBuilder;
            StringBuilder $this$intercept_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Response $this$intercept_u24lambda_u243_u24lambda_u242 = response2;
            boolean bl3 = false;
            $this$intercept_u24lambda_u243.append(this.type + " response <-- " + $this$intercept_u24lambda_u243_u24lambda_u242.code() + " " + $this$intercept_u24lambda_u243_u24lambda_u242.message() + " " + request2.url());
            this.logHeaders($this$intercept_u24lambda_u243, $this$intercept_u24lambda_u243_u24lambda_u242.headers());
            String responseLog = stringBuilder.toString();
            Logger.INSTANCE.info(responseLog);
        }
        return response2;
    }

    private final void logHeaders(StringBuilder $this$logHeaders, Headers headers2) {
        if (this.level.compareTo((Enum)HttpLoggingVerbosity.Headers) >= 0) {
            $this$logHeaders.append('\n');
            for (Pair<String, String> header : headers2) {
                $this$logHeaders.append(header.getFirst() + ": " + header.getSecond()).append('\n');
            }
        }
    }

    public /* synthetic */ HttpLogger(String type2, HttpLoggingVerbosity level, DefaultConstructorMarker $constructor_marker) {
        this(type2, level);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpLogger network(@NotNull HttpLoggingVerbosity level) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            return new HttpLogger("network", level, null);
        }

        @NotNull
        public final HttpLogger app(@NotNull HttpLoggingVerbosity level) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            return new HttpLogger("cache", level, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

