/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.network.CustomHeaderContributor;
import com.jetbrains.toolbox.network.CustomHeaderContributorKt;
import com.jetbrains.toolbox.network.DownloadResult;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Downloader.kt\ncom/jetbrains/toolbox/network/DownloaderKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,265:1\n216#2,2:266\n216#2,2:268\n*S KotlinDebug\n*F\n+ 1 Downloader.kt\ncom/jetbrains/toolbox/network/DownloaderKt\n*L\n219#1:266,2\n258#1:268,2\n*E\n"})
public final class DownloaderKt {
    @NotNull
    private static final ConnectionPool connectionPool = new ConnectionPool(2, 1L, TimeUnit.MINUTES);

    @NotNull
    public static final Request.Builder createNewRequest(@NotNull String url, @NotNull Map<String, String> headers2, boolean noCache) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers2, (String)"headers");
        Request.Builder request2 = new Request.Builder().url(url).header("User-Agent", Build.INSTANCE.getUserAgent());
        if (noCache) {
            request2.cacheControl(CacheControl.FORCE_NETWORK);
        }
        Map<String, String> $this$forEach$iv = headers2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator2.next();
            boolean bl = false;
            request2.addHeader(it.getKey(), it.getValue());
        }
        return request2;
    }

    public static /* synthetic */ Request.Builder createNewRequest$default(String string, Map map2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return DownloaderKt.createNewRequest(string, map2, bl);
    }

    @NotNull
    public static final DownloadResult toDownloadResult(@NotNull Response $this$toDownloadResult, @Nullable Long size) {
        DownloadResult downloadResult;
        int responseCode;
        Intrinsics.checkNotNullParameter((Object)$this$toDownloadResult, (String)"<this>");
        Response response2 = $this$toDownloadResult.networkResponse();
        int n = responseCode = response2 != null ? response2.code() : $this$toDownloadResult.code();
        boolean bl = 200 <= responseCode ? responseCode < 300 : false;
        if (bl) {
            long l;
            String string = Response.header$default($this$toDownloadResult, "Last-Modified", null, 2, null);
            String string2 = Response.header$default($this$toDownloadResult, "ETag", null, 2, null);
            String string3 = Response.header$default($this$toDownloadResult, "Content-Type", null, 2, null);
            Long l2 = size;
            if (l2 != null) {
                l = l2;
            } else {
                String string4 = Response.header$default($this$toDownloadResult, "Content-Length", null, 2, null);
                Long l3 = string4 != null ? StringsKt.toLongOrNull((String)string4) : null;
                l = l3 != null ? l3 : 0L;
            }
            downloadResult = new DownloadResult.Downloaded(null, string, string2, null, string3, l);
        } else if (responseCode == 304) {
            downloadResult = DownloadResult.NotModified.INSTANCE;
        } else if (responseCode == 400) {
            Logger.INSTANCE.warn("Bad Request: " + $this$toDownloadResult.request().url() + " Headers:");
            Logger.INSTANCE.debug($this$toDownloadResult.request().headers().toString());
            downloadResult = new DownloadResult.Failed("Bad Request", responseCode, false, null, null, 28, null);
        } else if (responseCode == 401) {
            downloadResult = new DownloadResult.Failed("Authorization required", responseCode, false, null, null, 28, null);
        } else if (responseCode == 403) {
            downloadResult = new DownloadResult.Failed("Forbidden", responseCode, false, null, null, 28, null);
        } else if (responseCode == 404) {
            downloadResult = new DownloadResult.Failed($this$toDownloadResult.request().url() + " not found", responseCode, false, null, null, 28, null);
        } else if (responseCode == 416) {
            downloadResult = new DownloadResult.Failed("Range error", responseCode, false, null, null, 28, null);
        } else if (responseCode == 429) {
            downloadResult = new DownloadResult.NotConnected("Request throttled");
        } else if (responseCode == 451) {
            String string = Response.header$default($this$toDownloadResult, "error-message", null, 2, null);
            if (string == null) {
                string = $this$toDownloadResult.message();
            }
            downloadResult = new DownloadResult.Failed(string, responseCode, false, null, null, 28, null);
        } else {
            downloadResult = (500 <= responseCode ? responseCode < 600 : false) ? (DownloadResult)new DownloadResult.NotConnected("Server error") : (DownloadResult)new DownloadResult.Failed("Unexpected HTTP status code " + $this$toDownloadResult.code(), responseCode, false, null, null, 28, null);
        }
        return downloadResult;
    }

    public static /* synthetic */ DownloadResult toDownloadResult$default(Response response2, Long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        return DownloaderKt.toDownloadResult(response2, l);
    }

    private static final DownloadResult toDownloadResult(IOException $this$toDownloadResult, String url) {
        Object object;
        IOException iOException = $this$toDownloadResult;
        if (iOException instanceof ConnectException) {
            object = "Connection to " + url + " failed: " + $this$toDownloadResult.getMessage();
        } else if (iOException instanceof UnknownHostException) {
            object = "Host " + url + " not found: " + $this$toDownloadResult.getMessage();
        } else if (iOException instanceof SocketTimeoutException) {
            object = "Connection to " + url + " timed out: " + $this$toDownloadResult.getMessage();
        } else {
            object = $this$toDownloadResult.getMessage();
            if (object == null) {
                object = "Unknown IO error " + $this$toDownloadResult;
            }
        }
        String message2 = object;
        return new DownloadResult.NotConnected(message2);
    }

    @NotNull
    public static final OkHttpClient.Builder setupCustomHeaders(@NotNull OkHttpClient.Builder $this$setupCustomHeaders, @NotNull List<? extends CustomHeaderContributor> contributors) {
        Intrinsics.checkNotNullParameter((Object)$this$setupCustomHeaders, (String)"<this>");
        Intrinsics.checkNotNullParameter(contributors, (String)"contributors");
        return $this$setupCustomHeaders.addInterceptor(arg_0 -> DownloaderKt.setupCustomHeaders$lambda$3(contributors, arg_0));
    }

    private static final Response setupCustomHeaders$lambda$3(List $contributors, Interceptor.Chain chain) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request.Builder $this$setupCustomHeaders_u24lambda_u243_u24lambda_u242 = builder = chain.request().newBuilder();
        boolean bl = false;
        Map<String, String> $this$forEach$iv = CustomHeaderContributorKt.allHeadersFrom($contributors);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            String k = entry.getKey();
            String v = entry.getValue();
            $this$setupCustomHeaders_u24lambda_u243_u24lambda_u242.addHeader(k, v);
        }
        Request newRequest = builder.build();
        return chain.proceed(newRequest);
    }

    public static final /* synthetic */ ConnectionPool access$getConnectionPool$p() {
        return connectionPool;
    }

    public static final /* synthetic */ DownloadResult access$toDownloadResult(IOException $receiver, String url) {
        return DownloaderKt.toDownloadResult($receiver, url);
    }
}

