/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.common.ActionProgress;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.network.AuthInterceptor;
import com.jetbrains.toolbox.network.BlockingCalls;
import com.jetbrains.toolbox.network.CertificateManagerContext;
import com.jetbrains.toolbox.network.CustomHeaderContributor;
import com.jetbrains.toolbox.network.DownloadResult;
import com.jetbrains.toolbox.network.DownloadSession;
import com.jetbrains.toolbox.network.DownloadSessionImpl;
import com.jetbrains.toolbox.network.DownloadSessionUtilKt;
import com.jetbrains.toolbox.network.DownloaderKt;
import com.jetbrains.toolbox.network.ProxyAuthenticator;
import com.jetbrains.toolbox.network.util.OkHttpClientLoggingVerbosityKt;
import com.jetbrains.toolbox.network.util.OkHttpClientProxyKt;
import com.jetbrains.toolbox.network.util.OkHttpClientTimeoutKt;
import com.jetbrains.toolbox.network.util.OkHttpClientTrustedCertificateKt;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.AbstractCoroutineContextElement;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.JobKt;
import kotlinx.serialization.json.JsonObject;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Downloader.kt\ncom/jetbrains/toolbox/network/DownloadSessionImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,265:1\n1#2:266\n1869#3,2:267\n216#4,2:269\n216#4,2:271\n375#5:273\n375#5:274\n*S KotlinDebug\n*F\n+ 1 Downloader.kt\ncom/jetbrains/toolbox/network/DownloadSessionImpl\n*L\n202#1:267,2\n65#1:269,2\n85#1:271,2\n105#1:273\n163#1:274\n*E\n"})
public final class DownloadSessionImpl
extends AbstractCoroutineContextElement
implements DownloadSession,
Closeable {
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final OkHttpClient httpClientNoCache;

    /*
     * WARNING - void declaration
     */
    public DownloadSessionImpl(@NotNull SettingsManager settingsManager, @Nullable CertificateManagerContext certificateContext, @NotNull ProxyAuthenticator proxyAuthenticator, @Nullable Path downloadCacheLocation, @Nullable Interceptor regionUrlMapperInterceptor, @NotNull List<? extends AuthInterceptor> authInterceptors, @NotNull List<? extends CustomHeaderContributor> customHeaderContributors, @NotNull Dispatcher dispatcher) {
        void $this$httpClient_u24lambda_u2415;
        Object it;
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)proxyAuthenticator, (String)"proxyAuthenticator");
        Intrinsics.checkNotNullParameter(authInterceptors, (String)"authInterceptors");
        Intrinsics.checkNotNullParameter(customHeaderContributors, (String)"customHeaderContributors");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        super((CoroutineContext.Key)DownloadSession.Key);
        this.settingsManager = settingsManager;
        OkHttpClient.Builder builder2 = builder = OkHttpClientTimeoutKt.setupTimeouts-HG0u8IE(DownloaderKt.setupCustomHeaders(OkHttpClientTrustedCertificateKt.setupTrustedCertificates(OkHttpClientProxyKt.setupProxy(new OkHttpClient.Builder().connectionPool(DownloaderKt.access$getConnectionPool$p()).protocols(CollectionsKt.listOf((Object)((Object)Protocol.HTTP_1_1))).dispatcher(dispatcher), ((SelfSettings)this.settingsManager.getSettings().getValue()).getProxy(), proxyAuthenticator).retryOnConnectionFailure(true), certificateContext), customHeaderContributors), ((SelfSettings)this.settingsManager.getSettings().getValue()).getNetwork().getConnectTimeout-UwyO8pc());
        DownloadSessionImpl downloadSessionImpl = this;
        boolean bl = false;
        Path path2 = downloadCacheLocation;
        if (path2 != null) {
            it = path2;
            boolean bl2 = false;
            $this$httpClient_u24lambda_u2415.cache(new Cache(it.toFile(), 100000000L));
        }
        OkHttpClientLoggingVerbosityKt.setupLoggingVerbosity((OkHttpClient.Builder)$this$httpClient_u24lambda_u2415, ((SelfSettings)this.settingsManager.getSettings().getValue()).getAdvanced().getHttpLoggingVerbosity());
        Interceptor interceptor2 = regionUrlMapperInterceptor;
        if (interceptor2 != null) {
            it = interceptor2;
            boolean bl3 = false;
            $this$httpClient_u24lambda_u2415.addInterceptor((Interceptor)it);
        }
        Iterable $this$forEach$iv = authInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AuthInterceptor it2 = (AuthInterceptor)element$iv;
            boolean bl4 = false;
            $this$httpClient_u24lambda_u2415.addInterceptor(it2);
        }
        downloadSessionImpl.httpClient = builder.build();
        this.httpClientNoCache = this.getHttpClient().newBuilder().cache(null).build();
    }

    @Override
    public void close() {
        block0: {
            Cache cache2 = this.getHttpClient().cache();
            if (cache2 == null) break block0;
            cache2.close();
        }
    }

    @Override
    @Nullable
    public Object post(@NotNull String url, @NotNull Map<String, String> query2, @NotNull Map<String, String> headers2, boolean noCache, @NotNull Continuation<? super Pair<? extends DownloadResult, byte[]>> $completion) {
        FormBody.Builder builder;
        FormBody.Builder $this$post_u24lambda_u241 = builder = new FormBody.Builder(null, 1, null);
        boolean bl = false;
        Map<String, String> $this$forEach$iv = query2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator2.next();
            boolean bl2 = false;
            $this$post_u24lambda_u241.add(it.getKey(), it.getValue());
        }
        FormBody body = builder.build();
        Request.Builder request2 = DownloaderKt.createNewRequest(url, headers2, noCache).post(body);
        return this.makeCall(request2, url, noCache, $completion);
    }

    @Override
    @Nullable
    public Object post(@NotNull String url, @NotNull JsonObject json2, @NotNull Map<String, String> headers2, boolean noCache, @NotNull Continuation<? super Pair<? extends DownloadResult, byte[]>> $completion) {
        Request.Builder request2 = DownloaderKt.createNewRequest(url, headers2, noCache).post(RequestBody.Companion.create(json2.toString(), MediaType.Companion.get("application/json")));
        return this.makeCall(request2, url, noCache, $completion);
    }

    @Override
    @Nullable
    public Object delete(@NotNull String url, @NotNull Map<String, String> query2, @NotNull Map<String, String> headers2, @NotNull Continuation<? super Pair<? extends DownloadResult, byte[]>> $completion) {
        FormBody.Builder builder;
        FormBody.Builder $this$delete_u24lambda_u243 = builder = new FormBody.Builder(null, 1, null);
        boolean bl = false;
        Map<String, String> $this$forEach$iv = query2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator2.next();
            boolean bl2 = false;
            $this$delete_u24lambda_u243.add(it.getKey(), it.getValue());
        }
        FormBody body = builder.build();
        Request.Builder request2 = DownloaderKt.createNewRequest$default(url, headers2, false, 4, null).delete(body);
        return DownloadSessionImpl.makeCall$default(this, request2, url, false, $completion, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object makeCall(Request.Builder request, String url, boolean noCache, Continuation<? super Pair<? extends DownloadResult, byte[]>> $completion) {
        if (!($completion instanceof makeCall.1)) ** GOTO lbl-1000
        var18_5 = $completion;
        if ((var18_5.label & -2147483648) != 0) {
            var18_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ DownloadSessionImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DownloadSessionImpl.access$makeCall(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var19_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                emptyBody = new byte[]{};
                client = noCache != false ? this.httpClientNoCache : this.getHttpClient();
                $this$makeCall_u24lambda_u244 = client.newCall(request.build());
                $i$a$-with-DownloadSessionImpl$makeCall$response$1 = 0;
                if ($continuation.getContext().get((CoroutineContext.Key)BlockingCalls.INSTANCE) == null) ** GOTO lbl21
                v0 = $this$makeCall_u24lambda_u244.execute();
                ** GOTO lbl46
lbl21:
                // 1 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = url;
                $continuation.L$2 = emptyBody;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$makeCall_u24lambda_u244);
                $continuation.Z$0 = noCache;
                $continuation.I$0 = $i$a$-with-DownloadSessionImpl$makeCall$response$1;
                $continuation.label = 1;
                v1 = DownloadSessionUtilKt.await($this$makeCall_u24lambda_u244, (Continuation<? super Response>)$continuation);
                ** if (v1 != var19_7) goto lbl32
lbl31:
                // 1 sources

                return var19_7;
lbl32:
                // 1 sources

                ** GOTO lbl45
            }
            case 1: {
                $i$a$-with-DownloadSessionImpl$makeCall$response$1 = $continuation.I$0;
                noCache = $continuation.Z$0;
                $this$makeCall_u24lambda_u244 = (Call)$continuation.L$4;
                client = (OkHttpClient)$continuation.L$3;
                emptyBody = (byte[])$continuation.L$2;
                url = (String)$continuation.L$1;
                request = (Request.Builder)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl45:
                    // 2 sources

                    v0 = (Response)v1;
lbl46:
                    // 2 sources

                    var8_17 /* !! */  = v0;
                }
                catch (IOException t) {
                    Logger.INSTANCE.warn((Throwable)t, "Failed to execute http request to " + url);
                    return TuplesKt.to((Object)DownloaderKt.access$toDownloadResult(t, url), (Object)emptyBody);
                }
                catch (Throwable t) {
                    Logger.INSTANCE.warn(t, "Failed to execute http request to " + url);
                    $i$f$currentCoroutineContext = false;
                    JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    v2 = t.getMessage();
                    if (v2 == null) {
                        v2 = "Unknown error";
                    }
                    return TuplesKt.to((Object)new DownloadResult.Failed(v2, null, false, null, null, 30, null), (Object)emptyBody);
                }
                response = var8_17 /* !! */ ;
                try {
                    var8_17 /* !! */  = response;
                    t = null;
                    try {
                        it /* !! */  = var8_17 /* !! */ ;
                        $i$a$-use-DownloadSessionImpl$makeCall$2 = false;
                        v3 = DownloaderKt.toDownloadResult$default(it /* !! */ , null, 1, null);
                        v4 = response.body();
                        if (v4 == null) ** GOTO lbl90
                        var12_22 = (Closeable)v4;
                        var13_23 = v3;
                        var14_24 = null;
                        try {
                            it = (ResponseBody)var12_22;
                            $i$a$-use-DownloadSessionImpl$makeCall$2$1 = false;
                            var15_25 = it.bytes();
                        }
                        catch (Throwable var16_27) {
                            var14_24 = var16_27;
                            throw var16_27;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var12_22, (Throwable)var14_24);
                        }
                        v3 = var13_23;
                        v4 = var15_25;
                        if (var15_25 != null) ** GOTO lbl91
lbl90:
                        // 2 sources

                        v4 = emptyBody;
lbl91:
                        // 2 sources

                        var10_16 = TuplesKt.to((Object)v3, (Object)v4);
                    }
                    catch (Throwable var11_20) {
                        t = var11_20;
                        throw var11_20;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var8_17 /* !! */ , (Throwable)t);
                    }
                    var8_17 /* !! */  = var10_16;
                }
                catch (IOException e) {
                    Logger.INSTANCE.error("Error reading the response body for '" + url + "': " + e.getMessage());
                    v5 = e.getMessage();
                    if (v5 == null) {
                        v5 = "Unknown error";
                    }
                    var8_17 /* !! */  = TuplesKt.to((Object)new DownloadResult.NotConnected(v5), (Object)emptyBody);
                }
                catch (Exception e) {
                    Logger.INSTANCE.info((Throwable)e, "Error reading '" + url + "': " + e.getMessage());
                    v6 = e.getMessage();
                    if (v6 == null) {
                        v6 = "Unknown error";
                    }
                    var8_17 /* !! */  = TuplesKt.to((Object)new DownloadResult.Failed(v6, Boxing.boxInt((int)response.code()), false, null, null, 28, null), (Object)emptyBody);
                }
                return var8_17 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object makeCall$default(DownloadSessionImpl downloadSessionImpl, Request.Builder builder, String string, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return downloadSessionImpl.makeCall(builder, string, bl, (Continuation<? super Pair<? extends DownloadResult, byte[]>>)continuation);
    }

    @Override
    @Nullable
    public Object createNewRequest(@NotNull String url, @Nullable String authorization2, @Nullable String eTag, boolean noCache, boolean requireAuthorizationHeader, @NotNull Continuation<? super Request.Builder> $completion) {
        Request.Builder request2;
        block4: {
            request2 = new Request.Builder().url(url).header("User-Agent", Build.INSTANCE.getUserAgent());
            if (noCache) {
                request2.cacheControl(CacheControl.FORCE_NETWORK);
            }
            if (authorization2 != null) {
                request2.addHeader("Authorization", authorization2);
            } else if (requireAuthorizationHeader) {
                request2.addHeader("X-Toolbox-Authorization-Required", "true");
            }
            String string = eTag;
            if (string == null) break block4;
            String it = string;
            boolean bl = false;
            request2.addHeader("If-None-Match", eTag);
        }
        return request2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object getAsync(@NotNull String url, long maxsize, @Nullable ActionProgress progress, @Nullable String authorization, boolean requireAuthorizationHeader, boolean suppressAuthorizationError, @NotNull Continuation<? super Pair<? extends DownloadResult, byte[]>> $completion) {
        if (!($completion instanceof getAsync.1)) ** GOTO lbl-1000
        var29_8 = $completion;
        if ((var29_8.label & -2147483648) != 0) {
            var29_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                long J$0;
                boolean Z$0;
                boolean Z$1;
                /* synthetic */ Object result;
                final /* synthetic */ DownloadSessionImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAsync(null, 0L, null, null, false, false, (Continuation<? super Pair<? extends DownloadResult, byte[]>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var30_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = url;
                $continuation.L$1 = progress;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)authorization);
                $continuation.J$0 = maxsize;
                $continuation.Z$0 = requireAuthorizationHeader;
                $continuation.Z$1 = suppressAuthorizationError;
                $continuation.label = 1;
                v0 = DownloadSession.createNewRequest$default(this, url, authorization, null, false, requireAuthorizationHeader != false, (Continuation)$continuation, 12, null);
                if (v0 == var30_10) {
                    return var30_10;
                }
                ** GOTO lbl32
            }
            case 1: {
                suppressAuthorizationError = $continuation.Z$1;
                requireAuthorizationHeader = $continuation.Z$0;
                maxsize = $continuation.J$0;
                authorization = (String)$continuation.L$2;
                progress = (ActionProgress)$continuation.L$1;
                url = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                request = ((Request.Builder)v0).get().build();
                emptyBytes = new byte[]{};
                $continuation.L$0 = url;
                $continuation.L$1 = progress;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)authorization);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$4 = emptyBytes;
                $continuation.J$0 = maxsize;
                $continuation.Z$0 = requireAuthorizationHeader;
                $continuation.Z$1 = suppressAuthorizationError;
                $continuation.label = 2;
                v1 = DownloadSessionUtilKt.await(this.getHttpClient().newCall(request), (Continuation<? super Response>)$continuation);
                ** if (v1 != var30_10) goto lbl48
lbl47:
                // 1 sources

                return var30_10;
lbl48:
                // 1 sources

                ** GOTO lbl62
            }
            case 2: {
                suppressAuthorizationError = $continuation.Z$1;
                requireAuthorizationHeader = $continuation.Z$0;
                maxsize = $continuation.J$0;
                emptyBytes = (byte[])$continuation.L$4;
                request = (Request)$continuation.L$3;
                authorization = (String)$continuation.L$2;
                progress = (ActionProgress)$continuation.L$1;
                url = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl62:
                    // 2 sources

                    var12_14 /* !! */  = (Response)v1;
                }
                catch (IOException t) {
                    return TuplesKt.to((Object)DownloaderKt.access$toDownloadResult(t, url), (Object)emptyBytes);
                }
                catch (Throwable t) {
                    $i$f$currentCoroutineContext = false;
                    JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    Logger.INSTANCE.info(t, "Error requesting " + url + ". " + t.getMessage());
                    v2 = t.getMessage();
                    if (v2 == null) {
                        v2 = "Unknown error";
                    }
                    return TuplesKt.to((Object)new DownloadResult.Failed(v2, null, false, null, null, 30, null), (Object)emptyBytes);
                }
                response = var12_14 /* !! */ ;
                try {
                    var12_14 /* !! */  = response;
                    t = null;
                    try {
                        it /* !! */  = var12_14 /* !! */ ;
                        $i$a$-use-DownloadSessionImpl$getAsync$2 = false;
                        if (response.code() != 403) ** GOTO lbl122
                        v3 = response.body();
                        if (v3 != null) {
                            var16_25 = v3;
                            var17_27 = null;
                            try {
                                it = (ResponseBody)var16_25;
                                $i$a$-use-DownloadSessionImpl$getAsync$2$errorBody$1 = false;
                                it = it.string();
                                v4 = it;
                            }
                            catch (Throwable $i$a$-use-DownloadSessionImpl$getAsync$2$errorBody$1) {
                                var17_27 = $i$a$-use-DownloadSessionImpl$getAsync$2$errorBody$1;
                                throw $i$a$-use-DownloadSessionImpl$getAsync$2$errorBody$1;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var16_25, (Throwable)var17_27);
                            }
                        } else {
                            v4 = errorBody = null;
                        }
                        if (!suppressAuthorizationError) ** GOTO lbl106
                        Logger.INSTANCE.info("Suppressed authorization error: " + errorBody);
                        ** GOTO lbl120
lbl106:
                        // 1 sources

                        v5 = progress;
                        if (v5 == null) ** GOTO lbl120
                        v6 = errorBody;
                        if (v6 == null) ** GOTO lbl118
                        var17_27 = v6;
                        var21_40 = v5;
                        $i$a$-let-DownloadSessionImpl$getAsync$2$1 = false;
                        v7 = LocalizableStringExKt.trl((String)p0);
                        v5 = var21_40;
                        v6 = v7;
                        if (v7 != null) ** GOTO lbl119
lbl118:
                        // 2 sources

                        v6 = LocalizableStringExKt.trl("Authorization required");
lbl119:
                        // 2 sources

                        v5.error(v6);
lbl120:
                        // 3 sources

                        var27_41 = TuplesKt.to((Object)DownloaderKt.toDownloadResult$default(response, null, 1, null), (Object)emptyBytes);
                        return var27_41;
lbl122:
                        // 1 sources

                        v8 = response.body();
                        if (v8 == null) ** GOTO lbl153
                        var16_26 = v8;
                        var17_28 = null;
                        try {
                            b = (ResponseBody)var16_26;
                            $i$a$-use-DownloadSessionImpl$getAsync$2$bytes$1 = false;
                            var22_42 = b.byteStream();
                            var23_43 = null;
                            try {
                                it = (InputStream)var22_42;
                                $i$a$-use-DownloadSessionImpl$getAsync$2$bytes$1$1 = false;
                                var24_44 = ByteStreamsKt.readBytes((InputStream)it);
                            }
                            catch (Throwable var25_46) {
                                var23_43 = var25_46;
                                throw var25_46;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var22_42, (Throwable)var23_43);
                            }
                            var18_31 = var24_44;
                            v9 = var18_31;
                        }
                        catch (Throwable var19_36) {
                            var17_28 = var19_36;
                            throw var19_36;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var16_26, (Throwable)var17_28);
                        }
lbl153:
                        // 1 sources

                        v9 = null;
                        bytes = v9;
                        v10 = DownloaderKt.toDownloadResult$default(response, null, 1, null);
                        v11 = bytes;
                        if (bytes == null) {
                            v11 = emptyBytes;
                        }
                        var26_48 = TuplesKt.to((Object)v10, v11);
                        return var26_48;
                    }
                    catch (Throwable var15_23) {
                        t = var15_23;
                        throw var15_23;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var12_14 /* !! */ , (Throwable)t);
                    }
                }
                catch (Throwable t) {
                    Logger.INSTANCE.info(t, "Error reading " + url + ". " + t.getMessage());
                    v12 = t.getMessage();
                    if (v12 == null) {
                        v12 = "Unknown error";
                    }
                    return TuplesKt.to((Object)new DownloadResult.Failed(v12, Boxing.boxInt((int)response.code()), false, null, null, 28, null), (Object)emptyBytes);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public static final /* synthetic */ Object access$makeCall(DownloadSessionImpl $this, Request.Builder request2, String url, boolean noCache, Continuation $completion) {
        return $this.makeCall(request2, url, noCache, (Continuation<? super Pair<? extends DownloadResult, byte[]>>)$completion);
    }
}

