/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network;

import com.jetbrains.toolbox.network.CertificateManagerImpl;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nCertificateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateManager.kt\ncom/jetbrains/toolbox/network/CustomTrustManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,218:1\n13472#2,2:219\n*S KotlinDebug\n*F\n+ 1 CertificateManager.kt\ncom/jetbrains/toolbox/network/CustomTrustManager\n*L\n197#1:219,2\n*E\n"})
public final class CustomTrustManager
implements X509TrustManager {
    @NotNull
    private final X509TrustManager trustManager;
    @NotNull
    private final CertificateManagerImpl certificateManager;

    public CustomTrustManager(@NotNull X509TrustManager trustManager, @NotNull CertificateManagerImpl certificateManager) {
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        Intrinsics.checkNotNullParameter((Object)certificateManager, (String)"certificateManager");
        this.trustManager = trustManager;
        this.certificateManager = certificateManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkServerTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
            return;
        }
        catch (CertificateException ce) {
            if (chain == null) throw ce;
            X509Certificate[] $this$forEach$iv = chain;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                X509Certificate element$iv;
                X509Certificate certificate2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                if (this.isKnownCertificate(certificate2)) continue;
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, certificate2, null){
                    int label;
                    final /* synthetic */ CustomTrustManager this$0;
                    final /* synthetic */ X509Certificate $certificate;
                    {
                        this.this$0 = $receiver;
                        this.$certificate = $certificate;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = CustomTrustManager.access$getCertificateManager$p(this.this$0).addPendingCertificate(this.$certificate, (Continuation<? super Unit>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
            throw ce;
        }
    }

    public final boolean isKnownCertificate(@NotNull X509Certificate certificate2) {
        Intrinsics.checkNotNullParameter((Object)certificate2, (String)"certificate");
        X509Certificate[] x509CertificateArray = this.trustManager.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue((Object)x509CertificateArray, (String)"getAcceptedIssuers(...)");
        return ArraysKt.contains((Object[])x509CertificateArray, (Object)certificate2);
    }

    @Override
    public void checkClientTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) {
        throw new UnsupportedOperationException("Client certificates are unsupported");
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public static final /* synthetic */ CertificateManagerImpl access$getCertificateManager$p(CustomTrustManager $this) {
        return $this.certificateManager;
    }
}

