/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.skeleton;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.jetbrains.annotations.NotNull;

public abstract class MarkdownSkeletonBlock {
    @NotNull
    private final ASTNode node;
    @NotNull
    private final CharSequence file;
    @NotNull
    private final List<MarkdownSkeletonBlock> children;
    private final boolean finished;
    @NotNull
    private final Lazy text$delegate;
    public static final int $stable = 8;

    public MarkdownSkeletonBlock(@NotNull ASTNode node2, @NotNull CharSequence file, @NotNull List<? extends MarkdownSkeletonBlock> children, boolean finished) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.node = node2;
        this.file = file;
        this.children = children;
        this.finished = finished;
        this.text$delegate = LazyKt.lazy(() -> MarkdownSkeletonBlock.text_delegate$lambda$0(this));
    }

    @NotNull
    public final CharSequence getFile() {
        return this.file;
    }

    @NotNull
    public final List<MarkdownSkeletonBlock> getChildren() {
        return this.children;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    @NotNull
    public final CharSequence getText() {
        Lazy lazy = this.text$delegate;
        return (CharSequence)lazy.getValue();
    }

    @NotNull
    public final IElementType getType() {
        return this.node.getType();
    }

    @NotNull
    public final IntRange getRange() {
        return new IntRange(this.node.getStartOffset(), this.node.getEndOffset() - 1);
    }

    public final int getLength() {
        return this.getRange().getEndInclusive() - this.getRange().getStart() + 1;
    }

    public final boolean visit(@NotNull Function1<? super MarkdownSkeletonBlock, Boolean> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        boolean toContinue = (Boolean)visitor2.invoke((Object)this);
        if (!toContinue) {
            return false;
        }
        for (MarkdownSkeletonBlock child2 : this.children) {
            boolean toContinueChild = child2.visit(visitor2);
            if (toContinueChild) continue;
            return false;
        }
        return true;
    }

    private static final CharSequence text_delegate$lambda$0(MarkdownSkeletonBlock this$0) {
        return ASTUtilKt.getTextInNode(this$0.node, this$0.file);
    }

    public static final class Composite
    extends MarkdownSkeletonBlock {
        public static final int $stable = 8;

        public Composite(@NotNull ASTNode node2, boolean finished, @NotNull List<? extends MarkdownSkeletonBlock> children, @NotNull CharSequence file) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(node2, file, children, finished);
        }
    }

    public static final class Leaf
    extends MarkdownSkeletonBlock {
        public static final int $stable = 8;

        public Leaf(@NotNull ASTNode node2, boolean finished, @NotNull CharSequence file) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(node2, file, CollectionsKt.emptyList(), finished);
        }
    }
}

