/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate;

import com.jetbrains.toolbox.common.code.LanguageId;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.CodeHighlightingEngine;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.CodeHighlightingToken;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.CodeHighlightingType;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate.BundleCollection;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate.TextMateLexerProvider;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate.TextMateLexerProviderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerCore;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextmateToken;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nTextMateHighlighting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateHighlighting.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/TextMateHighlighting\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n295#2,2:78\n1617#2,9:86\n1869#2:95\n1870#2:97\n1626#2:98\n1056#2:99\n170#3,6:80\n1#4:96\n*S KotlinDebug\n*F\n+ 1 TextMateHighlighting.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/TextMateHighlighting\n*L\n54#1:78,2\n61#1:86,9\n61#1:95\n61#1:97\n61#1:98\n30#1:99\n56#1:80,6\n61#1:96\n*E\n"})
public final class TextMateHighlighting
implements CodeHighlightingEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TextMateLexerProvider> lexers;
    public static final int $stable = 8;
    @NotNull
    private static final Map<Set<String>, CodeHighlightingType> mapping;
    @NotNull
    private static final List<String> selectors;

    public TextMateHighlighting(@NotNull List<TextMateLexerProvider> lexers) {
        Intrinsics.checkNotNullParameter(lexers, (String)"lexers");
        this.lexers = lexers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CodeHighlightingEngine.HighlightedCode highlight(@NotNull LanguageId languageId, @NotNull String code, @NotNull CodeHighlightingEngine.HighlightedCode previous) {
        TextMateLexerCore lexer;
        Object v0;
        block7: {
            Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
            if (Intrinsics.areEqual((Object)previous.getCode(), (Object)code)) {
                return previous;
            }
            Iterable $this$firstOrNull$iv = this.lexers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TextMateLexerProvider it = (TextMateLexerProvider)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLanguageId(), (Object)languageId)) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        TextMateLexerProvider textMateLexerProvider = v0;
        TextMateLexerCore textMateLexerCore = lexer = textMateLexerProvider != null ? textMateLexerProvider.getLexer() : null;
        if (lexer != null) {
            int n;
            block8: {
                CharSequence $this$indexOfLast$iv = previous.getCode();
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it == '\n')) continue;
                        n = index$iv;
                        break block8;
                    } while (0 <= n2);
                }
                n = -1;
            }
            int offset = n + 1;
            String string = code.substring(RangesKt.coerceIn((int)offset, (int)0, (int)code.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String toHighlight = string;
            if (((CharSequence)toHighlight).length() > 0) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                List<TextmateToken> tokens = TextMateLexerProviderKt.tokenize(lexer, toHighlight);
                Iterable iterable = tokens;
                Collection collection = previous.getTokens();
                LanguageId languageId2 = languageId;
                String string2 = code;
                boolean $i$f$mapNotNull = false;
                void it = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    CodeHighlightingToken it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    TextmateToken it2 = (TextmateToken)element$iv$iv;
                    boolean bl2 = false;
                    if (this.toHighlightingToken(it2, offset) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                List list3 = CollectionsKt.plus((Collection)collection, (Iterable)list2);
                LanguageId languageId3 = languageId2;
                String string3 = string2;
                return new CodeHighlightingEngine.HighlightedCode(string3, languageId3, list3);
            }
        }
        return new CodeHighlightingEngine.HighlightedCode(code, languageId, previous.getTokens());
    }

    private final CodeHighlightingToken toHighlightingToken(TextmateToken $this$toHighlightingToken, int offset) {
        CodeHighlightingType codeHighlightingType = TextMateHighlighting.Companion.select($this$toHighlightingToken.getScope());
        if (codeHighlightingType == null) {
            return null;
        }
        return new CodeHighlightingToken(new IntRange(offset + $this$toHighlightingToken.getStartOffset(), offset + $this$toHighlightingToken.getEndOffset()), codeHighlightingType);
    }

    static {
        Pair[] pairArray = new Pair[8];
        Object[] objectArray = new String[]{"comment", "comment.line", "comment.block", "comment.documentation"};
        pairArray[0] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)((Object)CodeHighlightingType.COMMENT));
        pairArray[1] = TuplesKt.to((Object)SetsKt.setOf((Object)"string"), (Object)((Object)CodeHighlightingType.STRING));
        objectArray = new String[]{"constant", "constant.number", "constant.numeric", "constant.character.escape", "constant.character.entity"};
        pairArray[2] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)((Object)CodeHighlightingType.CONSTANT));
        objectArray = new String[]{"keyword", "keyword.function", "keyword.declaration", "keyword.operator", "storage", "storage.type"};
        pairArray[3] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)((Object)CodeHighlightingType.KEYWORD));
        pairArray[4] = TuplesKt.to((Object)SetsKt.setOf((Object)"entity.name.function"), (Object)((Object)CodeHighlightingType.FUNCTION_NAME));
        objectArray = new String[]{"entity.name", "entity.name.class"};
        pairArray[5] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)((Object)CodeHighlightingType.CLASS_NAME));
        pairArray[6] = TuplesKt.to((Object)SetsKt.setOf((Object)"entity"), (Object)((Object)CodeHighlightingType.IDENTIFIER));
        objectArray = new String[]{"variable", "variable.parameter"};
        pairArray[7] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)((Object)CodeHighlightingType.VARIABLE));
        mapping = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$sortedBy$iv = CollectionsKt.flatten((Iterable)mapping.keySet());
        boolean $i$f$sortedBy = false;
        selectors = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(-it.length());
                it = (String)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-it.length()));
            }
        });
    }

    @SourceDebugExtension(value={"SMAP\nTextMateHighlighting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateHighlighting.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/TextMateHighlighting$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n295#2,2:78\n1#3:80\n*S KotlinDebug\n*F\n+ 1 TextMateHighlighting.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/TextMateHighlighting$Companion\n*L\n35#1:78,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final CodeHighlightingType select(TextMateScope scopes) {
            Object v4;
            block5: {
                Object v2;
                Object it;
                block4: {
                    if (scopes == null) {
                        return null;
                    }
                    Iterable $this$firstOrNull$iv = selectors;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (String)element$iv;
                        boolean bl = false;
                        CharSequence charSequence = scopes.getScopeName();
                        boolean bl2 = charSequence != null ? StringsKt.startsWith$default((CharSequence)charSequence, (CharSequence)((CharSequence)it), (boolean)false, (int)2, null) : false;
                        if (!bl2) continue;
                        v2 = element$iv;
                        break block4;
                    }
                    v2 = null;
                }
                String string = v2;
                if (string == null) {
                    return this.select(scopes.getParent());
                }
                String selector = string;
                Iterable iterable = mapping.entrySet();
                for (Object t2 : iterable) {
                    it = (Map.Entry)t2;
                    boolean bl = false;
                    if (!((Set)it.getKey()).contains(selector)) continue;
                    v4 = t2;
                    break block5;
                }
                v4 = null;
            }
            Map.Entry entry = v4;
            return entry != null ? (CodeHighlightingType)((Object)entry.getValue()) : null;
        }

        @NotNull
        public final CodeHighlightingEngine all() {
            try {
                return new TextMateHighlighting(BundleCollection.Companion.read().all());
            }
            catch (Exception e) {
                Logger.INSTANCE.error((Throwable)e);
                return CodeHighlightingEngine.Empty.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

