/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.code;

import com.jetbrains.toolbox.common.code.LanguageId;
import com.jetbrains.toolbox.common.code.Languages;
import com.jetbrains.toolbox.markdown.skeleton.MarkdownSkeletonBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nMarkdownCodeFenceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownCodeFenceUtils.kt\ncom/jetbrains/toolbox/markdown/renderer/code/MarkdownCodeFenceUtils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n635#2,5:95\n413#2,4:133\n774#3:100\n865#3,2:101\n756#3,10:103\n739#3,9:113\n669#3,11:122\n*S KotlinDebug\n*F\n+ 1 MarkdownCodeFenceUtils.kt\ncom/jetbrains/toolbox/markdown/renderer/code/MarkdownCodeFenceUtils\n*L\n27#1:95,5\n44#1:133,4\n35#1:100\n35#1:101,2\n38#1:103,10\n39#1:113,9\n90#1:122,11\n*E\n"})
public final class MarkdownCodeFenceUtils {
    @NotNull
    public static final MarkdownCodeFenceUtils INSTANCE = new MarkdownCodeFenceUtils();
    @NotNull
    private static final Set<IElementType> CONTENT_TYPES;
    @NotNull
    private static final Set<Entry> aliases;
    public static final int $stable;

    private MarkdownCodeFenceUtils() {
    }

    public final boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    public final int getIndent(@NotNull MarkdownSkeletonBlock block) {
        CharSequence charSequence;
        int n;
        block3: {
            CharSequence charSequence2;
            char it;
            int index$iv;
            int n2;
            boolean $i$f$takeWhile;
            CharSequence $this$takeWhile$iv;
            CharSequence postfix;
            block2: {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                CharSequence prefix = block.getFile().subSequence(0, block.getRange().getStart());
                postfix = block.getText();
                $this$takeWhile$iv = StringsKt.reversed((CharSequence)prefix);
                $i$f$takeWhile = false;
                n2 = $this$takeWhile$iv.length();
                for (index$iv = 0; index$iv < n2; ++index$iv) {
                    it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (INSTANCE.isSpace(it)) continue;
                    charSequence2 = $this$takeWhile$iv.subSequence(0, index$iv);
                    break block2;
                }
                charSequence2 = $this$takeWhile$iv.subSequence(0, $this$takeWhile$iv.length());
            }
            $this$takeWhile$iv = postfix;
            n = charSequence2.length();
            $i$f$takeWhile = false;
            n2 = $this$takeWhile$iv.length();
            for (index$iv = 0; index$iv < n2; ++index$iv) {
                it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (INSTANCE.isSpace(it)) continue;
                charSequence = $this$takeWhile$iv.subSequence(0, index$iv);
                break block3;
            }
            charSequence = $this$takeWhile$iv.subSequence(0, $this$takeWhile$iv.length());
        }
        CharSequence charSequence3 = charSequence;
        int spaces = n + charSequence3.length();
        return spaces;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getContent(int indent, @NotNull List<? extends MarkdownSkeletonBlock> children) {
        List list2;
        void $this$dropLastWhile$iv;
        List $this$dropWhile$iv;
        MarkdownSkeletonBlock it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Iterable $this$filter$iv = children;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MarkdownSkeletonBlock)element$iv$iv;
            boolean bl = false;
            if (!CONTENT_TYPES.contains(it.getType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        Iterable $i$f$filter22 = filtered;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            it = (MarkdownSkeletonBlock)item$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL)) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        $this$dropWhile$iv = list$iv;
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                MarkdownSkeletonBlock it2 = (MarkdownSkeletonBlock)iterator$iv.previous();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownTokenTypes.EOL)) continue;
                list2 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List withoutNewLinesOnBorders = list2;
        String text2 = CollectionsKt.joinToString$default((Iterable)withoutNewLinesOnBorders, (CharSequence)"", null, null, (int)0, null, MarkdownCodeFenceUtils::getContent$lambda$5, (int)30, null);
        String[] stringArray = new String[]{"\n"};
        String textWithoutIndent = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> MarkdownCodeFenceUtils.getContent$lambda$7(indent, arg_0), (int)30, null);
        return textWithoutIndent;
    }

    @Nullable
    public final LanguageId findLanguageFromAlias(@NotNull String value2) {
        Entry entry;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            String string = value2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String lower = string;
            Iterable $this$singleOrNull$iv = aliases;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Entry it = (Entry)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)lower, (Object)it.getMain()) || it.getAliases().contains(lower))) continue;
                if (found$iv) {
                    v1 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        Entry entry2 = entry = (Entry)v1;
        return entry2 != null ? entry2.getId() : null;
    }

    private static final CharSequence getContent$lambda$5(MarkdownSkeletonBlock it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    private static final CharSequence getContent$lambda$7(int $indent, String it) {
        String string;
        block1: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String $this$dropWhile$iv = StringsKt.take((String)it, (int)$indent);
            boolean $i$f$dropWhile = false;
            int n = ((CharSequence)$this$dropWhile$iv).length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it2 = $this$dropWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (INSTANCE.isSpace(it2)) continue;
                String string2 = $this$dropWhile$iv.substring(index$iv);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break block1;
            }
            string = "";
        }
        return string + StringsKt.drop((String)it, (int)$indent);
    }

    static {
        Object[] objectArray = new IElementType[]{MarkdownTokenTypes.CODE_FENCE_CONTENT, MarkdownTokenTypes.EOL, MarkdownTokenTypes.WHITE_SPACE};
        CONTENT_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Entry[21];
        objectArray[0] = new Entry(Languages.INSTANCE.getGo(), "go", SetsKt.setOf((Object)"golang"));
        Object[] objectArray2 = new String[]{"bat", "batchfile"};
        objectArray[1] = new Entry(Languages.INSTANCE.getBatch(), "batch", SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"coffee", "coffee-script"};
        objectArray[2] = new Entry(Languages.INSTANCE.getCoffeeScript(), "coffeescript", SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"js", "node"};
        objectArray[3] = new Entry(Languages.INSTANCE.getJavaScript(), "javascript", SetsKt.setOf((Object[])objectArray2));
        objectArray[4] = new Entry(Languages.INSTANCE.getMarkdown(), "markdown", SetsKt.setOf((Object)"md"));
        objectArray2 = new String[]{"posh", "pwsh"};
        objectArray[5] = new Entry(Languages.INSTANCE.getPowershell(), "powershell", SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"python2", "python3", "py"};
        objectArray[6] = new Entry(Languages.INSTANCE.getPython(), "python", SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"rlang", "rscript"};
        objectArray[7] = new Entry(Languages.INSTANCE.getR(), "r", SetsKt.setOf((Object[])objectArray2));
        objectArray[8] = new Entry(Languages.INSTANCE.getRegexp(), "regexp", SetsKt.setOf((Object)"regex"));
        objectArray[9] = new Entry(Languages.INSTANCE.getRuby(), "ruby", SetsKt.setOf((Object)"rb"));
        objectArray[10] = new Entry(Languages.INSTANCE.getYaml(), "yaml", SetsKt.setOf((Object)"yml"));
        objectArray2 = new String[]{"kt", "kts"};
        objectArray[11] = new Entry(Languages.INSTANCE.getKotlin(), "kotlin", SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"hcl-terraform", "hcl", "tf"};
        objectArray[12] = new Entry(Languages.INSTANCE.getTerraform(), "terraform", SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"cs", "c#"};
        objectArray[13] = new Entry(Languages.INSTANCE.getCSharp(), "csharp", SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"fs", "f#"};
        objectArray[14] = new Entry(Languages.INSTANCE.getFSharp(), "fsharp", SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"shell script", "shellscript", "bash", "zsh", "sh"};
        objectArray[15] = new Entry(Languages.INSTANCE.getShell(), "shell", SetsKt.setOf((Object[])objectArray2));
        objectArray[16] = new Entry(Languages.INSTANCE.getText(), "text", SetsKt.setOf((Object)"plain"));
        objectArray2 = new String[]{"clang", "cc", "h"};
        objectArray[17] = new Entry(Languages.INSTANCE.getC(), "c", SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"objective-c", "objc", "obj-c"};
        objectArray[18] = new Entry(Languages.INSTANCE.getObjectiveC(), "objectivec", SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"cxx", "c++", "cpp", "hpp", "objective-c++", "objectivec++", "objective-cpp", "objectivecpp", "objc++", "objcpp", "obj-c++", "obj-cpp"};
        objectArray[19] = new Entry(Languages.INSTANCE.getCpp(), "cpp", SetsKt.setOf((Object[])objectArray2));
        objectArray[20] = new Entry(Languages.INSTANCE.getWasm(), "wasm", SetsKt.setOf((Object)"wat"));
        aliases = SetsKt.setOf((Object[])objectArray);
        $stable = 8;
    }

    private static final class Entry {
        @NotNull
        private final LanguageId id;
        @NotNull
        private final String main;
        @NotNull
        private final Set<String> aliases;

        public Entry(@NotNull LanguageId id, @NotNull String main2, @NotNull Set<String> aliases) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)main2, (String)"main");
            Intrinsics.checkNotNullParameter(aliases, (String)"aliases");
            this.id = id;
            this.main = main2;
            this.aliases = aliases;
        }

        @NotNull
        public final LanguageId getId() {
            return this.id;
        }

        @NotNull
        public final String getMain() {
            return this.main;
        }

        @NotNull
        public final Set<String> getAliases() {
            return this.aliases;
        }

        @NotNull
        public String toString() {
            return "Entry(id=" + this.id + ", main=" + this.main + ", aliases=" + this.aliases + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.main.hashCode();
            result2 = result2 * 31 + ((Object)this.aliases).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)entry.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.main, (Object)entry.main)) {
                return false;
            }
            return Intrinsics.areEqual(this.aliases, entry.aliases);
        }
    }
}

