/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.common.extensions.ByteArrayExtensionsKt;
import com.jetbrains.toolbox.common.security.ShaKt;
import com.jetbrains.toolbox.feed.RemoteChecksum;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import java.security.MessageDigest;
import java.util.List;
import java.util.Locale;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class VerificationStateWorkerKt {
    @NotNull
    public static final ChannelEvent verifyChecksums(@NotNull FileSystem fileSystem, @NotNull Path file, @NotNull List<RemoteChecksum> checksums) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(checksums, (String)"checksums");
        boolean checked = false;
        for (RemoteChecksum checksum : checksums) {
            String string;
            MessageDigest alg;
            String string2;
            Intrinsics.checkNotNullExpressionValue((Object)checksum.getAlg().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            MessageDigest messageDigest = Intrinsics.areEqual((Object)string2, (Object)"sha-256") ? ShaKt.getSHA256() : (alg = Intrinsics.areEqual((Object)string2, (Object)"sha-512") ? ShaKt.getSHA512() : null);
            if (alg == null) {
                Logger.INSTANCE.warn("Hash " + checksum.getAlg() + " is not supported");
                continue;
            }
            try {
                string = ByteArrayExtensionsKt.toHex$default(ShaKt.computeDigest(alg, fileSystem, file), null, false, 3, null);
            }
            catch (Exception e) {
                Logger.INSTANCE.error((Throwable)e, "Cannot compute checksum for " + file);
                return ChannelEvent.VerificationFailed.INSTANCE;
            }
            String actualChecksum = string;
            if (!StringsKt.equals((String)checksum.getValue(), (String)actualChecksum, (boolean)true)) {
                Logger.INSTANCE.error("Wrong checksum for " + file + " expect " + checksum.getValue() + " got " + actualChecksum);
                return ChannelEvent.VerificationFailed.INSTANCE;
            }
            Logger.INSTANCE.info("Correct checksum for " + file + " (" + checksum.getValue() + ")");
            checked = true;
        }
        if (!checked) {
            Logger.INSTANCE.error("No supported checksums provided for the package");
            return ChannelEvent.VerificationFailed.INSTANCE;
        }
        return ChannelEvent.VerificationSuccessful.INSTANCE;
    }
}

