/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.manager.tool.ToolCleanupManager;
import com.jetbrains.toolbox.tools.ExtensionsKt;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ChannelStateKt;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class ToolCleanupManagerImpl
implements ToolCleanupManager {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Clock clock;
    private final long clientCleanupPeriod;

    public ToolCleanupManagerImpl(@NotNull FileSystem fileSystem, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.fileSystem = fileSystem;
        this.clock = clock;
        this.clientCleanupPeriod = DurationKt.toDuration((int)14, (DurationUnit)DurationUnit.DAYS);
    }

    @Override
    @Nullable
    public Object postInstallHook(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super Unit> $completion) {
        if (!ApplicationType.equals-impl0(toolInstance.getTool().getToolId-UtVBrGo(), WellKnownApplications.INSTANCE.getJetBrainsClient-UtVBrGo())) {
            return Unit.INSTANCE;
        }
        try {
            Logger.INSTANCE.debug("Updating frontend launcher access time");
            Path path2 = ExtensionsKt.getLaunchCommand(toolInstance);
            if (path2 != null) {
                Path installCommand = path2;
                boolean bl = false;
                Path path3 = Path.resolve$default((Path)installCommand, (Path)toolInstance.getChannel().getInstallationDirectory(), (boolean)false, (int)2, null);
                Files.setAttribute(path3.toNioPath(), "lastAccessTime", FileTime.from(ConvertersKt.toJavaInstant((Instant)this.clock.now())), new LinkOption[0]);
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Error occurred during post-install hook");
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object toBeDeleted(@NotNull ChannelState channel, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((ApplicationType.equals-impl0(channel.getTool().getToolId-UtVBrGo(), WellKnownApplications.INSTANCE.getJetBrainsClient-UtVBrGo()) && this.modifiedBeforeCleanupThreshold(channel) ? 1 : 0) != 0);
    }

    private final boolean modifiedBeforeCleanupThreshold(ChannelState $this$modifiedBeforeCleanupThreshold) {
        Instant cleanupTimestamp;
        Path usedOrInstalledAt;
        boolean tooOld;
        Path path2;
        block12: {
            Instant instant;
            Object object;
            Object launchCommand;
            block11: {
                Instant instant2;
                ToolInstance toolInstance = ChannelStateKt.toToolInstanceOrNull($this$modifiedBeforeCleanupThreshold);
                launchCommand = toolInstance != null ? ExtensionsKt.getLaunchCommand(toolInstance) : null;
                path2 = launchCommand;
                if (path2 == null) break block11;
                Path launchCommand2 = path2;
                boolean bl = false;
                Object object2 = this.fileSystem.metadataOrNull(Path.resolve$default((Path)launchCommand2, (Path)$this$modifiedBeforeCleanupThreshold.getChannel().getInstallationDirectory(), (boolean)false, (int)2, null));
                if (object2 != null && (object2 = object2.getLastAccessedAtMillis()) != null) {
                    long it = ((Number)object2).longValue();
                    boolean bl2 = false;
                    instant2 = Instant.Companion.fromEpochMilliseconds(it);
                } else {
                    instant2 = null;
                }
                path2 = instant2;
                if (instant2 != null) break block12;
            }
            ChannelState $this$modifiedBeforeCleanupThreshold_u24lambda_u244 = $this$modifiedBeforeCleanupThreshold;
            boolean bl = false;
            if (launchCommand == null) {
                Logger.INSTANCE.warn("Unable to locate executable for " + InstalledToolKt.displayNameWithVersion($this$modifiedBeforeCleanupThreshold_u24lambda_u244.getChannel(), $this$modifiedBeforeCleanupThreshold_u24lambda_u244.getTool()) + ". Checking installation directory last modification time.");
            } else {
                Logger.INSTANCE.warn(InstalledToolKt.displayNameWithVersion($this$modifiedBeforeCleanupThreshold_u24lambda_u244.getChannel(), $this$modifiedBeforeCleanupThreshold_u24lambda_u244.getTool()) + " has never been launched yet. Checking installation directory last modification time.");
            }
            if ((object = this.fileSystem.metadataOrNull($this$modifiedBeforeCleanupThreshold_u24lambda_u244.getChannel().getInstallationDirectory())) != null && (object = object.getLastModifiedAtMillis()) != null) {
                long it = ((Number)object).longValue();
                boolean bl3 = false;
                instant = Instant.Companion.fromEpochMilliseconds(it);
            } else {
                instant = null;
            }
            path2 = instant;
            if (instant == null) {
                ChannelState $this$modifiedBeforeCleanupThreshold_u24lambda_u245 = $this$modifiedBeforeCleanupThreshold;
                boolean bl4 = false;
                Logger.INSTANCE.error("Unable to locate or collect metadata for neither executable nor installation directory of " + InstalledToolKt.displayNameWithVersion($this$modifiedBeforeCleanupThreshold_u24lambda_u245.getChannel(), $this$modifiedBeforeCleanupThreshold_u24lambda_u245.getTool()) + ". Can't decide on deleting the tool.");
                return false;
            }
        }
        boolean bl = tooOld = (usedOrInstalledAt = path2).compareTo(cleanupTimestamp = this.clock.now().minus-LRDsOJo(this.clientCleanupPeriod)) < 0;
        if (tooOld) {
            Logger.INSTANCE.debug("Local counterpart " + InstalledToolKt.displayNameWithVersion($this$modifiedBeforeCleanupThreshold.getChannel(), $this$modifiedBeforeCleanupThreshold.getTool()) + " was modified (" + (Instant)usedOrInstalledAt + ") before deletion threshold (" + cleanupTimestamp + ")");
        }
        return tooOld;
    }
}

