/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.ChangeOptionsCalculator;
import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.model.AvailableBuild;
import com.jetbrains.toolbox.tools.model.ChangeOptions;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ChannelStateKt;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class RefreshingPendingUpdateStateWorker
implements ChannelStateWorker<ChannelState.RefreshingPendingUpdate> {
    @NotNull
    private final ChangeOptionsCalculator changeOptionsCalculator;

    public RefreshingPendingUpdateStateWorker(@NotNull ChangeOptionsCalculator changeOptionsCalculator) {
        Intrinsics.checkNotNullParameter((Object)changeOptionsCalculator, (String)"changeOptionsCalculator");
        this.changeOptionsCalculator = changeOptionsCalculator;
    }

    @Override
    @NotNull
    public KClass<ChannelState.RefreshingPendingUpdate> getState() {
        return Reflection.getOrCreateKotlinClass(ChannelState.RefreshingPendingUpdate.class);
    }

    @Override
    @Nullable
    public Object handle(@NotNull ChannelState.RefreshingPendingUpdate state2, @NotNull Continuation<? super ChannelEvent> $completion) {
        ChangeOptions changeOptions;
        try {
            changeOptions = this.changeOptionsCalculator.calculateOptions(ChannelStateKt.toToolInstance(state2));
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Failed to compute update for " + state2.getTool());
            changeOptions = state2.getChangeOptions();
        }
        ChangeOptions options = changeOptions;
        Object object = options.getUpdate();
        String updateBuildNumber = object != null && (object = object.getBuild()) != null && (object = ((ToolBuild)object).getBuild()) != null ? ((AvailableBuild)object).getId-Y_E1uuk() : null;
        return updateBuildNumber != null && BuildNumber.compareTo-Szkhn3Q(updateBuildNumber, state2.getBuild().getBuild().getId-Y_E1uuk()) > 0 ? (ChannelEvent)new ChannelEvent.Refreshed(ChannelStateKt.toToolInstance(state2), options) : (ChannelEvent)new ChannelEvent.Completed(state2.getChannel(), state2.getTool());
    }
}

