/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.manager.CacheManager;
import com.jetbrains.toolbox.tools.image.ImageManager;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nCacheManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheManagerImpl.kt\ncom/jetbrains/toolbox/managers/CacheManagerImpl\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n*L\n1#1,102:1\n66#2:103\n52#2,4:105\n60#2,10:110\n56#2,3:120\n71#2,3:123\n52#2,4:129\n60#2,10:134\n56#2,18:144\n67#3:104\n68#3:109\n80#3:126\n165#3:127\n81#3:128\n82#3:133\n*S KotlinDebug\n*F\n+ 1 CacheManagerImpl.kt\ncom/jetbrains/toolbox/managers/CacheManagerImpl\n*L\n51#1:103\n51#1:105,4\n51#1:110,10\n51#1:120,3\n51#1:123,3\n77#1:129,4\n77#1:134,10\n77#1:144,18\n51#1:104\n51#1:109\n77#1:126\n77#1:127\n77#1:128\n77#1:133\n*E\n"})
public final class CacheManagerImpl<T>
implements CacheManager<T> {
    @NotNull
    private final Path path;
    @NotNull
    private final KSerializer<T> serializer;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final T defaultValue;
    @NotNull
    private final Json parser;
    @NotNull
    private final MutableStateFlow<T> cache;

    public CacheManagerImpl(@NotNull Path path2, @NotNull KSerializer<T> serializer2, @NotNull FileSystem fileSystem, @NotNull T defaultValue, @NotNull ImageManager imageManager, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter((Object)imageManager, (String)"imageManager");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.path = path2;
        this.serializer = serializer2;
        this.fileSystem = fileSystem;
        this.defaultValue = defaultValue;
        this.parser = JsonKt.Json$default(null, CacheManagerImpl::parser$lambda$0, (int)1, null);
        T t2 = this.loadCache();
        if (t2 == null) {
            t2 = this.defaultValue;
        }
        this.cache = StateFlowKt.MutableStateFlow(t2);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CacheManagerImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.getCache()), (Function2)new Function2<T, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ CacheManagerImpl<T> this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.this$0.saveToFile(it);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(T p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @NotNull
    public MutableStateFlow<T> getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final T loadCache() {
        FileSystem fileSystem;
        if (!this.fileSystem.exists(this.path)) {
            return null;
        }
        try {
            Object object;
            Throwable thrown$iv$iv;
            block19: {
                void this_$iv;
                fileSystem = this.fileSystem;
                Path file$iv = this.path;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$loadCache_u24lambda_u241 = it$iv;
                    boolean bl3 = false;
                    Object data2 = OkioStreamsKt.decodeFromBufferedSource((Json)this.parser, (DeserializationStrategy)((DeserializationStrategy)this.serializer), (BufferedSource)$this$loadCache_u24lambda_u241);
                    Logger.INSTANCE.info("Retrieved from file: " + this.path);
                    object = data2;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        object = null;
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block20: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block20;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Object result$iv$iv = object;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            fileSystem = result$iv$iv;
            return (T)fileSystem;
        }
        catch (SerializationException e) {
            Logger.INSTANCE.warn("Could not decode cache from '" + this.path + "', reason: " + e.getMessage());
            fileSystem = null;
            return (T)fileSystem;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Could not read cache from '" + this.path + "'");
            fileSystem = null;
        }
        return (T)fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveToFile(T value2) {
        if (!Intrinsics.areEqual(value2, this.defaultValue)) {
            try {
                Unit unit;
                Throwable thrown$iv$iv;
                block22: {
                    void $this$iv;
                    FileSystem parent;
                    if (!this.fileSystem.exists(this.path) && (parent = this.path.parent()) != null) {
                        this.fileSystem.createDirectories((Path)parent);
                    }
                    parent = this.fileSystem;
                    Path file$iv = this.path;
                    boolean mustCreate$iv = false;
                    boolean bl = false;
                    Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                    boolean $i$f$use = false;
                    thrown$iv$iv = null;
                    try {
                        BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                        boolean bl2 = false;
                        BufferedSink $this$saveToFile_u24lambda_u242 = it$iv;
                        boolean bl3 = false;
                        OkioStreamsKt.encodeToBufferedSink((Json)this.parser, (SerializationStrategy)((SerializationStrategy)this.serializer), value2, (BufferedSink)$this$saveToFile_u24lambda_u242);
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable t$iv$iv) {
                        try {
                            thrown$iv$iv = t$iv$iv;
                            unit = null;
                            break block22;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            block23: {
                                try {
                                    Closeable closeable = $this$use$iv$iv;
                                    if (closeable != null) {
                                        closeable.close();
                                    }
                                }
                                catch (Throwable t$iv$iv2) {
                                    if (thrown$iv$iv == null) {
                                        thrown$iv$iv = t$iv$iv2;
                                        break block23;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                                }
                            }
                        }
                    }
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                }
                Unit result$iv$iv = unit;
                Throwable throwable = thrown$iv$iv;
                if (throwable != null) {
                    throw throwable;
                }
                Logger.INSTANCE.debug("Saved cache to '" + this.path + "'");
                return;
            }
            catch (Exception e) {
                Logger.INSTANCE.warn((Throwable)e, "Could not write cache to '" + this.path + "'");
                return;
            }
        }
        try {
            if (this.fileSystem.exists(this.path)) {
                this.fileSystem.delete(this.path);
                Logger.INSTANCE.info("Successfully removed the file under " + this.path + " path");
                return;
            }
            Logger.INSTANCE.info("There is no file under " + this.path + " to remove");
            return;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Unable to remove the file under " + this.path + " path");
        }
    }

    @Override
    public void reset() {
        this.getCache().setValue(this.defaultValue);
    }

    private static final Unit parser$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(false);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        $this$Json.setAllowStructuredMapKeys(true);
        return Unit.INSTANCE;
    }
}

