/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.manager.CacheManager;
import com.jetbrains.toolbox.manager.CacheManagerFactory;
import com.jetbrains.toolbox.managers.CacheManagerImpl;
import com.jetbrains.toolbox.tools.image.ImageManager;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.KSerializer;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;

public final class CacheManagerFactoryImpl
implements CacheManagerFactory {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final ImageManager imageManager;
    @NotNull
    private final WellKnownPaths wellKnownPaths;
    @NotNull
    private final CoroutineScope coroutineScope;

    public CacheManagerFactoryImpl(@NotNull FileSystem fileSystem, @NotNull ImageManager imageManager, @NotNull WellKnownPaths wellKnownPaths, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)imageManager, (String)"imageManager");
        Intrinsics.checkNotNullParameter((Object)wellKnownPaths, (String)"wellKnownPaths");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.fileSystem = fileSystem;
        this.imageManager = imageManager;
        this.wellKnownPaths = wellKnownPaths;
        this.coroutineScope = coroutineScope;
    }

    @Override
    @NotNull
    public <T> CacheManager<T> create(@NotNull String fileName, @NotNull KSerializer<T> serializer2, @NotNull T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        return new CacheManagerImpl<T>(this.wellKnownPaths.getToolboxCacheLocation().resolve(fileName), serializer2, this.fileSystem, defaultValue, this.imageManager, this.coroutineScope);
    }

    @Override
    @NotNull
    public <T> CacheManager<T> create(@NotNull Path filePath, @NotNull KSerializer<T> serializer2, @NotNull T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        return new CacheManagerImpl<T>(filePath, serializer2, this.fileSystem, defaultValue, this.imageManager, this.coroutineScope);
    }
}

