/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nBackupVerificationStateWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupVerificationStateWorker.kt\ncom/jetbrains/toolbox/managers/BackupVerificationStateWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n827#2:49\n855#2,2:50\n*S KotlinDebug\n*F\n+ 1 BackupVerificationStateWorker.kt\ncom/jetbrains/toolbox/managers/BackupVerificationStateWorker\n*L\n34#1:49\n34#1:50,2\n*E\n"})
public final class BackupVerificationStateWorker
implements ChannelStateWorker<ChannelState.BackupVerifying> {
    @NotNull
    private final FileSystem fileSystem;

    public BackupVerificationStateWorker(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    @NotNull
    public KClass<ChannelState.BackupVerifying> getState() {
        return Reflection.getOrCreateKotlinClass(ChannelState.BackupVerifying.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object handle(@NotNull ChannelState.BackupVerifying state2, @NotNull Continuation<? super ChannelEvent> $completion) {
        Path backupDirectory = state2.getBackupDirectory();
        try {
            boolean bl;
            FileMetadata metadata = this.fileSystem.metadataOrNull(backupDirectory);
            if (metadata == null) {
                Logger.INSTANCE.info("Backup directory '" + backupDirectory + "' for " + InstalledToolKt.displayNameWithVersion(state2.getChannel(), state2.getTool()) + " does not exist");
                return ChannelEvent.VerificationFailed.INSTANCE;
            }
            if (!metadata.isDirectory()) {
                Logger.INSTANCE.warn("Backup path '" + backupDirectory + "' for " + InstalledToolKt.displayNameWithVersion(state2.getChannel(), state2.getTool()) + " is not a directory");
                return ChannelEvent.VerificationFailed.INSTANCE;
            }
            List list2 = this.fileSystem.listOrNull(backupDirectory);
            if (list2 != null) {
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv = list2;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    Path it = (Path)element$iv$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.name(), (Object)".DS_Store")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                bl = !((Collection)((List)destination$iv$iv)).isEmpty();
            } else {
                bl = false;
            }
            if (!bl) {
                Logger.INSTANCE.info("Backup directory '" + backupDirectory + "' for " + InstalledToolKt.displayNameWithVersion(state2.getChannel(), state2.getTool()) + " is empty");
                return ChannelEvent.VerificationFailed.INSTANCE;
            }
        }
        catch (IOException e) {
            Logger.INSTANCE.error("Verification of backup directory '" + backupDirectory + "' failed: " + e.getMessage());
            return ChannelEvent.VerificationFailed.INSTANCE;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Verification of backup directory '" + backupDirectory + "' failed");
            return ChannelEvent.VerificationFailed.INSTANCE;
        }
        return ChannelEvent.VerificationSuccessful.INSTANCE;
    }
}

