/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.macos;

import com.jetbrains.toolbox.macos.MacOSAppRenamer;
import com.jetbrains.toolbox.tools.ToolUninstaller;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.model.ApplicationDirectorySideEffect;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.OsIntegration;
import com.jetbrains.toolbox.tools.model.SideEffect;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolRefreshHandler;
import com.jetbrains.toolbox.tools.model.WithSideEffects;
import java.util.Collection;
import java.util.List;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class MacOSAppRenamer
implements OsIntegration,
ToolRefreshHandler {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final ToolUninstaller toolUninstaller;

    public MacOSAppRenamer(@NotNull FileSystem fileSystem, @NotNull ToolUninstaller toolUninstaller) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)toolUninstaller, (String)"toolUninstaller");
        this.fileSystem = fileSystem;
        this.toolUninstaller = toolUninstaller;
    }

    @NotNull
    public List<SideEffect> getSideEffects() {
        return CollectionsKt.listOf((Object)ApplicationDirectorySideEffect.INSTANCE);
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        String customName;
        String currentName = StringsKt.removeSuffix((String)toolInstance.getChannel().getInstallationDirectory().name(), (CharSequence)".app");
        Path path2 = toolInstance.getChannel().getInstallationDirectory().parent();
        if (path2 == null) {
            return toolInstance;
        }
        Path parentDir = path2;
        String string = toolInstance.getChannel().getCustomName();
        String string2 = customName = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        if (customName != null) {
            ToolInstance toolInstance2;
            if (Intrinsics.areEqual((Object)currentName, (Object)customName)) {
                toolInstance2 = toolInstance;
            } else {
                Object object = this.renameAppToOrNumbered(toolInstance, customName, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                toolInstance2 = (ToolInstance)object;
            }
            return toolInstance2;
        }
        String toolAndVersionName = toolInstance.getTool().getToolName() + " " + toolInstance.getTool().getVersionName();
        if (Intrinsics.areEqual((Object)currentName, (Object)toolAndVersionName)) {
            return toolInstance;
        }
        if (Intrinsics.areEqual((Object)currentName, (Object)toolInstance.getTool().getToolName())) {
            return toolInstance;
        }
        Path newDirectory = parentDir.resolve(toolInstance.getTool().getToolName() + ".app");
        if (!this.fileSystem.exists(newDirectory)) {
            return this.renameAppTo(toolInstance, newDirectory, $completion);
        }
        newDirectory = parentDir.resolve(toolAndVersionName + ".app");
        if (!this.fileSystem.exists(newDirectory)) {
            return this.renameAppTo(toolInstance, newDirectory, $completion);
        }
        return this.renameAppToOrNumbered(toolInstance, toolInstance.getTool().getToolName(), $completion);
    }

    private final Object renameAppToOrNumbered(ToolInstance $this$renameAppToOrNumbered, String basename, Continuation<? super ToolInstance> $completion) {
        Path currentDirectory = $this$renameAppToOrNumbered.getChannel().getInstallationDirectory();
        Path path2 = currentDirectory.parent();
        if (path2 == null) {
            return $this$renameAppToOrNumbered;
        }
        Path parent = path2;
        Path newDirectory = parent.resolve(basename + ".app");
        int count = 1;
        while (this.fileSystem.exists(newDirectory)) {
            if (Intrinsics.areEqual((Object)currentDirectory, (Object)newDirectory)) {
                return $this$renameAppToOrNumbered;
            }
            newDirectory = parent.resolve(basename + " " + ++count + ".app");
        }
        return this.renameAppTo($this$renameAppToOrNumbered, newDirectory, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object renameAppTo(ToolInstance $this$renameAppTo, Path newDirectory, Continuation<? super ToolInstance> $completion) {
        if (!($completion instanceof renameAppTo.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MacOSAppRenamer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MacOSAppRenamer.access$renameAppTo(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this$renameAppTo;
                $continuation.L$1 = newDirectory;
                $continuation.label = 1;
                v0 = this.toolUninstaller.canUninstall($this$renameAppTo, (Continuation<? super UninstallResult>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                newDirectory = (Path)$continuation.L$1;
                $this$renameAppTo = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                canUninstall = (UninstallResult)v0;
                currentDirectory = $this$renameAppTo.getChannel().getInstallationDirectory();
                if (!Intrinsics.areEqual((Object)canUninstall, (Object)UninstallResult.Success.INSTANCE)) {
                    Logger.INSTANCE.warn(currentDirectory + " is running, not renaming");
                    return $this$renameAppTo;
                }
                Logger.INSTANCE.info("Renaming macOS app from " + currentDirectory + " to " + newDirectory);
                this.fileSystem.atomicMove(currentDirectory, newDirectory);
                return ToolInstance.copy$default($this$renameAppTo, Channel.copy$default($this$renameAppTo.getChannel(), null, null, newDirectory, false, null, false, null, false, null, null, null, 2043, null), null, 2, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull ToolInstance initial, @NotNull Continuation<? super ToolInstance> $completion) {
        return ToolRefreshHandler.super.onRefresh(toolInstance, initial, $completion);
    }

    @Override
    public boolean dependsOn(@NotNull WithSideEffects other) {
        return ToolRefreshHandler.super.dependsOn(other);
    }

    @Override
    @NotNull
    public Collection<SideEffect> getRunAfter() {
        return ToolRefreshHandler.super.getRunAfter();
    }

    public static final /* synthetic */ Object access$renameAppTo(MacOSAppRenamer $this, ToolInstance $receiver, Path newDirectory, Continuation $completion) {
        return $this.renameAppTo($receiver, newDirectory, (Continuation<? super ToolInstance>)$completion);
    }
}

