/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.log;

import com.jetbrains.toolbox.common.ToolboxLoggingProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.tinylog.Level;
import org.tinylog.kotlin.Logger;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;
import org.tinylog.writers.Writer;

@SourceDebugExtension(value={"SMAP\nLogFlusher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFlusher.kt\ncom/jetbrains/toolbox/log/LogFlusher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n10135#2:69\n10557#2,5:70\n1#3:75\n*S KotlinDebug\n*F\n+ 1 LogFlusher.kt\ncom/jetbrains/toolbox/log/LogFlusher\n*L\n24#1:69\n24#1:70,5\n*E\n"})
public final class LogFlusher {
    @NotNull
    public static final LogFlusher INSTANCE = new LogFlusher();

    private LogFlusher() {
    }

    /*
     * WARNING - void declaration
     */
    public final void forceFlush() {
        try {
            void $this$flatMapTo$iv$iv;
            ToolboxLoggingProvider provider2;
            LoggingProvider loggingProvider = ProviderRegistry.getLoggingProvider();
            ToolboxLoggingProvider toolboxLoggingProvider = provider2 = loggingProvider instanceof ToolboxLoggingProvider ? (ToolboxLoggingProvider)loggingProvider : null;
            if (provider2 == null) {
                Logger.INSTANCE.warn("Cannot force flush logs: ToolboxLoggingProvider not available");
                return;
            }
            Level[] $this$flatMap$iv = Level.values();
            boolean $i$f$flatMap = false;
            Level[] levelArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                List list2;
                void element$iv$iv;
                void level = element$iv$iv = $this$flatMapTo$iv$iv[j];
                boolean bl = false;
                try {
                    Writer[] writerArray = provider2.getConfiguredWritersForDefaultTagAndErrorLevel(0, (Level)level);
                    Intrinsics.checkNotNullExpressionValue((Object)writerArray, (String)"getConfiguredWritersForD\u2026aultTagAndErrorLevel(...)");
                    list2 = ArraysKt.toList((Object[])writerArray);
                }
                catch (Exception e) {
                    list2 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List writers = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            if (writers.isEmpty()) {
                Logger.INSTANCE.warn("No log writers found to flush");
                return;
            }
            boolean flushMethodFound = false;
            for (Writer writer2 : writers) {
                try {
                    Method flushMethod = this.findFlushMethod(writer2.getClass());
                    if (flushMethod == null) continue;
                    flushMethod.invoke((Object)writer2, new Object[0]);
                    flushMethodFound = true;
                }
                catch (Exception e) {
                    Logger.INSTANCE.warn((Throwable)e, "Failed to flush writer: " + writer2.getClass().getSimpleName());
                }
            }
            if (!flushMethodFound) {
                System.out.flush();
                System.err.flush();
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Failed to force flush logs");
        }
    }

    private final Method findFlushMethod(Class<?> clazz) {
        Method method;
        try {
            Method method2 = clazz.getDeclaredMethod("flush", new Class[0]);
            method2.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            Method method3;
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                Class<?> it = clazz2;
                boolean bl = false;
                method3 = INSTANCE.findFlushMethod(it);
            } else {
                method3 = null;
            }
            method = method3;
        }
        return method;
    }
}

