/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.log;

import com.jetbrains.toolbox.AppFlavor;
import com.jetbrains.toolbox.ApplicationStartInfo;
import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.common.BlurTokensKt;
import com.jetbrains.toolbox.common.ToolboxLoggingProvider;
import com.jetbrains.toolbox.common.datetime.InstantExtensionsKt;
import com.jetbrains.toolbox.logging.bootstrap.ToolboxSlf4jServiceProvider;
import java.io.File;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;
import org.slf4j.spi.SLF4JServiceProvider;
import org.tinylog.Level;
import org.tinylog.kotlin.Logger;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;
import org.tinylog.runtime.RuntimeProvider;
import org.tinylog.slf4j.ModernTinylogLoggerFactory;
import org.tinylog.slf4j.TinylogSlf4jServiceProvider;
import org.tinylog.writers.Writer;

@SourceDebugExtension(value={"SMAP\nBootstrapLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BootstrapLogger.kt\ncom/jetbrains/toolbox/log/BootstrapLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n79#1,7:292\n79#1,7:303\n79#1,7:310\n1#2:291\n1#2:329\n11228#3:299\n11563#3,3:300\n11546#3,9:319\n13472#3:328\n13473#3:330\n11555#3:331\n216#4,2:317\n1068#5:332\n*S KotlinDebug\n*F\n+ 1 BootstrapLogger.kt\ncom/jetbrains/toolbox/log/BootstrapLogger\n*L\n148#1:292,7\n183#1:303,7\n185#1:310,7\n261#1:329\n174#1:299\n174#1:300,3\n261#1:319,9\n261#1:328\n261#1:330\n261#1:331\n239#1:317,2\n269#1:332\n*E\n"})
public abstract class BootstrapLogger {
    @NotNull
    private final ApplicationStartInfo appStartInfo;
    @NotNull
    private String defaultLogLevel;
    @NotNull
    private final Queue<LogEntry> messages;
    private boolean isTinylogEnabled;
    @NotNull
    private final Lazy toolboxLoggingProvider$delegate;

    public BootstrapLogger(@NotNull ApplicationStartInfo appStartInfo) {
        Intrinsics.checkNotNullParameter((Object)appStartInfo, (String)"appStartInfo");
        this.appStartInfo = appStartInfo;
        this.defaultLogLevel = "info";
        this.messages = new ConcurrentLinkedQueue();
        this.toolboxLoggingProvider$delegate = LazyKt.lazy(BootstrapLogger::toolboxLoggingProvider_delegate$lambda$0);
    }

    @NotNull
    public final String getDefaultLogLevel() {
        return this.defaultLogLevel;
    }

    public final void setDefaultLogLevel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.defaultLogLevel = string;
    }

    @NotNull
    public final Queue<LogEntry> getMessages() {
        return this.messages;
    }

    public synchronized boolean isTinylogEnabled() {
        return this.isTinylogEnabled;
    }

    public synchronized void setTinylogEnabled(boolean bl) {
        this.isTinylogEnabled = bl;
    }

    private final ToolboxLoggingProvider getToolboxLoggingProvider() {
        Lazy lazy = this.toolboxLoggingProvider$delegate;
        return (ToolboxLoggingProvider)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTraceEnabled() {
        if (this.appStartInfo.isTrace()) return true;
        if (!this.isTinylogEnabled()) return false;
        ToolboxLoggingProvider toolboxLoggingProvider = this.getToolboxLoggingProvider();
        if ((toolboxLoggingProvider != null ? toolboxLoggingProvider.getLevel() : null) != Level.TRACE) return false;
        return true;
    }

    public final void writeln(@NotNull Level level, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        String dateTimePattern = "HH:mm:ss.SSS";
        String timestamp2 = LocalTime.now().format(DateTimeFormatter.ofPattern(dateTimePattern));
        String string = RuntimeProvider.getCallerClassName((String)BootstrapLogger.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCallerClassName(...)");
        String callerName = StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null);
        String levelStr = StringsKt.take((String)StringsKt.padEnd$default((String)level.name(), (int)5, (char)'\u0000', (int)2, null), (int)5);
        String string2 = Thread.currentThread().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String threadName = StringsKt.take((String)StringsKt.padEnd$default((String)string2, (int)25, (char)'\u0000', (int)2, null), (int)25);
        String callerNameStr = StringsKt.take((String)StringsKt.padEnd$default((String)callerName, (int)25, (char)'\u0000', (int)2, null), (int)25);
        this.writelnNoTinylog(timestamp2 + " | " + levelStr + " | " + threadName + " | " + callerNameStr + " | " + message2);
    }

    protected void writelnNoTinylog(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        System.out.println((Object)message2);
    }

    public final void info(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        boolean $i$f$info = false;
        if (this.isTinylogEnabled()) {
            Logger.INSTANCE.info(message2);
        } else {
            this.getMessages().add(new LogEntry(Level.INFO, message2, null, 4, null));
            this.writeln(Level.INFO, message2);
        }
    }

    public final void debug(@Nullable Throwable exception, @NotNull String message2) {
        block6: {
            Object object;
            block8: {
                block7: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                        boolean $i$f$debug = false;
                        if (!this.isTinylogEnabled()) break block5;
                        Throwable throwable = exception;
                        if (throwable != null) {
                            Throwable it = throwable;
                            boolean bl = false;
                            Logger.INSTANCE.debug(it, message2);
                        } else {
                            Logger.INSTANCE.debug(message2);
                        }
                        break block6;
                    }
                    this.getMessages().add(new LogEntry(Level.DEBUG, message2, exception));
                    object = exception;
                    if (object == null) break block7;
                    Throwable it = object;
                    boolean bl = false;
                    String string = "\n" + it;
                    object = string;
                    if (string != null) break block8;
                }
                object = "";
            }
            Object exceptionInfo = object;
            this.writeln(Level.DEBUG, message2 + (String)exceptionInfo);
        }
    }

    public final void trace(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        boolean $i$f$trace = false;
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isTinylogEnabled()) {
            Logger.INSTANCE.trace(message2);
        } else {
            this.getMessages().add(new LogEntry(Level.TRACE, message2, null, 4, null));
            this.writeln(Level.TRACE, message2);
        }
    }

    public final void warn(@Nullable Throwable exception, @NotNull String message2) {
        block6: {
            Object object;
            block8: {
                block7: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                        boolean $i$f$warn = false;
                        if (!this.isTinylogEnabled()) break block5;
                        if (exception == null) {
                            Logger.INSTANCE.warn(message2);
                        } else {
                            Logger.INSTANCE.warn(exception, message2);
                        }
                        break block6;
                    }
                    this.getMessages().add(new LogEntry(Level.WARN, message2, exception));
                    object = exception;
                    if (object == null) break block7;
                    Throwable it = object;
                    boolean bl = false;
                    String string = "\n" + it;
                    object = string;
                    if (string != null) break block8;
                }
                object = "";
            }
            Object exceptionInfo = object;
            this.writeln(Level.WARN, message2 + (String)exceptionInfo);
        }
    }

    public final void error(@Nullable Throwable exception, @NotNull String message2) {
        block6: {
            Object object;
            block8: {
                block7: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                        boolean $i$f$error = false;
                        if (!this.isTinylogEnabled()) break block5;
                        if (exception == null) {
                            Logger.INSTANCE.error(message2);
                        } else {
                            Logger.INSTANCE.error(exception, message2);
                        }
                        break block6;
                    }
                    this.getMessages().add(new LogEntry(Level.ERROR, message2, exception));
                    object = exception;
                    if (object == null) break block7;
                    Throwable it = object;
                    boolean bl = false;
                    String string = "\n" + ExceptionsKt.stackTraceToString((Throwable)it);
                    object = string;
                    if (string != null) break block8;
                }
                object = "";
            }
            Object exceptionInfo = object;
            this.writeln(Level.ERROR, message2 + (String)exceptionInfo);
        }
    }

    public static /* synthetic */ void error$default(BootstrapLogger $this, Throwable exception, String message2, int n, Object object) {
        block8: {
            Object object2;
            block10: {
                block9: {
                    block7: {
                        if (object != null) {
                            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: error");
                        }
                        if ((n & 2) != 0) {
                            message2 = "";
                        }
                        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                        boolean $i$f$error = false;
                        if (!$this.isTinylogEnabled()) break block7;
                        if (exception == null) {
                            Logger.INSTANCE.error(message2);
                        } else {
                            Logger.INSTANCE.error(exception, message2);
                        }
                        break block8;
                    }
                    $this.getMessages().add(new LogEntry(Level.ERROR, message2, exception));
                    object2 = exception;
                    if (object2 == null) break block9;
                    Throwable it = object2;
                    boolean bl = false;
                    String string = "\n" + ExceptionsKt.stackTraceToString((Throwable)it);
                    object2 = string;
                    if (string != null) break block10;
                }
                object2 = "";
            }
            Object exceptionInfo = object2;
            $this.writeln(Level.ERROR, message2 + (String)exceptionInfo);
        }
    }

    @NotNull
    protected abstract List<Class<Writer>> getExpectedWriters();

    /*
     * WARNING - void declaration
     */
    public void startLoggingWithTinyLog(@NotNull AppFlavor appFlavor) {
        Object this_$iv;
        void $this$mapTo$iv$iv;
        BootstrapLogger $this$map$iv;
        void this_$iv2;
        Intrinsics.checkNotNullParameter((Object)((Object)appFlavor), (String)"appFlavor");
        if (!(!this.isTinylogEnabled())) {
            boolean $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$62 = false;
            String $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$62 = "Doesn't make any sense to start real logging twice";
            throw new IllegalArgumentException($i$a$-require-BootstrapLogger$startLoggingWithTinyLog$62.toString());
        }
        BootstrapLogger bootstrapLogger = this;
        String message$iv = "instance type: " + appFlavor;
        boolean $i$f$info = false;
        if (this_$iv2.isTinylogEnabled()) {
            Logger.INSTANCE.info(message$iv);
        } else {
            this_$iv2.getMessages().add(new LogEntry(Level.INFO, message$iv, null, 4, null));
            this_$iv2.writeln(Level.INFO, message$iv);
        }
        Path logFile = this.configureTinyLog(appFlavor);
        TinylogSlf4jServiceProvider tinylogSlf4jServiceProvider = new TinylogSlf4jServiceProvider();
        ToolboxSlf4jServiceProvider.Companion.initializeWithDelegate((SLF4JServiceProvider)tinylogSlf4jServiceProvider);
        ILoggerFactory slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        if (!(!(slf4jLoggerFactory instanceof NOPLoggerFactory))) {
            boolean $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$72 = false;
            String $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$72 = "Logging is misconfigured. slf4j has a no-op factory: " + slf4jLoggerFactory.getClass().getCanonicalName();
            throw new IllegalArgumentException($i$a$-require-BootstrapLogger$startLoggingWithTinyLog$72.toString());
        }
        if (!(slf4jLoggerFactory instanceof ModernTinylogLoggerFactory)) {
            boolean $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$82 = false;
            String $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$82 = "Logging is misconfigured. Unexpected slf4j logger factory. Expected '" + ModernTinylogLoggerFactory.class.getCanonicalName() + "', actual '" + slf4jLoggerFactory.getClass().getCanonicalName() + "'";
            throw new IllegalArgumentException($i$a$-require-BootstrapLogger$startLoggingWithTinyLog$82.toString());
        }
        if (!(this.getToolboxLoggingProvider() != null)) {
            boolean $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$92 = false;
            String $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$92 = "Logging is misconfigured. ToolboxLoggingProvider is not available, actual provider is " + ProviderRegistry.getLoggingProvider().getClass().getCanonicalName();
            throw new IllegalArgumentException($i$a$-require-BootstrapLogger$startLoggingWithTinyLog$92.toString());
        }
        ToolboxLoggingProvider toolboxLoggingProvider = this.getToolboxLoggingProvider();
        Intrinsics.checkNotNull((Object)toolboxLoggingProvider);
        Writer[] writerArray = toolboxLoggingProvider.getConfiguredWritersForDefaultTagAndErrorLevel(0, Level.ERROR);
        Intrinsics.checkNotNullExpressionValue((Object)writerArray, (String)"getConfiguredWritersForD\u2026aultTagAndErrorLevel(...)");
        Object[] $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$92 = writerArray;
        boolean $i$f$map = false;
        void var8_19 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Writer writer2 = (Writer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getClass());
        }
        Set actualWriters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!(actualWriters.size() == this.getExpectedWriters().size() && CollectionsKt.intersect((Iterable)actualWriters, (Iterable)CollectionsKt.toSet((Iterable)this.getExpectedWriters())).size() == this.getExpectedWriters().size())) {
            boolean $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$102 = false;
            String $i$a$-require-BootstrapLogger$startLoggingWithTinyLog$102 = "Logging is misconfigured. Expected to find exactly these writers '" + CollectionsKt.joinToString$default((Iterable)this.getExpectedWriters(), null, null, null, (int)0, null, BootstrapLogger::startLoggingWithTinyLog$lambda$12$lambda$10, (int)31, null) + "', but got '" + CollectionsKt.joinToString$default((Iterable)actualWriters, null, null, null, (int)0, null, BootstrapLogger::startLoggingWithTinyLog$lambda$12$lambda$11, (int)31, null) + "'";
            throw new IllegalArgumentException($i$a$-require-BootstrapLogger$startLoggingWithTinyLog$102.toString());
        }
        $this$map$iv = this;
        Object message$iv2 = "Logging to " + logFile;
        boolean $i$f$info2 = false;
        if (((BootstrapLogger)this_$iv).isTinylogEnabled()) {
            Logger.INSTANCE.info((String)message$iv2);
        } else {
            ((BootstrapLogger)this_$iv).getMessages().add(new LogEntry(Level.INFO, (String)message$iv2, null, 4, null));
            ((BootstrapLogger)this_$iv).writeln(Level.INFO, (String)message$iv2);
        }
        this.setTinylogEnabled(true);
        this_$iv = this;
        message$iv2 = "Logging configuration verified: slf4j logger factory is correct, tinylog logging provider is correct, expected writers are present.";
        $i$f$info2 = false;
        if (((BootstrapLogger)this_$iv).isTinylogEnabled()) {
            Logger.INSTANCE.info((String)message$iv2);
        } else {
            ((BootstrapLogger)this_$iv).getMessages().add(new LogEntry(Level.INFO, (String)message$iv2, null, 4, null));
            ((BootstrapLogger)this_$iv).writeln(Level.INFO, (String)message$iv2);
        }
        System.out.flush();
        System.err.flush();
        this.dumpApplicationInfo();
        Logger.INSTANCE.info("Dumping bootstrap log entries (" + this.messages.size() + " total): ");
        this_$iv = this.messages.iterator();
        while (this_$iv.hasNext()) {
            LogEntry entry;
            LogEntry logEntry;
            LogEntry $this$startLoggingWithTinyLog_u24lambda_u2413 = logEntry = (entry = (LogEntry)this_$iv.next());
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$startLoggingWithTinyLog_u24lambda_u2413.getLevel().ordinal()]) {
                case 1: {
                    Logger.INSTANCE.trace($this$startLoggingWithTinyLog_u24lambda_u2413.getMessage());
                    break;
                }
                case 2: {
                    Logger.INSTANCE.info($this$startLoggingWithTinyLog_u24lambda_u2413.getMessage());
                    break;
                }
                case 3: {
                    if ($this$startLoggingWithTinyLog_u24lambda_u2413.getException() == null) {
                        Logger.INSTANCE.warn($this$startLoggingWithTinyLog_u24lambda_u2413.getMessage());
                        break;
                    }
                    Logger.INSTANCE.warn($this$startLoggingWithTinyLog_u24lambda_u2413.getException(), $this$startLoggingWithTinyLog_u24lambda_u2413.getMessage());
                    break;
                }
                case 4: {
                    if ($this$startLoggingWithTinyLog_u24lambda_u2413.getException() == null) {
                        Logger.INSTANCE.error($this$startLoggingWithTinyLog_u24lambda_u2413.getMessage());
                        break;
                    }
                    Logger.INSTANCE.error($this$startLoggingWithTinyLog_u24lambda_u2413.getException(), $this$startLoggingWithTinyLog_u24lambda_u2413.getMessage());
                    break;
                }
                case 5: 
                case 6: {
                    throw new IllegalStateException(("Unsupported logging level: " + $this$startLoggingWithTinyLog_u24lambda_u2413.getLevel()).toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        try {
            this.removeExcessSecondaryLogs(logFile);
        }
        catch (Throwable e) {
            Logger.INSTANCE.warn(e, "Failed to remove excess secondary instance logs");
        }
    }

    @NotNull
    public abstract Path configureTinyLog(@NotNull AppFlavor var1);

    private final void dumpApplicationInfo() {
        String string;
        String string2;
        Logger logger;
        Logger.INSTANCE.info("===========================================================");
        Logger.INSTANCE.info(Build.INSTANCE.getApplicationFullNameVersion() + (Build.INSTANCE.isSNAPSHOT() ? "-SNAPSHOT " : "") + " built on " + InstantExtensionsKt.toISOString(Build.INSTANCE.getBuildDate()) + " is starting");
        Logger.INSTANCE.info("Git Commit: " + Build.INSTANCE.getCommitHash());
        String string3 = System.getProperty("os.name");
        Logger logger2 = Logger.INSTANCE;
        try {
            logger = logger2;
            string2 = string3;
            string = System.getProperty("java.runtime.version");
        }
        catch (Throwable throwable) {
            logger = logger2;
            string2 = string3;
            string = "";
        }
        logger.info("OS: " + string2 + ", JRE: " + string);
        Logger.INSTANCE.info("Executable: " + OS.getApplicationExecutable$default(OS.INSTANCE, null, 1, null));
        Logger.INSTANCE.info("Arguments: " + BlurTokensKt.blurTokens(this.appStartInfo.getArguments()));
        Logger.INSTANCE.info("=== Environment variables ===");
        Regex sensitiveVariableRE = new Regex("SECRET|PASSWORD|TOKEN|CREDENTIAL", RegexOption.IGNORE_CASE);
        try {
            Map<String, String> map2 = System.getenv();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getenv(...)");
            Map $this$forEach$iv = MapsKt.toSortedMap(map2);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                String name2 = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                Intrinsics.checkNotNull((Object)name2);
                if (sensitiveVariableRE.containsMatchIn((CharSequence)name2)) {
                    Logger.INSTANCE.info("[sensitive] " + name2 + " = ******");
                    continue;
                }
                Logger.INSTANCE.info(name2 + " = " + value2);
            }
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2);
        }
        Logger.INSTANCE.info("=== end of environment variables ===");
    }

    /*
     * WARNING - void declaration
     */
    private final void removeExcessSecondaryLogs(Path ourLogFile) {
        void $this$sortedByDescending$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Path path2 = ourLogFile.parent();
        if (path2 == null) {
            BootstrapLogger $this$removeExcessSecondaryLogs_u24lambda_u2415 = this;
            boolean bl = false;
            Logger.INSTANCE.warn("No parent dir for " + ourLogFile + ", can't clean secondary instance logs");
            return;
        }
        Path parent = path2;
        String[] stringArray = parent.toFile().list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = stringArray;
        boolean $i$f$mapNotNull = false;
        void bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            File file;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl2 = false;
            void it = element$iv$iv;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it, (Object)ourLogFile.name())) {
                file = null;
            } else {
                Intrinsics.checkNotNull((Object)it);
                File entry = parent.resolve((String)it).toFile();
                file = !entry.isFile() ? null : entry;
            }
            if (file == null) continue;
            File it$iv$iv = file;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List toDelete = CollectionsKt.toList((Iterable)CollectionsKt.drop((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.lastModified());
                it = (File)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.lastModified()));
            }
        }), (int)50));
        if (!((Collection)toDelete).isEmpty()) {
            Logger.INSTANCE.debug("Cleaning excess secondary instance logs from " + parent);
        }
        for (File f : toDelete) {
            try {
                if (f.delete()) {
                    Logger.INSTANCE.debug(f + ": deleted");
                    continue;
                }
                Logger.INSTANCE.debug(f + ": not deleted");
            }
            catch (Throwable e) {
                Logger.INSTANCE.warn(e, "Failed to delete: " + f);
            }
        }
    }

    private static final ToolboxLoggingProvider toolboxLoggingProvider_delegate$lambda$0() {
        LoggingProvider loggingProvider = ProviderRegistry.getLoggingProvider();
        return loggingProvider instanceof ToolboxLoggingProvider ? (ToolboxLoggingProvider)loggingProvider : null;
    }

    private static final CharSequence startLoggingWithTinyLog$lambda$12$lambda$10(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        return string;
    }

    private static final CharSequence startLoggingWithTinyLog$lambda$12$lambda$11(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        return string;
    }

    public static final class LogEntry {
        @NotNull
        private final Level level;
        @Nullable
        private final Throwable exception;
        @NotNull
        private final String message;

        public LogEntry(@NotNull Level level, @NotNull String message2, @Nullable Throwable exception) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.level = level;
            this.exception = exception;
            switch (WhenMappings.$EnumSwitchMapping$0[this.level.ordinal()]) {
                case 1: 
                case 2: {
                    if (this.exception == null) break;
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    throw new IllegalStateException(("Unsupported logging level: " + this.level).toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String dateTimePattern = "HH:mm:ss.SSS";
            String timestamp2 = LocalTime.now().format(DateTimeFormatter.ofPattern(dateTimePattern));
            String string = RuntimeProvider.getCallerClassName((String)LogEntry.class.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCallerClassName(...)");
            String callerName = StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null);
            this.message = timestamp2 + " | " + callerName + " | " + message2;
        }

        public /* synthetic */ LogEntry(Level level, String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                throwable = null;
            }
            this(level, string, throwable);
        }

        @NotNull
        public final Level getLevel() {
            return this.level;
        }

        @Nullable
        public final Throwable getException() {
            return this.exception;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Level.values().length];
                try {
                    nArray[Level.TRACE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.INFO.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.WARN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.ERROR.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.DEBUG.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.OFF.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.INFO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.WARN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.DEBUG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.OFF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

