/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.jbclient.clientLink.websocket;

import com.jetbrains.toolbox.jbclient.clientLink.JBClientConnectionHandle;
import com.jetbrains.toolbox.jbclient.clientLink.JBClientConnectionHandleManager;
import com.jetbrains.toolbox.jbclient.clientLink.websocket.ClientLinkWebsocketHandler;
import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketClientFactory;
import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketOutlet;
import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketReceiver;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class ClientLinkWebsocketClientFactory
implements WebsocketClientFactory {
    @NotNull
    private final JBClientConnectionHandleManager handleManager;
    @NotNull
    private final String path;

    public ClientLinkWebsocketClientFactory(@NotNull JBClientConnectionHandleManager handleManager) {
        Intrinsics.checkNotNullParameter((Object)handleManager, (String)"handleManager");
        this.handleManager = handleManager;
        this.path = "/gateway/clientLink";
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public WebsocketReceiver get(@NotNull URI uri, @NotNull Map<String, ? extends List<String>> queryParams, @NotNull WebsocketOutlet outlet2) {
        String uid2;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Intrinsics.checkNotNullParameter((Object)outlet2, (String)"outlet");
        Logger.INSTANCE.info("Got connection from client on uri: " + uri);
        List<String> list2 = queryParams.get("uid");
        String string = uid2 = list2 != null ? (String)CollectionsKt.firstOrNull(list2) : null;
        if (uid2 == null) {
            Logger.INSTANCE.warn("Client connected without uid.");
            return null;
        }
        JBClientConnectionHandle handle2 = this.handleManager.getConnectionHandle(uid2);
        if (handle2 == null) {
            Logger.INSTANCE.warn("Client connected with unknown uid");
            return null;
        }
        return new ClientLinkWebsocketHandler(outlet2, handle2);
    }
}

