/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.jbclient;

import com.jetbrains.toolbox.OSKt;
import com.jetbrains.toolbox.common.WithHandlerKt;
import com.jetbrains.toolbox.feed.ApplicationMajorVersion;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.DefaultConfigDirectories;
import com.jetbrains.toolbox.feed.PathWithVariables;
import com.jetbrains.toolbox.intellij.UtilKt;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolUninstallHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nJBClientDataUninstallHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBClientDataUninstallHandler.kt\ncom/jetbrains/toolbox/jbclient/JBClientDataUninstallHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 withHandler.kt\ncom/jetbrains/toolbox/common/WithHandlerKt\n*L\n1#1,54:1\n774#2:55\n865#2,2:56\n1869#2,2:58\n8#3,8:60\n*S KotlinDebug\n*F\n+ 1 JBClientDataUninstallHandler.kt\ncom/jetbrains/toolbox/jbclient/JBClientDataUninstallHandler\n*L\n36#1:55\n36#1:56,2\n38#1:58,2\n47#1:60,8\n*E\n"})
public final class JBClientDataUninstallHandler
implements ToolUninstallHandler {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final ApplicationMajorVersion clientSharesSettingsWithIdeaSinceMajorVersion;

    public JBClientDataUninstallHandler(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.clientSharesSettingsWithIdeaSinceMajorVersion = new ApplicationMajorVersion("2024.2", 20242);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object onUninstall(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super UninstallResult> $completion) {
        if (ApplicationType.equals-impl0(toolInstance.getTool().getToolId-UtVBrGo(), WellKnownApplications.INSTANCE.getJetBrainsClient-UtVBrGo())) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            ApplicationMajorVersion applicationMajorVersion = toolInstance.getTool().getMajorVersion();
            if (applicationMajorVersion != null) {
                ApplicationMajorVersion majorVersion = applicationMajorVersion;
                boolean bl = false;
                if (majorVersion.compareTo(this.clientSharesSettingsWithIdeaSinceMajorVersion) >= 0) {
                    return UninstallResult.NotSupported.INSTANCE;
                }
            }
            DefaultConfigDirectories defaultConfigDirectories = UtilKt.getCurrentDefaultConfigDirectories(toolInstance);
            if (defaultConfigDirectories == null) {
                return UninstallResult.NotSupported.INSTANCE;
            }
            DefaultConfigDirectories dirs = defaultConfigDirectories;
            Object object = new PathWithVariables[]{PathWithVariables.box-impl(dirs.getPlugins-6QkRYPI()), PathWithVariables.box-impl(dirs.getLogs-6QkRYPI()), PathWithVariables.box-impl(dirs.getConfig-6QkRYPI()), PathWithVariables.box-impl(dirs.getSystem-6QkRYPI())};
            object = CollectionsKt.listOf((Object[])object);
            boolean $i$f$filter = false;
            void bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = ((PathWithVariables)element$iv$iv).unbox-impl();
                boolean bl2 = false;
                boolean bl3 = ((CharSequence)it).length() > 0;
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = ((PathWithVariables)element$iv).unbox-impl();
                boolean bl4 = false;
                this.deleteDirectory(OSKt.getExpanded-WIZC_Bo(it));
            }
            return UninstallResult.Success.INSTANCE;
        }
        return UninstallResult.NotSupported.INSTANCE;
    }

    private final void deleteDirectory(Path path2) {
        boolean $i$f$withHandler = false;
        try {
            boolean bl = false;
            Logger.INSTANCE.debug("Deleting leftover directory " + path2);
            this.fileSystem.deleteRecursively(path2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Throwable e$iv;
            if (!(e$iv instanceof IOException) || WithHandlerKt.isFatal(e$iv)) {
                throw e$iv;
            }
            IOException e = (IOException)e$iv;
            boolean bl = false;
            Logger.INSTANCE.warn((Throwable)e, "Unable to delete " + path2);
            Unit unit = Unit.INSTANCE;
        }
    }
}

