/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.jbclient;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.gateway.ToolCounterpart;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import com.jetbrains.toolbox.tools.model.VersionWithBuilds;
import com.jetbrains.toolbox.tools.provider.AvailableToolSource;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nAvailableJBClientSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvailableJBClientSource.kt\ncom/jetbrains/toolbox/jbclient/AvailableJBClientSource\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,49:1\n230#2,5:50\n230#2,3:55\n233#2,2:68\n1740#3,3:58\n536#4:61\n521#4,6:62\n*S KotlinDebug\n*F\n+ 1 AvailableJBClientSource.kt\ncom/jetbrains/toolbox/jbclient/AvailableJBClientSource\n*L\n22#1:50,5\n28#1:55,3\n28#1:68,2\n29#1:58,3\n32#1:61\n32#1:62,6\n*E\n"})
public final class AvailableJBClientSource
implements AvailableToolSource {
    @NotNull
    private final MutableStateFlow<Map<ToolCounterpart, ToolWithVersions>> _state = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
    @NotNull
    private final StateFlow<Collection<ToolWithVersions>> state = FlowExtensionsKt.mapState((StateFlow)this._state, AvailableJBClientSource::state$lambda$0);

    @Override
    @NotNull
    public StateFlow<Collection<ToolWithVersions>> getState() {
        return this.state;
    }

    @NotNull
    public final Set<ToolCounterpart> getRegisteredCounterparts() {
        return ((Map)this._state.getValue()).keySet();
    }

    public final void addBuild(@NotNull ToolCounterpart counterpart, @NotNull ToolBuild build2) {
        Map it;
        Map nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)counterpart, (String)"counterpart");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Logger.INSTANCE.debug("Added " + counterpart);
        MutableStateFlow<Map<ToolCounterpart, ToolWithVersions>> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Map)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = MapsKt.plus((Map)it, (Pair)TuplesKt.to((Object)counterpart, (Object)this.convert(build2))))));
    }

    /*
     * WARNING - void declaration
     */
    public final void retain(@NotNull Collection<? extends ToolCounterpart> counterparts) {
        Map map2;
        Map nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(counterparts, (String)"counterparts");
        Logger.INSTANCE.debug("Retaining only " + counterparts);
        Set retained = CollectionsKt.toSet((Iterable)counterparts);
        MutableStateFlow<Map<ToolCounterpart, ToolWithVersions>> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            void $this$filterTo$iv$iv;
            boolean bl;
            Map tools2;
            block6: {
                prevValue$iv = $this$update$iv.getValue();
                tools2 = (Map)prevValue$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = tools2.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ToolCounterpart it = (ToolCounterpart)element$iv;
                        boolean bl3 = false;
                        if (retained.contains(it)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                map2 = tools2;
                continue;
            }
            Map $this$filter$iv = tools2;
            boolean $i$f$filter = false;
            Map map3 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator2.next();
                boolean bl4 = false;
                ToolCounterpart counterpart = (ToolCounterpart)entry.getKey();
                if (!retained.contains(counterpart)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            map2 = destination$iv$iv;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = map2)));
    }

    private final ToolWithVersions convert(ToolBuild $this$convert) {
        return new ToolWithVersions($this$convert.getTool(), CollectionsKt.listOf((Object)new VersionWithBuilds($this$convert.getVersion(), CollectionsKt.listOf((Object)$this$convert.getBuild()))), SetsKt.emptySet());
    }

    private static final Collection state$lambda$0(Map tools2) {
        Intrinsics.checkNotNullParameter((Object)tools2, (String)"tools");
        return tools2.values();
    }
}

