/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ipc;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.ipc.ApplicationStartLock;
import com.jetbrains.toolbox.log.BootstrapLogger;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.ExceptionsKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nWin32ApplicationStartLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Win32ApplicationStartLock.kt\ncom/jetbrains/toolbox/ipc/Win32ApplicationStartLock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BootstrapLogger.kt\ncom/jetbrains/toolbox/log/BootstrapLogger\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,115:1\n1#2:116\n1#2:134\n1#2:162\n1#2:189\n1#2:203\n79#3,7:117\n127#3,10:124\n137#3,3:135\n79#3,7:138\n79#3,7:145\n127#3,10:152\n137#3,3:163\n79#3,7:172\n112#3,10:179\n122#3,3:190\n112#3,10:193\n122#3,3:204\n434#4:166\n507#4,5:167\n*S KotlinDebug\n*F\n+ 1 Win32ApplicationStartLock.kt\ncom/jetbrains/toolbox/ipc/Win32ApplicationStartLock\n*L\n42#1:134\n56#1:162\n105#1:189\n108#1:203\n25#1:117,7\n42#1:124,10\n42#1:135,3\n48#1:138,7\n51#1:145,7\n56#1:152,10\n56#1:163,3\n102#1:172,7\n105#1:179,10\n105#1:190,3\n108#1:193,10\n108#1:204,3\n94#1:166\n94#1:167,5\n*E\n"})
public final class Win32ApplicationStartLock
extends ApplicationStartLock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BootstrapLogger bootstrapLogger;
    @Nullable
    private WinNT.HANDLE fileMapping;
    private static final int PAGE_READWRITE = 4;

    public Win32ApplicationStartLock(@NotNull BootstrapLogger bootstrapLogger) {
        Intrinsics.checkNotNullParameter((Object)bootstrapLogger, (String)"bootstrapLogger");
        this.bootstrapLogger = bootstrapLogger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean tryAcquireMainInstance() {
        if (!OS.INSTANCE.isWindows()) {
            boolean $i$a$-require-Win32ApplicationStartLock$tryAcquireMainInstance$22 = false;
            String $i$a$-require-Win32ApplicationStartLock$tryAcquireMainInstance$22 = "This is a Windows-specific implementation";
            throw new IllegalArgumentException($i$a$-require-Win32ApplicationStartLock$tryAcquireMainInstance$22.toString());
        }
        try {
            boolean mappingAlreadyExists;
            BootstrapLogger this_$iv;
            void this_$iv2;
            String uniqueKey = this.makeSingleApplicationKey();
            String mappingName = this.makeFileName(uniqueKey, "qipc_sharedmemory_");
            BootstrapLogger bootstrapLogger = this.bootstrapLogger;
            Object message$iv = "Trying to acquire file mapping: " + mappingName;
            boolean $i$f$info2 = false;
            if (this_$iv2.isTinylogEnabled()) {
                Logger.INSTANCE.info((String)message$iv);
            } else {
                this_$iv2.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, (String)message$iv, null, 4, null));
                this_$iv2.writeln(Level.INFO, (String)message$iv);
            }
            this.fileMapping = Kernel32.INSTANCE.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, null, 4, 0, 65535, mappingName + "\u0000");
            if (this.fileMapping == null) {
                int error2 = Kernel32.INSTANCE.GetLastError();
                message$iv = this.bootstrapLogger;
                Object $i$f$info2 = null;
                String message$iv2 = "Failed to access file mapping: " + error2;
                boolean $i$f$error = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.error(message$iv2);
                } else {
                    void exception$iv;
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.ERROR, message$iv2, (Throwable)exception$iv));
                    String exceptionInfo$iv = "";
                    this_$iv.writeln(Level.ERROR, message$iv2 + exceptionInfo$iv);
                }
                return false;
            }
            boolean bl = mappingAlreadyExists = Kernel32.INSTANCE.GetLastError() == 183;
            if (mappingAlreadyExists) {
                this_$iv = this.bootstrapLogger;
                String message$iv3 = "instance type: SECONDARY";
                boolean $i$f$info3 = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.info(message$iv3);
                } else {
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv3, null, 4, null));
                    this_$iv.writeln(Level.INFO, message$iv3);
                }
                this.safeCloseHandle();
            } else {
                this_$iv = this.bootstrapLogger;
                String message$iv4 = "instance type: MAIN";
                boolean $i$f$info4 = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.info(message$iv4);
                } else {
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv4, null, 4, null));
                    this_$iv.writeln(Level.INFO, message$iv4);
                }
            }
            return !mappingAlreadyExists;
        }
        catch (Throwable e) {
            block20: {
                Object object;
                void this_$iv;
                String message$iv;
                block22: {
                    block21: {
                        void exception$iv;
                        block19: {
                            BootstrapLogger mappingAlreadyExists = this.bootstrapLogger;
                            Throwable this_$iv3 = e;
                            message$iv = "Unexpected error while checking the file mapping";
                            boolean $i$f$error = false;
                            if (!this_$iv.isTinylogEnabled()) break block19;
                            if (exception$iv == null) {
                                Logger.INSTANCE.error(message$iv);
                            } else {
                                Logger.INSTANCE.error((Throwable)exception$iv, message$iv);
                            }
                            break block20;
                        }
                        this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.ERROR, message$iv, (Throwable)exception$iv));
                        object = exception$iv;
                        if (object == null) break block21;
                        void it$iv = object;
                        boolean bl = false;
                        String string = "\n" + ExceptionsKt.stackTraceToString((Throwable)it$iv);
                        object = string;
                        if (string != null) break block22;
                    }
                    object = "";
                }
                String exceptionInfo$iv = object;
                this_$iv.writeln(Level.ERROR, message$iv + exceptionInfo$iv);
            }
            this.safeCloseHandle();
            throw e;
        }
    }

    @Override
    protected void releaseMainInstance() {
        this.safeCloseHandle();
    }

    @NotNull
    public final String makeSingleApplicationKey() {
        String homeStr;
        String uuid;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String string = uuid = "6CB3F228-C947-4507-AB81-7E65EFA92B87";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        digest.update(byArray);
        String string2 = System.getenv("USERPROFILE");
        if (string2 == null) {
            throw new IllegalStateException("USERPROFILE environment variable is not set".toString());
        }
        String home = string2;
        String string3 = homeStr = StringsKt.replace$default((String)home, (String)"\\", (String)"/", (boolean)false, (int)4, null);
        byte[] byArray2 = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        digest.update(byArray2);
        byte[] hashBytes = digest.digest();
        Intrinsics.checkNotNull((Object)hashBytes);
        return ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, Win32ApplicationStartLock::makeSingleApplicationKey$lambda$1, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String makeFileName(@NotNull String key2, @NotNull String prefix) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (((CharSequence)key2).length() == 0) {
            return "";
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        String string = key2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hashBytes = digest.digest(byArray);
        Intrinsics.checkNotNull((Object)hashBytes);
        String hex = ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, Win32ApplicationStartLock::makeFileName$lambda$2, (int)30, null);
        String $this$filter$iv = key2;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isLetter(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String keyWithoutNonLetters = ((StringBuilder)destination$iv$iv).toString();
        return prefix + keyWithoutNonLetters + hex;
    }

    /*
     * WARNING - void declaration
     */
    private final void safeCloseHandle() {
        block13: {
            WinNT.HANDLE hANDLE = this.fileMapping;
            if (hANDLE == null) break block13;
            WinNT.HANDLE handle2 = hANDLE;
            boolean bl = false;
            try {
                void exception$iv;
                void this_$iv;
                if (Kernel32.INSTANCE.CloseHandle(handle2)) {
                    void this_$iv2;
                    BootstrapLogger bootstrapLogger = this.bootstrapLogger;
                    String message$iv = "Successfully closed file mapping handle";
                    boolean $i$f$info = false;
                    if (this_$iv2.isTinylogEnabled()) {
                        Logger.INSTANCE.info(message$iv);
                    } else {
                        this_$iv2.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                        this_$iv2.writeln(Level.INFO, message$iv);
                    }
                    break block13;
                }
                int error2 = Kernel32.INSTANCE.GetLastError();
                BootstrapLogger message$iv = this.bootstrapLogger;
                Object $i$f$info = null;
                String message$iv2 = "Failed to close handle: " + error2;
                boolean $i$f$warn = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.warn(message$iv2);
                    break block13;
                }
                this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, message$iv2, (Throwable)exception$iv));
                String exceptionInfo$iv = "";
                this_$iv.writeln(Level.WARN, message$iv2 + exceptionInfo$iv);
            }
            catch (Exception e) {
                Object object;
                String message$iv;
                BootstrapLogger this_$iv;
                block15: {
                    block14: {
                        this_$iv = this.bootstrapLogger;
                        Throwable exception$iv = e;
                        message$iv = "Error while closing handle";
                        boolean $i$f$warn = false;
                        if (this_$iv.isTinylogEnabled()) {
                            if (exception$iv == null) {
                                Logger.INSTANCE.warn(message$iv);
                            } else {
                                Logger.INSTANCE.warn(exception$iv, message$iv);
                            }
                            break block13;
                        }
                        this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, message$iv, exception$iv));
                        object = exception$iv;
                        if (object == null) break block14;
                        Throwable it$iv = object;
                        boolean bl2 = false;
                        String string = "\n" + it$iv;
                        object = string;
                        if (string != null) break block15;
                    }
                    object = "";
                }
                Object exceptionInfo$iv = object;
                this_$iv.writeln(Level.WARN, message$iv + (String)exceptionInfo$iv);
            }
        }
        this.fileMapping = null;
    }

    private static final CharSequence makeSingleApplicationKey$lambda$1(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final CharSequence makeFileName$lambda$2(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

