/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ipc;

import com.jetbrains.toolbox.AppFlavor;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.ipc.ApplicationStartLock;
import com.jetbrains.toolbox.ipc.Semaphore;
import com.jetbrains.toolbox.log.BootstrapLogger;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.tinylog.Level;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nUnixApplicationStartLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnixApplicationStartLock.kt\ncom/jetbrains/toolbox/ipc/UnixApplicationStartLock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BootstrapLogger.kt\ncom/jetbrains/toolbox/log/BootstrapLogger\n*L\n1#1,50:1\n1#2:51\n1#2:62\n1#2:90\n127#3,10:52\n137#3,3:63\n79#3,7:66\n79#3,7:73\n127#3,10:80\n137#3,3:91\n*S KotlinDebug\n*F\n+ 1 UnixApplicationStartLock.kt\ncom/jetbrains/toolbox/ipc/UnixApplicationStartLock\n*L\n24#1:62\n39#1:90\n24#1:52,10\n24#1:63,3\n32#1:66,7\n34#1:73,7\n39#1:80,10\n39#1:91,3\n*E\n"})
public final class UnixApplicationStartLock
extends ApplicationStartLock {
    @NotNull
    private final BootstrapLogger bootstrapLogger;
    @NotNull
    private Function0<Unit> releaseHandler;

    public UnixApplicationStartLock(@NotNull BootstrapLogger bootstrapLogger) {
        Intrinsics.checkNotNullParameter((Object)bootstrapLogger, (String)"bootstrapLogger");
        this.bootstrapLogger = bootstrapLogger;
        this.releaseHandler = UnixApplicationStartLock::releaseHandler$lambda$0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean tryAcquireMainInstance() {
        if (!OS.INSTANCE.isUnix()) {
            boolean $i$a$-require-UnixApplicationStartLock$tryAcquireMainInstance$22 = false;
            String $i$a$-require-UnixApplicationStartLock$tryAcquireMainInstance$22 = "This is a Unix-specific implementation";
            throw new IllegalArgumentException($i$a$-require-UnixApplicationStartLock$tryAcquireMainInstance$22.toString());
        }
        try {
            Semaphore primaryLock = new Semaphore(this.bootstrapLogger, 205, 1);
            try {
                primaryLock.createOrAttach();
            }
            catch (Throwable e) {
                block22: {
                    Object object;
                    void this_$iv;
                    String message$iv;
                    block24: {
                        block23: {
                            void exception$iv;
                            block21: {
                                BootstrapLogger bootstrapLogger = this.bootstrapLogger;
                                Throwable throwable = e;
                                message$iv = "Failed to initialize Toolbox application";
                                boolean $i$f$error = false;
                                if (!this_$iv.isTinylogEnabled()) break block21;
                                if (exception$iv == null) {
                                    Logger.INSTANCE.error(message$iv);
                                } else {
                                    Logger.INSTANCE.error((Throwable)exception$iv, message$iv);
                                }
                                break block22;
                            }
                            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.ERROR, message$iv, (Throwable)exception$iv));
                            object = exception$iv;
                            if (object == null) break block23;
                            void it$iv = object;
                            boolean bl = false;
                            String string = "\n" + ExceptionsKt.stackTraceToString((Throwable)it$iv);
                            object = string;
                            if (string != null) break block24;
                        }
                        object = "";
                    }
                    String exceptionInfo$iv = object;
                    this_$iv.writeln(Level.ERROR, message$iv + exceptionInfo$iv);
                }
                this.bootstrapLogger.startLoggingWithTinyLog(AppFlavor.SecondaryInstance);
                System.exit(43);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            boolean isMainInstance = primaryLock.tryAcquire();
            if (isMainInstance) {
                this.releaseHandler = () -> UnixApplicationStartLock.tryAcquireMainInstance$lambda$2(primaryLock);
                BootstrapLogger this_$iv = this.bootstrapLogger;
                String message$iv = "Running as main instance";
                boolean $i$f$info = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.info(message$iv);
                } else {
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                    this_$iv.writeln(Level.INFO, message$iv);
                }
            } else {
                BootstrapLogger this_$iv = this.bootstrapLogger;
                String message$iv2 = "Running as secondary instance";
                boolean $i$f$info = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.info(message$iv2);
                } else {
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv2, null, 4, null));
                    this_$iv.writeln(Level.INFO, message$iv2);
                }
            }
            return isMainInstance;
        }
        catch (Throwable e) {
            block26: {
                Object object;
                String message$iv;
                BootstrapLogger this_$iv;
                block28: {
                    block27: {
                        void exception$iv;
                        block25: {
                            this_$iv = this.bootstrapLogger;
                            Throwable message$iv2 = e;
                            message$iv = "Failed to determine if this is the main instance";
                            boolean $i$f$error = false;
                            if (!this_$iv.isTinylogEnabled()) break block25;
                            if (exception$iv == null) {
                                Logger.INSTANCE.error(message$iv);
                            } else {
                                Logger.INSTANCE.error((Throwable)exception$iv, message$iv);
                            }
                            break block26;
                        }
                        this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.ERROR, message$iv, (Throwable)exception$iv));
                        object = exception$iv;
                        if (object == null) break block27;
                        void it$iv = object;
                        boolean bl = false;
                        String string = "\n" + ExceptionsKt.stackTraceToString((Throwable)it$iv);
                        object = string;
                        if (string != null) break block28;
                    }
                    object = "";
                }
                String exceptionInfo$iv = object;
                this_$iv.writeln(Level.ERROR, message$iv + exceptionInfo$iv);
            }
            this.bootstrapLogger.startLoggingWithTinyLog(AppFlavor.SecondaryInstance);
            System.exit(44);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    @Override
    protected void releaseMainInstance() {
        this.releaseHandler.invoke();
    }

    private static final Unit releaseHandler$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit tryAcquireMainInstance$lambda$2(Semaphore $primaryLock) {
        $primaryLock.release();
        return Unit.INSTANCE;
    }
}

