/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ipc;

import com.jetbrains.toolbox.ipc.SemaphoreError;
import com.jetbrains.toolbox.ipc.XSISemaphore;
import com.jetbrains.toolbox.ipc.XSISemaphoreSysCalls;
import com.jetbrains.toolbox.log.BootstrapLogger;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.tinylog.Level;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nSemaphore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Semaphore.kt\ncom/jetbrains/toolbox/ipc/Semaphore\n+ 2 BootstrapLogger.kt\ncom/jetbrains/toolbox/log/BootstrapLogger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n79#2,7:273\n112#2,10:280\n122#2,3:291\n79#2,7:294\n79#2,7:301\n79#2,7:308\n112#2,10:315\n122#2,3:326\n79#2,7:329\n112#2,10:336\n122#2,3:347\n79#2,7:350\n79#2,7:357\n79#2,7:364\n79#2,7:371\n1#3:290\n1#3:325\n1#3:346\n1#3:378\n*S KotlinDebug\n*F\n+ 1 Semaphore.kt\ncom/jetbrains/toolbox/ipc/Semaphore\n*L\n62#1:273,7\n128#1:280,10\n128#1:291,3\n143#1:294,7\n155#1:301,7\n178#1:308,7\n185#1:315,10\n185#1:326,3\n192#1:329,7\n200#1:336,10\n200#1:347,3\n207#1:350,7\n233#1:357,7\n238#1:364,7\n244#1:371,7\n128#1:290\n185#1:325\n200#1:346\n*E\n"})
public final class Semaphore {
    @NotNull
    private final BootstrapLogger bootstrapLogger;
    private final int initialValue;
    @NotNull
    private final XSISemaphoreSysCalls libc;
    private final int key;
    @NotNull
    private XSISemaphore semaphore;

    /*
     * WARNING - void declaration
     */
    public Semaphore(@NotNull BootstrapLogger bootstrapLogger, int keySeed, int initialValue) {
        void $this$key_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)bootstrapLogger, (String)"bootstrapLogger");
        this.bootstrapLogger = bootstrapLogger;
        this.initialValue = initialValue;
        this.libc = XSISemaphoreSysCalls.Companion.getINSTANCE();
        Semaphore semaphore = this;
        Semaphore semaphore2 = this;
        boolean bl = false;
        String homeDir = System.getenv("HOME");
        int n = homeDir != null ? $this$key_u24lambda_u240.libc.ftok(homeDir + "\u0000", keySeed) : keySeed * keySeed * keySeed;
        semaphore2.key = n;
        this.semaphore = new XSISemaphore(-1);
    }

    /*
     * WARNING - void declaration
     */
    public final void createOrAttach() {
        void this_$iv;
        SemaphoreError[] semaphoreErrorArray;
        boolean isCreated = false;
        int semid = 0;
        do {
            if ((semid = this.libc.semget(this.key, 1, 1920)) != -1) {
                isCreated = true;
                break;
            }
            semaphoreErrorArray = new SemaphoreError[]{SemaphoreError.EEXIST};
            this.requireLastError(semaphoreErrorArray);
            semid = this.libc.semget(this.key, 1, 384);
            if (semid != -1) continue;
            semaphoreErrorArray = new SemaphoreError[]{SemaphoreError.ENOENT};
            this.requireLastError(semaphoreErrorArray);
        } while (semid == -1);
        this.semaphore = new XSISemaphore(semid);
        if (isCreated) {
            void this_$iv2;
            semaphoreErrorArray = this.bootstrapLogger;
            String message$iv = "Created the semaphore with the key " + this.key + ", will reset & initialize it: " + this.semaphore;
            boolean $i$f$info = false;
            if (this_$iv2.isTinylogEnabled()) {
                Logger.INSTANCE.info(message$iv);
            } else {
                this_$iv2.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                this_$iv2.writeln(Level.INFO, message$iv);
            }
            this.reset();
            this.initialize();
            return;
        }
        block6: for (int i2 = 0; i2 < 10; ++i2) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getInitializationState().ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    this.createOrAttach();
                    return;
                }
                case 3: {
                    Thread.sleep(500L);
                    continue block6;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        BootstrapLogger i2 = this.bootstrapLogger;
        Object message$iv = null;
        String message$iv2 = "Semaphore " + this.semaphore + " didn't initialize in 5000 ms. Will try to reset & initialize it ourselves.";
        boolean $i$f$warn = false;
        if (this_$iv.isTinylogEnabled()) {
            Logger.INSTANCE.warn(message$iv2);
        } else {
            void exception$iv;
            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, message$iv2, (Throwable)exception$iv));
            String exceptionInfo$iv = "";
            this_$iv.writeln(Level.WARN, message$iv2 + exceptionInfo$iv);
        }
        this.reset();
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryAcquire() {
        boolean success;
        if (!(this.getInitializationState() == SemaphoreInitializationState.SEMAPHORE_INITIALIZED)) {
            boolean $i$a$-require-Semaphore$tryAcquire$42 = false;
            String $i$a$-require-Semaphore$tryAcquire$42 = "Semaphore " + this.semaphore + " is expected to be initialized, cannot try acquiring it otherwise";
            throw new IllegalArgumentException($i$a$-require-Semaphore$tryAcquire$42.toString());
        }
        boolean bl = success = this.semaphore.take() != -1;
        if (success) {
            void this_$iv;
            BootstrapLogger $i$a$-require-Semaphore$tryAcquire$42 = this.bootstrapLogger;
            String message$iv = "Acquired semaphore " + this.semaphore + ", will be a main instance";
            boolean $i$f$info = false;
            if (this_$iv.isTinylogEnabled()) {
                Logger.INSTANCE.info(message$iv);
            } else {
                this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                this_$iv.writeln(Level.INFO, message$iv);
            }
            SemaphoreInitializationState state2 = this.getInitializationState();
            if (!(state2 == SemaphoreInitializationState.SEMAPHORE_INITIALIZED)) {
                boolean $i$a$-require-Semaphore$tryAcquire$52 = false;
                String $i$a$-require-Semaphore$tryAcquire$52 = "Semaphore " + this.semaphore + " was acquired, but initialization state is " + state2 + " instead of " + SemaphoreInitializationState.SEMAPHORE_INITIALIZED;
                throw new IllegalArgumentException($i$a$-require-Semaphore$tryAcquire$52.toString());
            }
            int value2 = this.semaphore.getValue();
            if (!(value2 == 0)) {
                boolean bl2 = false;
                String string = "Semaphore " + this.semaphore + " was acquired, but the value is " + value2 + " instead of 0";
                throw new IllegalArgumentException(string.toString());
            }
        } else {
            void this_$iv;
            Object state2 = new SemaphoreError[]{SemaphoreError.EAGAIN};
            this.requireLastError((SemaphoreError)((Object)state2));
            state2 = this.bootstrapLogger;
            String message$iv = this.semaphore + " is already held by someone else, will be a secondary instance";
            boolean $i$f$info = false;
            if (this_$iv.isTinylogEnabled()) {
                Logger.INSTANCE.info(message$iv);
            } else {
                this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                this_$iv.writeln(Level.INFO, message$iv);
            }
        }
        return success;
    }

    /*
     * WARNING - void declaration
     */
    public final void release() {
        void this_$iv;
        if (!(this.getInitializationState() == SemaphoreInitializationState.SEMAPHORE_INITIALIZED)) {
            boolean $i$a$-require-Semaphore$release$32 = false;
            String $i$a$-require-Semaphore$release$32 = "Semaphore " + this.semaphore + " is expected to be initialized, cannot release it";
            throw new IllegalArgumentException($i$a$-require-Semaphore$release$32.toString());
        }
        int value2 = this.semaphore.getValue();
        if (!(value2 == 0)) {
            boolean $i$a$-require-Semaphore$release$42 = false;
            String $i$a$-require-Semaphore$release$42 = "Semaphore " + this.semaphore + " is expected to be held. Current value is " + value2 + ", cannot release it";
            throw new IllegalArgumentException($i$a$-require-Semaphore$release$42.toString());
        }
        this.reset();
        BootstrapLogger $i$a$-require-Semaphore$release$32 = this.bootstrapLogger;
        String message$iv = "Released semaphore " + this.semaphore;
        boolean $i$f$info = false;
        if (this_$iv.isTinylogEnabled()) {
            Logger.INSTANCE.info(message$iv);
        } else {
            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
            this_$iv.writeln(Level.INFO, message$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SemaphoreInitializationState getInitializationState() {
        void this_$iv;
        NativeLong otime = this.semaphore.getOtime();
        if (otime == null) {
            void this_$iv2;
            Object object = new SemaphoreError[]{SemaphoreError.EIDRM, SemaphoreError.EINVAL};
            SemaphoreError err = this.requireLastError((SemaphoreError)((Object)object));
            object = this.bootstrapLogger;
            Object var4_9 = null;
            String message$iv = "Semaphore " + this.semaphore + " doesn't exist anymore: Error code " + err;
            boolean $i$f$warn = false;
            if (this_$iv2.isTinylogEnabled()) {
                Logger.INSTANCE.warn(message$iv);
            } else {
                void exception$iv;
                this_$iv2.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, message$iv, (Throwable)exception$iv));
                String exceptionInfo$iv = "";
                this_$iv2.writeln(Level.WARN, message$iv + exceptionInfo$iv);
            }
            return SemaphoreInitializationState.SEMAPHORE_REMOVED;
        }
        if (otime.longValue() == 0L) {
            void this_$iv3;
            BootstrapLogger err = this.bootstrapLogger;
            String message$iv = "Semaphore " + this.semaphore + " is not initialized yet";
            boolean $i$f$info = false;
            if (this_$iv3.isTinylogEnabled()) {
                Logger.INSTANCE.info(message$iv);
            } else {
                this_$iv3.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                this_$iv3.writeln(Level.INFO, message$iv);
            }
            return SemaphoreInitializationState.SEMAPHORE_NOT_INITIALIZED;
        }
        int currentValue = this.semaphore.getValue();
        if (currentValue == -1) {
            void this_$iv4;
            int err = Native.getLastError();
            BootstrapLogger $i$f$info = this.bootstrapLogger;
            Object message$iv = null;
            String message$iv2 = "Failed to get semaphore value but it was marked as initialized earlier: " + err;
            boolean $i$f$warn = false;
            if (this_$iv4.isTinylogEnabled()) {
                Logger.INSTANCE.warn(message$iv2);
            } else {
                void exception$iv;
                this_$iv4.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, message$iv2, (Throwable)exception$iv));
                String exceptionInfo$iv = "";
                this_$iv4.writeln(Level.WARN, message$iv2 + exceptionInfo$iv);
            }
            return SemaphoreInitializationState.SEMAPHORE_NOT_INITIALIZED;
        }
        if (!(0 <= currentValue ? currentValue <= this.initialValue : false)) {
            boolean $i$a$-require-Semaphore$getInitializationState$22 = false;
            String $i$a$-require-Semaphore$getInitializationState$22 = "Current value of the semaphore is out of bounds of the allowed range: " + currentValue + " (expected 0.." + this.initialValue + ")";
            throw new IllegalArgumentException($i$a$-require-Semaphore$getInitializationState$22.toString());
        }
        BootstrapLogger err = this.bootstrapLogger;
        String message$iv = "Semaphore " + this.semaphore + " is initialized (non-zero otime) and the value is available; last seen value was " + currentValue;
        boolean $i$f$info = false;
        if (this_$iv.isTinylogEnabled()) {
            Logger.INSTANCE.info(message$iv);
        } else {
            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
            this_$iv.writeln(Level.INFO, message$iv);
        }
        return SemaphoreInitializationState.SEMAPHORE_INITIALIZED;
    }

    private final int getValue() {
        Ref.IntRef currentValue = new Ref.IntRef();
        currentValue.element = -1;
        this.requireSuccess("getValue", (Function0<Boolean>)((Function0)() -> Semaphore.getValue$lambda$7(currentValue, this)));
        return currentValue.element;
    }

    /*
     * WARNING - void declaration
     */
    private final void reset() {
        void this_$iv;
        this.requireSuccess("setValue", (Function0<Boolean>)((Function0)() -> Semaphore.reset$lambda$8(this)));
        BootstrapLogger bootstrapLogger = this.bootstrapLogger;
        String message$iv = "Reset semaphore " + this.semaphore + " to " + this.initialValue;
        boolean $i$f$info = false;
        if (this_$iv.isTinylogEnabled()) {
            Logger.INSTANCE.info(message$iv);
        } else {
            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
            this_$iv.writeln(Level.INFO, message$iv);
        }
    }

    private final void initialize() {
        BootstrapLogger this_$iv;
        BootstrapLogger bootstrapLogger = this.bootstrapLogger;
        String message$iv = "Initializing semaphore " + this.semaphore;
        boolean $i$f$info = false;
        if (this_$iv.isTinylogEnabled()) {
            Logger.INSTANCE.info(message$iv);
        } else {
            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
            this_$iv.writeln(Level.INFO, message$iv);
        }
        this.requireSuccess("noopWithOtimeChange", (Function0<Boolean>)((Function0)() -> Semaphore.initialize$lambda$9(this)));
        this_$iv = this.bootstrapLogger;
        message$iv = "Initialized semaphore (sem_otime is set) for " + this.semaphore;
        $i$f$info = false;
        if (this_$iv.isTinylogEnabled()) {
            Logger.INSTANCE.info(message$iv);
        } else {
            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
            this_$iv.writeln(Level.INFO, message$iv);
        }
    }

    private final SemaphoreError requireLastError(SemaphoreError ... errors) {
        Object v0;
        int nativeError;
        block3: {
            nativeError = Native.getLastError();
            Iterable iterable = (Iterable)SemaphoreError.getEntries();
            for (Object t2 : iterable) {
                SemaphoreError it = (SemaphoreError)((Object)t2);
                boolean bl = false;
                if (!(it.getCode() == nativeError)) continue;
                v0 = t2;
                break block3;
            }
            v0 = null;
        }
        SemaphoreError error2 = v0;
        if (!(error2 != null && ArraysKt.contains((Object[])errors, (Object)((Object)error2)))) {
            boolean bl = false;
            Object object = error2;
            if (object == null || (object = object.toString()) == null) {
                object = nativeError;
            }
            String string = "Unexpected error code after a syscall: " + (Object)object + ", expected errors are: " + ArraysKt.joinToString$default((Object[])errors, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalArgumentException(string.toString());
        }
        return error2;
    }

    private final void requireSuccess(String msg, Function0<Boolean> syscall) {
        block2: {
            Object object;
            int err;
            block4: {
                block3: {
                    boolean success = (Boolean)syscall.invoke();
                    if (success) break block2;
                    boolean bl = false;
                    err = Native.getLastError();
                    object = msg;
                    if (object == null) break block3;
                    String it = object;
                    boolean bl2 = false;
                    String string = " (" + it + ")";
                    object = string;
                    if (string != null) break block4;
                }
                object = "";
            }
            String string = "Unexpected error after a syscall" + (String)object + ": " + err;
            throw new IllegalArgumentException(string.toString());
        }
    }

    static /* synthetic */ void requireSuccess$default(Semaphore semaphore, String string, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        semaphore.requireSuccess(string, (Function0<Boolean>)function0);
    }

    private static final boolean getValue$lambda$7(Ref.IntRef $currentValue, Semaphore this$0) {
        $currentValue.element = this$0.semaphore.getValue();
        return $currentValue.element != -1;
    }

    private static final boolean reset$lambda$8(Semaphore this$0) {
        return this$0.semaphore.setValue(this$0.initialValue) != -1;
    }

    private static final boolean initialize$lambda$9(Semaphore this$0) {
        return this$0.semaphore.noopWithOtimeChange() != -1;
    }

    private static final class SemaphoreInitializationState
    extends Enum<SemaphoreInitializationState> {
        public static final /* enum */ SemaphoreInitializationState SEMAPHORE_NOT_INITIALIZED = new SemaphoreInitializationState();
        public static final /* enum */ SemaphoreInitializationState SEMAPHORE_INITIALIZED = new SemaphoreInitializationState();
        public static final /* enum */ SemaphoreInitializationState SEMAPHORE_REMOVED = new SemaphoreInitializationState();
        private static final /* synthetic */ SemaphoreInitializationState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SemaphoreInitializationState[] values() {
            return (SemaphoreInitializationState[])$VALUES.clone();
        }

        public static SemaphoreInitializationState valueOf(String value2) {
            return Enum.valueOf(SemaphoreInitializationState.class, value2);
        }

        @NotNull
        public static EnumEntries<SemaphoreInitializationState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = semaphoreInitializationStateArray = new SemaphoreInitializationState[]{SemaphoreInitializationState.SEMAPHORE_NOT_INITIALIZED, SemaphoreInitializationState.SEMAPHORE_INITIALIZED, SemaphoreInitializationState.SEMAPHORE_REMOVED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SemaphoreInitializationState.values().length];
            try {
                nArray[SemaphoreInitializationState.SEMAPHORE_INITIALIZED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SemaphoreInitializationState.SEMAPHORE_REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SemaphoreInitializationState.SEMAPHORE_NOT_INITIALIZED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

