/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.io;

import com.jetbrains.toolbox.common.io.FileSystemWatcher;
import java.nio.file.FileSystems;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nFileWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileWatcher.kt\ncom/jetbrains/toolbox/io/FileWatcher\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,70:1\n504#2,7:71\n*S KotlinDebug\n*F\n+ 1 FileWatcher.kt\ncom/jetbrains/toolbox/io/FileWatcher\n*L\n61#1:71,7\n*E\n"})
public final class FileWatcher {
    @NotNull
    private final MutableSharedFlow<FileSystemWatcher.Event> _events = SharedFlowKt.MutableSharedFlow$default((int)0, (int)16, null, (int)4, null);
    @NotNull
    private final SharedFlow<FileSystemWatcher.Event> events = FlowKt.asSharedFlow(this._events);
    @NotNull
    private final Map<WatchKey, Path> watchRoots = new LinkedHashMap();
    private final WatchService watchService = FileSystems.getDefault().newWatchService();

    public FileWatcher() {
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, null, (int)0, () -> FileWatcher._init_$lambda$0(this), (int)28, null);
    }

    @NotNull
    public final SharedFlow<FileSystemWatcher.Event> getEvents() {
        return this.events;
    }

    public final boolean addWatchRoot(@NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        try {
            WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
            WatchKey watchKey = root.toNioPath().register(this.watchService, kindArray);
            this.watchRoots.put(watchKey, root);
            return true;
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error("Failed to register watch root '" + root + "'");
            return false;
        }
    }

    public final void removeWatchRoot(@NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Map<WatchKey, Path> $this$filterValues$iv = this.watchRoots;
        boolean $i$f$filterValues = false;
        LinkedHashMap<WatchKey, Path> result$iv = new LinkedHashMap<WatchKey, Path>();
        for (Map.Entry<WatchKey, Path> entry$iv : $this$filterValues$iv.entrySet()) {
            Path it = entry$iv.getValue();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)root)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        for (WatchKey watchKey : ((Map)result$iv).keySet()) {
            try {
                watchKey.cancel();
            }
            catch (Throwable t2) {
                Logger.INSTANCE.error("Failed to unregister watch root '" + root + "'");
            }
        }
    }

    private static final Unit _init_$lambda$0(FileWatcher this$0) {
        while (true) {
            try {
                WatchKey watchKey = this$0.watchService.take();
                if (this$0.watchRoots.get(watchKey) == null) continue;
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    Path basePath;
                    java.nio.file.Path context2;
                    Object object = event.context();
                    if ((object instanceof java.nio.file.Path ? (java.nio.file.Path)object : null) == null) continue;
                    context2 = context2;
                    object = event.kind();
                    FileSystemWatcher.EventType op = Intrinsics.areEqual(object, StandardWatchEventKinds.ENTRY_CREATE) ? FileSystemWatcher.EventType.CREATE : (Intrinsics.areEqual(object, StandardWatchEventKinds.ENTRY_MODIFY) ? FileSystemWatcher.EventType.CHANGE : (Intrinsics.areEqual(object, StandardWatchEventKinds.ENTRY_DELETE) ? FileSystemWatcher.EventType.DELETE : FileSystemWatcher.EventType.DIRTY));
                    this$0._events.tryEmit((Object)new FileSystemWatcher.Event(op, basePath.resolve(((Object)context2.getFileName()).toString())));
                }
                watchKey.reset();
                continue;
            }
            catch (InterruptedException e) {
                Logger.INSTANCE.warn("Stopping file system watcher");
                continue;
            }
            break;
        }
    }
}

