/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop.processes;

import com.jetbrains.toolbox.ErrorsHelperKt;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.interop.ProcessOutputHandler;
import com.jetbrains.toolbox.interop.processes.ProcessRunnerEnvironment;
import com.jetbrains.toolbox.interop.processes.ProcessesRunnerUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nProcessesRunnerBlocking.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessesRunnerBlocking.kt\ncom/jetbrains/toolbox/interop/processes/ProcessesRunnerBlocking\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n37#2:153\n36#2,3:154\n1869#3,2:157\n1869#3,2:159\n*S KotlinDebug\n*F\n+ 1 ProcessesRunnerBlocking.kt\ncom/jetbrains/toolbox/interop/processes/ProcessesRunnerBlocking\n*L\n85#1:153\n85#1:154,3\n137#1:157,2\n141#1:159,2\n*E\n"})
public final class ProcessesRunnerBlocking {
    @NotNull
    public static final ProcessesRunnerBlocking INSTANCE = new ProcessesRunnerBlocking();
    @NotNull
    private static final AtomicLong processCounter = new AtomicLong(42L);

    private ProcessesRunnerBlocking() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeProcessWithInputAndWait-HOFDmpg(@NotNull File path2, @NotNull List<String> arguments, @Nullable File workingDir, @NotNull byte[] input, @NotNull Map<String, String> additionalEnvironment, long timeout2, @NotNull ProcessOutputHandler onOutput, @NotNull ProcessOutputHandler onError) {
        int n;
        Thread thread2;
        Thread outputThread2;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(additionalEnvironment, (String)"additionalEnvironment");
        Intrinsics.checkNotNullParameter((Object)onOutput, (String)"onOutput");
        Intrinsics.checkNotNullParameter((Object)onError, (String)"onError");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        Logger.INSTANCE.info("Executing " + path2 + " args: " + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null));
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ProcessRunnerEnvironment.INSTANCE.prepareUserEnvironment(builder, com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType(), additionalEnvironment);
        File file = workingDir;
        if (file != null) {
            File it = file;
            boolean bl = false;
            builder.directory(it);
        }
        ProcessesRunnerUtil.INSTANCE.setUpIORedirection(builder, onOutput, onError);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)path2.getPath());
        Object $this$toTypedArray$iv = arguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        builder.command((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        try {
            $this$toTypedArray$iv = builder.start();
        }
        catch (Throwable t2) {
            Logger.INSTANCE.debug(t2, "Process " + path2 + " (args: " + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ") failed to start. " + t2.getMessage());
            ErrorsHelperKt.errorResult("Failed to start process. " + t2.getMessage(), t2);
            throw new KotlinNothingValueException();
        }
        Object process2 = $this$toTypedArray$iv;
        String processName = "[" + path2.getName() + "]-" + processCounter.getAndIncrement();
        Charset charset = OS.INSTANCE.getSystemCharset();
        Logger.INSTANCE.debug("Process " + processName + " uses " + charset + " to decode output");
        if (onOutput instanceof ProcessOutputHandler.ReadLineByLine) {
            Intrinsics.checkNotNull((Object)process2);
            v1 = ProcessesRunnerUtil.INSTANCE.readThread(charset, processName, "stdout", (Process)process2, (Function1<? super Process, ? extends InputStream>)((Function1)ProcessesRunnerBlocking::executeProcessWithInputAndWait_HOFDmpg$lambda$1), ProcessesRunnerUtil.INSTANCE.safeHandler(processName, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)onOutput){

                public final void invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((ProcessOutputHandler.ReadLineByLine)this.receiver).read(p0);
                }
            })));
        } else {
            v1 = outputThread2 = null;
        }
        if (onError instanceof ProcessOutputHandler.ReadLineByLine) {
            Intrinsics.checkNotNull((Object)process2);
            thread2 = ProcessesRunnerUtil.INSTANCE.readThread(charset, processName, "stderr", (Process)process2, (Function1<? super Process, ? extends InputStream>)((Function1)ProcessesRunnerBlocking::executeProcessWithInputAndWait_HOFDmpg$lambda$2), ProcessesRunnerUtil.INSTANCE.safeHandler(processName, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)onError){

                public final void invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((ProcessOutputHandler.ReadLineByLine)this.receiver).read(p0);
                }
            })));
        } else {
            thread2 = null;
        }
        Thread errorThread2 = thread2;
        Object[] objectArray = new Thread[]{ProcessesRunnerUtil.INSTANCE.thread(processName, "stdin", (Function0<Unit>)((Function0)() -> ProcessesRunnerBlocking.executeProcessWithInputAndWait_HOFDmpg$lambda$4((Process)process2, input))), outputThread2, errorThread2};
        List readerThreads = CollectionsKt.listOfNotNull((Object[])objectArray);
        try {
            try {
                if (Duration.compareTo-LRDsOJo((long)timeout2, (long)Duration.Companion.getZERO-UwyO8pc()) <= 0) {
                    ((Process)process2).waitFor();
                } else if (!((Process)process2).waitFor(Duration.getInWholeMilliseconds-impl((long)timeout2), TimeUnit.MILLISECONDS)) {
                    Logger.INSTANCE.debug("Failed to wait for process finish");
                }
            }
            catch (Throwable t3) {
                Logger.INSTANCE.warn(t3, "Failed to wait for process to exit. " + t3.getMessage());
            }
            if (((Process)process2).isAlive()) {
                ((Process)process2).destroyForcibly();
            }
            n = ((Process)process2).exitValue();
        }
        finally {
            Thread thread3;
            Iterable $this$forEach$iv = readerThreads;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                thread3 = (Thread)element$iv;
                boolean bl = false;
                thread3.interrupt();
            }
            $this$forEach$iv = readerThreads;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                thread3 = (Thread)element$iv;
                boolean bl = false;
                thread3.join();
            }
        }
        int exitValue = n;
        Logger.INSTANCE.debug("Process " + processName + " exited with code: " + exitValue);
        if (exitValue != 0) {
            ErrorsHelperKt.errorResult$default("Process exit code: " + exitValue, null, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void executeProcessWithInputAndWait-HOFDmpg$default(ProcessesRunnerBlocking processesRunnerBlocking, File file, List list2, File file2, byte[] byArray, Map map2, long l, ProcessOutputHandler processOutputHandler, ProcessOutputHandler processOutputHandler2, int n, Object object) {
        if ((n & 0x40) != 0) {
            processOutputHandler = ProcessOutputHandler.Discard.INSTANCE;
        }
        if ((n & 0x80) != 0) {
            processOutputHandler2 = ProcessOutputHandler.Discard.INSTANCE;
        }
        processesRunnerBlocking.executeProcessWithInputAndWait-HOFDmpg(file, list2, file2, byArray, map2, l, processOutputHandler, processOutputHandler2);
    }

    private static final InputStream executeProcessWithInputAndWait_HOFDmpg$lambda$1(Process $this$readThread) {
        Intrinsics.checkNotNullParameter((Object)$this$readThread, (String)"$this$readThread");
        InputStream inputStream = $this$readThread.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return inputStream;
    }

    private static final InputStream executeProcessWithInputAndWait_HOFDmpg$lambda$2(Process $this$readThread) {
        Intrinsics.checkNotNullParameter((Object)$this$readThread, (String)"$this$readThread");
        InputStream inputStream = $this$readThread.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit executeProcessWithInputAndWait_HOFDmpg$lambda$4(Process $process, byte[] $input) {
        Closeable closeable = $process.getOutputStream();
        Throwable throwable = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl = false;
            os.write($input);
            os.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }
}

