/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.interop.Processes;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class ZipExtractorKt {
    public static final void extractZip(@NotNull ShellEnvironment shellEnv, @NotNull FileSystem fileSystem, @NotNull Path sourceFile, @NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)shellEnv, (String)"shellEnv");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        String normalizedSource = sourceFile.normalized().toString();
        String normalizedTarget = targetDir.normalized().toString();
        if (OS.INSTANCE.isWindows()) {
            Path sevenzip = ZipExtractorKt.locate7zWin32(fileSystem);
            Object[] objectArray = new String[]{"x", "-y", "-o" + normalizedTarget, normalizedSource};
            ZipExtractorKt.executeProcess(sevenzip, CollectionsKt.listOf((Object[])objectArray));
            return;
        }
        Object[] objectArray = new String[]{normalizedSource, "-d", normalizedTarget};
        List arguments = CollectionsKt.listOf((Object[])objectArray);
        Path unzip = shellEnv.findExecutable("unzip");
        if (unzip == null) {
            Logger.INSTANCE.error("Cannot find unzip");
            throw new IllegalStateException("Cannot find unzip".toString());
        }
        ZipExtractorKt.executeProcess(unzip, arguments);
    }

    private static final void executeProcess(Path path2, List<String> arguments) {
        ProcessRunner.executeProcessAndWait-9VgGkz4$default((ProcessRunner)Processes.INSTANCE, path2.toFile(), arguments, null, null, 0L, 28, null);
    }

    private static final Path locate7zWin32(FileSystem $this$locate7zWin32) {
        Path forTests;
        Path inAppDir = StandardPaths.INSTANCE.getApplicationDir().resolve("7z.exe");
        if ($this$locate7zWin32.exists(inAppDir)) {
            return inAppDir;
        }
        String string = System.getProperty("user.dir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Path inUserDir = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null).resolve("7z.exe");
        if ($this$locate7zWin32.exists(inUserDir)) {
            return inUserDir;
        }
        if (Build.INSTANCE.isSNAPSHOT() && $this$locate7zWin32.exists(forTests = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"../deps/7z/7z.exe", (boolean)false, (int)1, null))) {
            return forTests;
        }
        throw new IllegalStateException("Failed to find 7zip executable in the package".toString());
    }
}

