/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop;

import com.jetbrains.toolbox.ResultException;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.interop.LoggingKt;
import com.jetbrains.toolbox.interop.Pid;
import com.jetbrains.toolbox.interop.ProcessOutputHandler;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.interop.RunAsMode;
import com.jetbrains.toolbox.interop.processes.ProcessesRunnerBlocking;
import com.jetbrains.toolbox.interop.processes.ProcessesRunnerFork;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nProcesses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Processes.kt\ncom/jetbrains/toolbox/interop/Processes\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n426#2,11:167\n295#3,2:178\n*S KotlinDebug\n*F\n+ 1 Processes.kt\ncom/jetbrains/toolbox/interop/Processes\n*L\n55#1:167,11\n132#1:178,2\n*E\n"})
public final class Processes
implements ProcessRunner {
    @NotNull
    public static final Processes INSTANCE = new Processes();

    private Processes() {
    }

    @Override
    public void executeProcessAndWait-B8UsjHI(@NotNull File path2, @NotNull List<String> arguments, @Nullable File workingDir, @NotNull ProcessOutputHandler handleOut, @NotNull ProcessOutputHandler handleErr, @NotNull Map<String, String> additionalEnvironment, long timeout2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)handleOut, (String)"handleOut");
        Intrinsics.checkNotNullParameter((Object)handleErr, (String)"handleErr");
        Intrinsics.checkNotNullParameter(additionalEnvironment, (String)"additionalEnvironment");
        ProcessesRunnerBlocking.INSTANCE.executeProcessWithInputAndWait-HOFDmpg(path2, arguments, workingDir, new byte[0], additionalEnvironment, timeout2, handleOut, handleErr);
    }

    @Override
    public void executeProcessAndWait-9VgGkz4(@NotNull File path2, @NotNull List<String> arguments, @Nullable File workingDir, @NotNull Map<String, String> additionalEnvironment, long timeout2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(additionalEnvironment, (String)"additionalEnvironment");
        ProcessesRunnerBlocking.executeProcessWithInputAndWait-HOFDmpg$default(ProcessesRunnerBlocking.INSTANCE, path2, arguments, workingDir, new byte[0], additionalEnvironment, timeout2, null, null, 192, null);
    }

    @Override
    @Nullable
    public ProcessHandle forkProcessNoWait(@NotNull File path2, @NotNull List<String> arguments, @Nullable File workingDir, @NotNull Map<String, String> additionalEnvironment, @NotNull RunAsMode runAs, @NotNull ProcessOutputHandler onOutput, @NotNull ProcessOutputHandler onError) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(additionalEnvironment, (String)"additionalEnvironment");
        Intrinsics.checkNotNullParameter((Object)((Object)runAs), (String)"runAs");
        Intrinsics.checkNotNullParameter((Object)onOutput, (String)"onOutput");
        Intrinsics.checkNotNullParameter((Object)onError, (String)"onError");
        return ProcessesRunnerFork.INSTANCE.forkProcessNoWait(path2, arguments, workingDir, additionalEnvironment, runAs, onOutput, onError);
    }

    @Nullable
    public final ProcessHandle forkProcessNoWait(@NotNull File path2, @NotNull List<String> arguments, @Nullable Path workingDir, @NotNull Map<String, String> additionalEnvironment, @NotNull RunAsMode runAs, @NotNull ProcessOutputHandler onOutput, @NotNull ProcessOutputHandler onError) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(additionalEnvironment, (String)"additionalEnvironment");
        Intrinsics.checkNotNullParameter((Object)((Object)runAs), (String)"runAs");
        Intrinsics.checkNotNullParameter((Object)onOutput, (String)"onOutput");
        Intrinsics.checkNotNullParameter((Object)onError, (String)"onError");
        Path path3 = workingDir;
        return this.forkProcessNoWait(path2, arguments, path3 != null ? path3.toFile() : null, additionalEnvironment, runAs, onOutput, onError);
    }

    public static /* synthetic */ ProcessHandle forkProcessNoWait$default(Processes processes, File file, List list2, Path path2, Map map2, RunAsMode runAsMode, ProcessOutputHandler processOutputHandler, ProcessOutputHandler processOutputHandler2, int n, Object object) {
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            runAsMode = RunAsMode.RunAsUser;
        }
        if ((n & 0x20) != 0) {
            processOutputHandler = ProcessOutputHandler.Discard.INSTANCE;
        }
        if ((n & 0x40) != 0) {
            processOutputHandler2 = ProcessOutputHandler.Discard.INSTANCE;
        }
        return processes.forkProcessNoWait(file, (List<String>)list2, path2, (Map<String, String>)map2, runAsMode, processOutputHandler, processOutputHandler2);
    }

    @Override
    @Nullable
    public Object runProcessCancellable(@NotNull Path path2, @NotNull List<String> arguments, @NotNull ProcessOutputHandler onOutput, @NotNull ProcessOutputHandler onError, @NotNull Continuation<? super Unit> $completion) {
        Process process2 = ProcessesRunnerFork.INSTANCE.forkProcessNoWait(path2.toFile(), arguments, null, MapsKt.emptyMap(), onOutput, onError);
        if (process2 == null) {
            return Unit.INSTANCE;
        }
        Process process3 = process2;
        ProcessHandle processHandle = process3.toHandle();
        if (processHandle == null) {
            return Unit.INSTANCE;
        }
        ProcessHandle processHandle2 = processHandle;
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        CompletableFuture<ProcessHandle> onExit = processHandle2.onExit();
        if (onExit == null) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException("onExit is null"))));
        } else {
            onExit.thenRun(new Runnable(process3, (CancellableContinuation<? super Unit>)continuation){
                final /* synthetic */ Process $process;
                final /* synthetic */ CancellableContinuation<Unit> $continuation;
                {
                    this.$process = $process;
                    this.$continuation = $continuation;
                }

                public final void run() {
                    int exitValue = this.$process.exitValue();
                    if (exitValue != 0) {
                        ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new ResultException("Process exit code: " + exitValue, null, 2, null))));
                    } else {
                        ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                    }
                }
            });
            continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(processHandle2, onExit){
                final /* synthetic */ ProcessHandle $processHandle;
                final /* synthetic */ CompletableFuture<ProcessHandle> $onExit;
                {
                    this.$processHandle = $processHandle;
                    this.$onExit = $onExit;
                }

                public final void invoke(Throwable it) {
                    if (this.$processHandle.isAlive()) {
                        this.$processHandle.destroyForcibly();
                    }
                    this.$onExit.cancel(true);
                }
            });
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void waitForPid-CxHxETo(long pid, long timeout2, boolean killOnTimeout) {
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        ProcessHandle handle2 = ProcessHandle.of(pid).orElse(null);
        if (handle2 == null) {
            Logger.INSTANCE.debug("Unable to open process " + Pid.toString-impl(pid) + ", assuming it's already finished");
            return;
        }
        if (!handle2.isAlive()) {
            Logger.INSTANCE.debug("Process " + Pid.toString-impl(pid) + " is not alive");
            return;
        }
        try {
            handle2.onExit().get(Duration.getInWholeMilliseconds-impl((long)timeout2), TimeUnit.MILLISECONDS);
            Logger.INSTANCE.debug("Process " + Pid.toString-impl(pid) + " was finished");
            return;
        }
        catch (TimeoutException timeoutException) {
        }
        catch (ExecutionException t2) {
            String msg = "Unexpected exception waiting for " + Pid.toString-impl(pid) + " to complete. " + t2;
            Logger.INSTANCE.debug((Throwable)t2, msg);
            throw new IllegalStateException(msg.toString());
        }
        Logger.INSTANCE.debug("Timeout waiting for process " + Pid.toString-impl(pid) + " to finish in " + Duration.toString-impl((long)timeout2));
        if (!killOnTimeout) {
            throw new IllegalStateException(("Timeout waiting for process PID=" + pid + " to finish").toString());
        }
        Logger.INSTANCE.debug("Killing process " + Pid.toString-impl(pid));
        ProcessHandle.of(pid).ifPresent(arg_0 -> Processes.waitForPid_CxHxETo$lambda$2(Processes::waitForPid_CxHxETo$lambda$1, arg_0));
        this.waitForPid-CxHxETo(pid, DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MILLISECONDS), false);
    }

    private final String grepCommandOutput(File command2, List<String> args, List<String> strings) {
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        ProcessOutputHandler.ReadLineByLine check2 = LoggingKt.logOutput(arg_0 -> Processes.grepCommandOutput$lambda$4(result2, strings, arg_0));
        ProcessRunner.executeProcessAndWait-B8UsjHI$default((ProcessRunner)this, command2, args, new File("/bin"), (ProcessOutputHandler)check2, (ProcessOutputHandler)check2, null, 0L, 96, null);
        return (String)result2.element;
    }

    @Override
    public boolean scanForProcessesFromPath(@NotNull List<String> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        if (!OS.INSTANCE.isMac()) {
            return false;
        }
        Logger.INSTANCE.debug("Looking for: " + paths);
        Object[] objectArray = new String[]{"axwww", "-o", "pid,command"};
        String grepResult = this.grepCommandOutput(new File("/bin/ps"), CollectionsKt.listOf((Object[])objectArray), paths);
        if (grepResult != null) {
            Logger.INSTANCE.info("Detected running process " + grepResult);
            return true;
        }
        return false;
    }

    @Override
    public boolean onProcessTermination(long pid, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ProcessHandle processHandle = ProcessHandle.of(pid).orElse(null);
        if (processHandle == null) {
            return false;
        }
        ProcessHandle handle2 = processHandle;
        handle2.onExit().thenRun(() -> Processes.onProcessTermination$lambda$5(block));
        return true;
    }

    @Override
    public void executeProcessAndWait-B8UsjHI(@NotNull Path path2, @NotNull List<String> arguments, @Nullable Path workingDir, @NotNull ProcessOutputHandler handleOut, @NotNull ProcessOutputHandler handleErr, @NotNull Map<String, String> additionalEnvironment, long timeout2) {
        ProcessRunner.super.executeProcessAndWait-B8UsjHI(path2, arguments, workingDir, handleOut, handleErr, additionalEnvironment, timeout2);
    }

    @Override
    public void executeProcessAndWait-9VgGkz4(@NotNull Path path2, @NotNull List<String> arguments, @Nullable Path workingDir, @NotNull Map<String, String> additionalEnvironment, long timeout2) {
        ProcessRunner.super.executeProcessAndWait-9VgGkz4(path2, arguments, workingDir, additionalEnvironment, timeout2);
    }

    @Override
    @Nullable
    public ProcessHandle forkProcessNoWait(@NotNull Path path2, @NotNull List<String> arguments, @Nullable Path workingDir, @NotNull Map<String, String> additionalEnvironment, @NotNull RunAsMode runAs, @NotNull ProcessOutputHandler onOutput, @NotNull ProcessOutputHandler onError) {
        return ProcessRunner.super.forkProcessNoWait(path2, arguments, workingDir, additionalEnvironment, runAs, onOutput, onError);
    }

    private static final Unit waitForPid_CxHxETo$lambda$1(ProcessHandle it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.destroyForcibly();
        it.onExit().join();
        return Unit.INSTANCE;
    }

    private static final void waitForPid_CxHxETo$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void grepCommandOutput$lambda$4(Ref.ObjectRef $result, List $strings, String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if ($result.element == null) {
            Object v0;
            block2: {
                void $this$firstOrNull$iv;
                Iterable iterable = $strings;
                Ref.ObjectRef objectRef = $result;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)str, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            objectRef.element = v0;
        }
    }

    private static final void onProcessTermination$lambda$5(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

