/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop;

import com.jetbrains.toolbox.common.io.FileExtensionsKt;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.interop.PlistResolver;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PlistResolverImpl
implements PlistResolver {
    @NotNull
    private final FileSystem fileSystem;

    public PlistResolverImpl(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    @Nullable
    public Path resolveExecutablePath(@NotNull Path appDirectory) {
        Intrinsics.checkNotNullParameter((Object)appDirectory, (String)"appDirectory");
        if (!this.fileSystem.exists(appDirectory)) {
            return null;
        }
        Document document = this.openInfoPlist(appDirectory.toFile());
        if (document == null) {
            return null;
        }
        Document doc = document;
        Map<String, Element> found = this.findKeys(doc, SetsKt.setOf((Object)"CFBundleExecutable"));
        Element element = found.get("CFBundleExecutable");
        if (element == null) {
            return null;
        }
        Element exec = element;
        Element element2 = this.nextSiblingElement(exec, "string");
        String executableName = element2 != null ? element2.getTextContent() : null;
        CharSequence charSequence = executableName;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        Path file = appDirectory.resolve("Contents").resolve("MacOS").resolve(executableName);
        Logger.INSTANCE.debug("Resolved bundle executable path " + file);
        return this.fileSystem.exists(file) && FileSystemExtKt.isExecutable(this.fileSystem, file) ? file : null;
    }

    private final Document openInfoPlist(File bundlePath) {
        Document document;
        File plist = this.getInfoPlistPath(bundlePath);
        try {
            document = this.getDocBuilder().parse(plist);
        }
        catch (Exception e) {
            return null;
        }
        Document doc = document;
        String rootTagName = doc.getDocumentElement().getTagName();
        if (!Intrinsics.areEqual((Object)rootTagName, (Object)"plist")) {
            return null;
        }
        return doc;
    }

    private final File getInfoPlistPath(File bundlePath) {
        return FileExtensionsKt.div(bundlePath, "Contents/Info.plist");
    }

    private final Map<String, Element> findKeys(Document doc, Set<String> keysToFind) {
        Map result2 = new LinkedHashMap();
        NodeList dictElements = doc.getDocumentElement().getElementsByTagName("dict");
        int n = dictElements.getLength();
        for (int dictElementId = 0; dictElementId < n; ++dictElementId) {
            Element dict;
            Node node2 = dictElements.item(dictElementId);
            if ((node2 instanceof Element ? (Element)node2 : null) == null) continue;
            dict = dict;
            NodeList keyElements = dict.getElementsByTagName("key");
            int n2 = keyElements.getLength();
            for (int keyElementId = 0; keyElementId < n2; ++keyElementId) {
                Element keyElement;
                String key2;
                Node node3 = keyElements.item(keyElementId);
                Element element = node3 instanceof Element ? (Element)node3 : null;
                if (element == null || !keysToFind.contains(key2 = (keyElement = element).getTextContent())) continue;
                result2.put(key2, keyElement);
            }
        }
        return result2;
    }

    private final DocumentBuilder getDocBuilder() {
        DocumentBuilderFactory documentBuilderFactory;
        DocumentBuilderFactory $this$_get_docBuilder__u24lambda_u240 = documentBuilderFactory = DocumentBuilderFactory.newInstance();
        boolean bl = false;
        $this$_get_docBuilder__u24lambda_u240.setNamespaceAware(true);
        $this$_get_docBuilder__u24lambda_u240.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return documentBuilderFactory.newDocumentBuilder();
    }

    private final Element nextSiblingElement(Element $this$nextSiblingElement, String name2) {
        for (Node elem = (Node)$this$nextSiblingElement; elem != null; elem = elem.getNextSibling()) {
            Node node2 = elem;
            Element element = node2 instanceof Element ? (Element)node2 : null;
            if (!Intrinsics.areEqual((Object)(element != null ? element.getTagName() : null), (Object)name2)) continue;
            return (Element)elem;
        }
        return null;
    }
}

