/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop;

import com.jetbrains.toolbox.interop.ProcessOutputHandler;
import com.jetbrains.toolbox.interop.ReadLineByLineLoggingWrapper;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tinylog.ThreadContext;

public final class LoggingKt {
    @NotNull
    private static final String PROCESS_NAME_KEY = "processName";
    @NotNull
    private static final String THREAD_NAME_KEY = "threadName";

    @NotNull
    public static final ProcessOutputHandler.ReadLineByLine logOutput(@NotNull ProcessOutputHandler.ReadLineByLine $this$logOutput) {
        Intrinsics.checkNotNullParameter((Object)$this$logOutput, (String)"<this>");
        return new ReadLineByLineLoggingWrapper($this$logOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void withProcessLoggingContext(@NotNull String processName, @NotNull String threadName, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)processName, (String)PROCESS_NAME_KEY);
        Intrinsics.checkNotNullParameter((Object)threadName, (String)THREAD_NAME_KEY);
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Pair<String, String> oldProcessLoggingContextValues = null;
        try {
            oldProcessLoggingContextValues = LoggingKt.updateProcessLoggingContext(processName, threadName);
            block.invoke();
        }
        finally {
            Pair<String, String> pair = oldProcessLoggingContextValues;
            if (pair != null) {
                Pair<String, String> pair2 = pair;
                boolean bl = false;
                String oldProcessName = (String)pair2.component1();
                String oldThreadName = (String)pair2.component2();
                LoggingKt.resetProcessLoggingContext(oldProcessName, oldThreadName);
            }
        }
    }

    private static final Pair<String, String> updateProcessLoggingContext(String processName, String threadName) {
        Pair<String, String> oldValues = LoggingKt.getProcessLoggingContext();
        ThreadContext.put((String)PROCESS_NAME_KEY, (Object)processName);
        ThreadContext.put((String)THREAD_NAME_KEY, (Object)threadName);
        return oldValues;
    }

    private static final Pair<String, String> getProcessLoggingContext() {
        String processName = ThreadContext.get((String)PROCESS_NAME_KEY);
        String string = ThreadContext.get((String)THREAD_NAME_KEY);
        if (string == null) {
            string = Thread.currentThread().getName();
        }
        String threadName = string;
        return TuplesKt.to((Object)processName, (Object)threadName);
    }

    private static final void resetProcessLoggingContext(String oldProcessName, String oldThreadName) {
        LoggingKt.resetThreadContextKey(PROCESS_NAME_KEY, oldProcessName);
        LoggingKt.resetThreadContextKey(THREAD_NAME_KEY, oldThreadName);
    }

    private static final void resetThreadContextKey(String key2, String oldValue) {
        String string = oldValue;
        if (string == null) {
            ThreadContext.remove((String)key2);
        } else {
            ThreadContext.put((String)key2, (Object)string);
        }
    }

    public static final /* synthetic */ Pair access$getProcessLoggingContext() {
        return LoggingKt.getProcessLoggingContext();
    }
}

