/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop;

import com.jetbrains.toolbox.interop.FoundationLibrary;
import com.jetbrains.toolbox.interop.ID;
import com.jetbrains.toolbox.interop.NSString;
import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class Foundation {
    @NotNull
    public static final Foundation INSTANCE = new Foundation();
    @NotNull
    private static final FoundationLibrary foundation;
    @NotNull
    private static final Function myObjcMsgSend;
    public static final int kCFStringEncodingUTF16LE = 0x14000100;

    private Foundation() {
    }

    private final Object[] prepInvoke(ID id, Pointer selector, Object[] args) {
        Object[] invokArgs = new Object[args.length + 2];
        invokArgs[0] = id;
        invokArgs[1] = selector;
        System.arraycopy(args, 0, invokArgs, 2, args.length);
        return invokArgs;
    }

    @JvmStatic
    @NotNull
    public static final ID getClass(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ID iD = foundation.objc_getClass(name2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)iD), (String)"objc_getClass(...)");
        return iD;
    }

    @JvmStatic
    @NotNull
    public static final ID invoke(@NotNull ID obj, @NotNull String method, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return Foundation.invoke(obj, Foundation.createSelector(method), Arrays.copyOf(args, args.length));
    }

    @JvmStatic
    @NotNull
    public static final ID invoke(@NotNull ID obj, @NotNull Pointer method, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ID(myObjcMsgSend.invokeLong(INSTANCE.prepInvoke(obj, method, args)));
    }

    @JvmStatic
    @NotNull
    public static final Pointer createSelector(@NotNull String sel) {
        Intrinsics.checkNotNullParameter((Object)sel, (String)"sel");
        Pointer pointer = foundation.sel_registerName(sel);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"sel_registerName(...)");
        return pointer;
    }

    @JvmStatic
    public static final long convertCFEncodingToNS(long cfEncoding) {
        return foundation.CFStringConvertEncodingToNSStringEncoding(cfEncoding) & 0xFFFFFFFFFFL;
    }

    @JvmStatic
    @NotNull
    public static final ID nsString(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ID iD = NSString.create(str);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)iD), (String)"create(...)");
        return iD;
    }

    static {
        try {
            Logger.INSTANCE.info("Loaded JNA " + (Native.POINTER_SIZE << 3) + "-bit");
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to load JNA");
        }
        Library library = Native.load((String)"Foundation", FoundationLibrary.class, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"jna.encoding", (Object)"UTF8")));
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
        foundation = (FoundationLibrary)library;
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(foundation);
        Intrinsics.checkNotNull((Object)invocationHandler, (String)"null cannot be cast to non-null type com.sun.jna.Library.Handler");
        NativeLibrary nativeLibrary = ((Library.Handler)invocationHandler).getNativeLibrary();
        Function function = nativeLibrary.getFunction("objc_msgSend");
        Intrinsics.checkNotNullExpressionValue((Object)function, (String)"getFunction(...)");
        myObjcMsgSend = function;
    }
}

