/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.vmoptions;

import com.jetbrains.toolbox.intellij.vmoptions.VmOption;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmxOptionImpl
implements VmOption.Xmx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private final Lazy bytes$delegate;
    @NotNull
    private static final Regex regex = new Regex("^(\\d+)(k|m|g|)$", RegexOption.IGNORE_CASE);

    public XmxOptionImpl(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.value = value2;
        this.bytes$delegate = LazyKt.lazy(() -> XmxOptionImpl.bytes_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    @Override
    public long getBytes() {
        Lazy lazy = this.bytes$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @NotNull
    public String toString() {
        return "-Xmx" + this.getValue();
    }

    @Override
    public int compareTo(@NotNull VmOption.Xmx other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.getBytes(), (long)other.getBytes());
    }

    @Override
    public int inMegaBytes() {
        return (int)(this.getBytes() / 0x100000L);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof XmxOptionImpl)) {
            return false;
        }
        XmxOptionImpl xmxOptionImpl = (XmxOptionImpl)other;
        return Intrinsics.areEqual((Object)this.value, (Object)xmxOptionImpl.value);
    }

    @Override
    public boolean isSameAs(@NotNull VmOption other) {
        return VmOption.Xmx.super.isSameAs(other);
    }

    private static final long bytes_delegate$lambda$0(XmxOptionImpl this$0) {
        MatchResult matchResult = regex.matchEntire((CharSequence)this$0.getValue());
        Intrinsics.checkNotNull((Object)matchResult);
        MatchResult match2 = matchResult;
        MatchGroup matchGroup = match2.getGroups().get(2);
        Intrinsics.checkNotNull((Object)matchGroup);
        String multiplierString = matchGroup.getValue();
        long multiplier = StringsKt.equals((String)multiplierString, (String)"k", (boolean)true) ? 1024L : (StringsKt.equals((String)multiplierString, (String)"m", (boolean)true) ? 0x100000L : (StringsKt.equals((String)multiplierString, (String)"g", (boolean)true) ? 0x40000000L : 1L));
        MatchGroup matchGroup2 = match2.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup2);
        return Long.parseLong(matchGroup2.getValue()) * multiplier;
    }

    public static final class Companion {
        private Companion() {
        }

        public final boolean isValidXmx(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return regex.matchEntire((CharSequence)StringsKt.removePrefix((String)value2, (CharSequence)"-Xmx")) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

