/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.vmoptions;

import com.jetbrains.toolbox.ExecutablePathProvider;
import com.jetbrains.toolbox.common.TransitionEvent;
import com.jetbrains.toolbox.feed.PathWithVariables;
import com.jetbrains.toolbox.intellij.IntelliJChannelExtension;
import com.jetbrains.toolbox.intellij.IntelliJSettingsUpdater;
import com.jetbrains.toolbox.intellij.IntelliJToolExtension;
import com.jetbrains.toolbox.intellij.IntelliJToolExtensionKt;
import com.jetbrains.toolbox.intellij.vmoptions.UtilKt;
import com.jetbrains.toolbox.intellij.vmoptions.UtilsKt;
import com.jetbrains.toolbox.intellij.vmoptions.VmOption;
import com.jetbrains.toolbox.intellij.vmoptions.VmOptionsEditor;
import com.jetbrains.toolbox.intellij.vmoptions.VmOptionsManager;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.ChannelBackupOptions;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelExtension;
import com.jetbrains.toolbox.tools.model.ChannelHistory;
import com.jetbrains.toolbox.tools.model.ChannelStateKt;
import com.jetbrains.toolbox.tools.model.IDEDirectories;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.State;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.UpdateFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nVmOptionsUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VmOptionsUpdater.kt\ncom/jetbrains/toolbox/intellij/vmoptions/VmOptionsUpdater\n+ 2 ChannelExtension.kt\ncom/jetbrains/toolbox/tools/model/ChannelExtensionKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n11#2:117\n1563#3:118\n1634#3,3:119\n1#4:122\n*S KotlinDebug\n*F\n+ 1 VmOptionsUpdater.kt\ncom/jetbrains/toolbox/intellij/vmoptions/VmOptionsUpdater\n*L\n45#1:117\n45#1:118\n45#1:119,3\n*E\n"})
public final class VmOptionsUpdater
implements IntelliJSettingsUpdater {
    @NotNull
    private final VmOptionsManager vmOptionsManager;
    @NotNull
    private final ExecutablePathProvider executablePathProvider;
    @NotNull
    private final FileSystem fileSystem;

    public VmOptionsUpdater(@NotNull VmOptionsManager vmOptionsManager, @NotNull ToolManager toolManager, @NotNull ExecutablePathProvider executablePathProvider, @NotNull FileSystem fileSystem, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)vmOptionsManager, (String)"vmOptionsManager");
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)executablePathProvider, (String)"executablePathProvider");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.vmOptionsManager = vmOptionsManager;
        this.executablePathProvider = executablePathProvider;
        this.fileSystem = fileSystem;
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(toolManager, this, null){
            int label;
            final /* synthetic */ ToolManager $toolManager;
            final /* synthetic */ VmOptionsUpdater this$0;
            {
                this.$toolManager = $toolManager;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$toolManager.getTransitions().collect(new FlowCollector(){

                            public final Object emit(TransitionEvent<State, ChannelEvent> transitionEvent, Continuation<? super Unit> $completion) {
                                State from = transitionEvent.component1();
                                State to = transitionEvent.component2();
                                ToolInstance toolInstance = ChannelStateKt.toToolInstanceOrNull(from);
                                if (toolInstance == null) {
                                    return Unit.INSTANCE;
                                }
                                ToolInstance fromToolInstance = toolInstance;
                                ToolInstance toolInstance2 = ChannelStateKt.toToolInstanceOrNull(to);
                                if (toolInstance2 == null) {
                                    return Unit.INSTANCE;
                                }
                                ToolInstance toToolInstance = toolInstance2;
                                Object object = this$0.updateVmOptions(fromToolInstance, toToolInstance, (Continuation<? super Unit>)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object applySettings(@NotNull ToolInstance toolInstance, boolean defaultVmOptionsLocation, @Nullable String xmx, @NotNull IDEDirectories ideDirectories, @NotNull Continuation<? super Unit> $completion) {
        Collection<void> collection;
        void $this$mapTo$iv$iv$iv;
        void $this$map$iv$iv;
        void $this$withModifiedExtension$iv;
        Channel channel = toolInstance.getChannel();
        ToolInstance toolInstance2 = toolInstance;
        ToolInstance toolInstance3 = toolInstance;
        VmOptionsUpdater vmOptionsUpdater = this;
        boolean $i$f$withModifiedExtension = false;
        Iterable iterable = $this$withModifiedExtension$iv.getExtensions();
        ChannelHistory channelHistory = null;
        boolean bl = false;
        List list2 = null;
        boolean bl2 = false;
        ChannelBackupOptions channelBackupOptions = null;
        boolean bl3 = false;
        Path path2 = null;
        UpdateFilter updateFilter = null;
        String string = null;
        void var18_21 = $this$withModifiedExtension$iv;
        boolean $i$f$map = false;
        void var20_23 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            ChannelExtension channelExtension;
            void it$iv;
            ChannelExtension channelExtension2 = (ChannelExtension)item$iv$iv$iv;
            collection = destination$iv$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof IntelliJChannelExtension) {
                IntelliJChannelExtension it = (IntelliJChannelExtension)it$iv;
                boolean bl5 = false;
                channelExtension = IntelliJChannelExtension.copy$default(it, defaultVmOptionsLocation, xmx, ideDirectories, null, null, 24, null);
            } else {
                channelExtension = it$iv;
            }
            collection.add((void)channelExtension);
        }
        collection = (List)destination$iv$iv$iv;
        Channel channel2 = Channel.copy$default((Channel)var18_21, string, updateFilter, path2, bl3, channelBackupOptions, bl2, list2, bl, channelHistory, collection, null, 1535, null);
        Object object = vmOptionsUpdater.updateVmOptions(toolInstance3, ToolInstance.copy$default(toolInstance2, channel2, null, 2, null), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object updateVmOptions(ToolInstance from, ToolInstance to, Continuation<? super Unit> $completion) {
        VmOption.Xmx xmx;
        InstalledTool tool = to.getTool();
        IntelliJChannelExtension intelliJChannelExtension = com.jetbrains.toolbox.intellij.UtilKt.getIntellij(to.getChannel());
        if (intelliJChannelExtension == null) {
            return Unit.INSTANCE;
        }
        IntelliJChannelExtension newValue = intelliJChannelExtension;
        IntelliJChannelExtension oldValue = com.jetbrains.toolbox.intellij.UtilKt.getIntellij(from.getChannel());
        if (Intrinsics.areEqual((Object)oldValue, (Object)newValue)) {
            return Unit.INSTANCE;
        }
        Path path2 = UtilKt.getVmoptionsPath(to);
        if (path2 == null) {
            return Unit.INSTANCE;
        }
        Path vmOptionsPath = path2;
        Path oldVmOptionsPath = UtilKt.getVmoptionsPath(from);
        if (!Intrinsics.areEqual((Object)vmOptionsPath, (Object)oldVmOptionsPath)) {
            Logger.INSTANCE.info("Changed .vmoptions file location: " + oldVmOptionsPath + " -> " + vmOptionsPath);
            IntelliJChannelExtension intelliJChannelExtension2 = com.jetbrains.toolbox.intellij.UtilKt.getIntellij(from.getChannel());
            boolean bl = intelliJChannelExtension2 != null ? !intelliJChannelExtension2.getDefaultVmOptionsLocation() : false;
            if (bl) {
                IntelliJChannelExtension intelliJChannelExtension3 = com.jetbrains.toolbox.intellij.UtilKt.getIntellij(to.getChannel());
                boolean bl2 = intelliJChannelExtension3 != null ? intelliJChannelExtension3.getDefaultVmOptionsLocation() : false;
                if (bl2 && oldVmOptionsPath != null) {
                    this.fileSystem.delete(oldVmOptionsPath);
                }
            }
        }
        this.logChanges(vmOptionsPath, oldValue, newValue);
        Object object = IntelliJToolExtensionKt.getIntellijExtension(tool);
        if (object != null && (object = ((IntelliJToolExtension)object).getDefaultXmx()) != null) {
            Object object2 = object;
            VmOption.Companion companion = VmOption.Companion;
            Object p0 = object2;
            boolean bl = false;
            xmx = companion.createXmxOption((String)p0);
        } else {
            xmx = null;
        }
        VmOption.Xmx defaultXmx = xmx;
        Object object3 = this.vmOptionsManager.edit(vmOptionsPath, new VmOptionsManager.ValidationRules(defaultXmx, null, 2, null), (Function1<? super VmOptionsEditor, Unit>)((Function1)arg_0 -> VmOptionsUpdater.updateVmOptions$lambda$2(newValue, this, arg_0)), $completion);
        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object3;
        }
        return Unit.INSTANCE;
    }

    private final void logChanges(Path vmoptionsPath, IntelliJChannelExtension oldValue, IntelliJChannelExtension newValue) {
        IDEDirectories newIDEDirectories;
        Logger.INSTANCE.debug("==Updated '" + vmoptionsPath + "'==");
        IntelliJChannelExtension intelliJChannelExtension = oldValue;
        String oldXmx = intelliJChannelExtension != null ? intelliJChannelExtension.getXmx() : null;
        String newXmx = newValue.getXmx();
        if (!Intrinsics.areEqual((Object)oldXmx, (Object)newXmx)) {
            Logger.INSTANCE.debug("-Xmx: " + oldXmx + " -> " + newXmx);
        }
        IntelliJChannelExtension intelliJChannelExtension2 = oldValue;
        IDEDirectories oldIDEDirectories = intelliJChannelExtension2 != null ? intelliJChannelExtension2.getIdeDirectories() : null;
        if (!Intrinsics.areEqual((Object)oldIDEDirectories, (Object)(newIDEDirectories = newValue.getIdeDirectories()))) {
            Logger.INSTANCE.debug("IDE directories: " + oldIDEDirectories + " -> " + newIDEDirectories);
        }
        Logger.INSTANCE.debug(StringsKt.repeat((CharSequence)"=", (int)80));
    }

    private static final Unit updateVmOptions$lambda$2(IntelliJChannelExtension $newValue, VmOptionsUpdater this$0, VmOptionsEditor $this$edit) {
        Intrinsics.checkNotNullParameter((Object)$this$edit, (String)"$this$edit");
        String string = $newValue.getXmx();
        if (string != null) {
            String it = string;
            boolean bl = false;
            $this$edit.applyVmOption(VmOption.Companion.createXmxOption(it));
        }
        $this$edit.setSystemProperty("ide.managed.by.toolbox", this$0.executablePathProvider.getAbsolutePath());
        Map<String, PathWithVariables> newIDEDirectories = $newValue.getIdeDirectories().asPropertyToPathMap();
        for (String property : UtilsKt.getIdeaDirectoryPathProperties()) {
            String directory;
            PathWithVariables pathWithVariables = newIDEDirectories.get(property);
            String string2 = directory = pathWithVariables != null ? pathWithVariables.unbox-impl() : null;
            if (directory != null) {
                $this$edit.setSystemProperty(property, directory.toString());
                continue;
            }
            $this$edit.removeSystemProperty(property);
        }
        return Unit.INSTANCE;
    }
}

