/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.vmoptions;

import com.jetbrains.toolbox.OSKt;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.feed.DefaultConfigDirectories;
import com.jetbrains.toolbox.intellij.IntelliJChannelExtension;
import com.jetbrains.toolbox.intellij.IntelliJToolExtension;
import com.jetbrains.toolbox.intellij.IntelliJToolExtensionKt;
import com.jetbrains.toolbox.shell.model.ShellLauncherToolExtension;
import com.jetbrains.toolbox.shell.model.ShellLauncherToolExtensionKt;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UtilKt {
    @Nullable
    public static final Path getVmoptionsPath(@NotNull ToolInstance $this$vmoptionsPath) {
        Intrinsics.checkNotNullParameter((Object)$this$vmoptionsPath, (String)"<this>");
        IntelliJChannelExtension intelliJChannelExtension = com.jetbrains.toolbox.intellij.UtilKt.getIntellij($this$vmoptionsPath.getChannel());
        return (intelliJChannelExtension != null ? !intelliJChannelExtension.getDefaultVmOptionsLocation() : false) ? UtilKt.getCustomVmOptionsPath($this$vmoptionsPath.getChannel()) : UtilKt.getCurrentVmOptionsPath($this$vmoptionsPath);
    }

    @Nullable
    public static final Path getDefaultVmOptionsPath(@NotNull InstalledTool $this$defaultVmOptionsPath) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultVmOptionsPath, (String)"<this>");
        Object object = IntelliJToolExtensionKt.getIntellijExtension($this$defaultVmOptionsPath);
        if (object == null || (object = ((IntelliJToolExtension)object).getDefaultConfigDirectories()) == null) {
            return null;
        }
        Object configDirectories = object;
        Path configDirectory = OSKt.getExpanded-WIZC_Bo(((DefaultConfigDirectories)configDirectories).getConfig-6QkRYPI());
        Object object2 = ShellLauncherToolExtensionKt.getShellLauncher($this$defaultVmOptionsPath);
        if (object2 == null || (object2 = ((ShellLauncherToolExtension)object2).getBaseName()) == null) {
            return null;
        }
        Object filePrefix = object2;
        return configDirectory.resolve(UtilKt.generateVmOptionsName$default((String)filePrefix, null, 2, null));
    }

    @Nullable
    public static final Path getCurrentVmOptionsPath(@NotNull ToolInstance $this$currentVmOptionsPath) {
        Intrinsics.checkNotNullParameter((Object)$this$currentVmOptionsPath, (String)"<this>");
        DefaultConfigDirectories defaultConfigDirectories = com.jetbrains.toolbox.intellij.UtilKt.getCurrentDefaultConfigDirectories($this$currentVmOptionsPath);
        if (defaultConfigDirectories == null) {
            return null;
        }
        DefaultConfigDirectories configDirectories = defaultConfigDirectories;
        Path configDirectory = OSKt.getExpanded-WIZC_Bo(configDirectories.getConfig-6QkRYPI());
        Object object = ShellLauncherToolExtensionKt.getShellLauncher($this$currentVmOptionsPath.getTool());
        if (object == null || (object = ((ShellLauncherToolExtension)object).getBaseName()) == null) {
            return null;
        }
        Object filePrefix = object;
        return configDirectory.resolve(UtilKt.generateVmOptionsName$default((String)filePrefix, null, 2, null));
    }

    @NotNull
    public static final Path getCustomVmOptionsPath(@NotNull Channel $this$customVmOptionsPath) {
        Intrinsics.checkNotNullParameter((Object)$this$customVmOptionsPath, (String)"<this>");
        return Path.Companion.get$default((Path.Companion)Path.Companion, (String)($this$customVmOptionsPath.getInstallationDirectory() + ".vmoptions"), (boolean)false, (int)1, null);
    }

    @NotNull
    public static final String computeDefaultXmxForIntelliJ(long totalMemoryBytes) {
        long totalMemoryMegabytes = totalMemoryBytes / (long)0x100000;
        long xmx = RangesKt.coerceIn((long)(totalMemoryMegabytes / (long)8), (long)750L, (long)2048L);
        return xmx + "m";
    }

    @NotNull
    public static final String generateVmOptionsName(@NotNull String defaultShellScriptName, @NotNull OS.Type os) {
        Intrinsics.checkNotNullParameter((Object)defaultShellScriptName, (String)"defaultShellScriptName");
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        String middle = switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 1 -> "";
            case 2 -> "64";
            case 3 -> "64.exe";
            default -> throw new NoWhenBranchMatchedException();
        };
        return defaultShellScriptName + middle + ".vmoptions";
    }

    public static /* synthetic */ String generateVmOptionsName$default(String string, OS.Type type2, int n, Object object) {
        if ((n & 2) != 0) {
            type2 = OS.INSTANCE.getType();
        }
        return UtilKt.generateVmOptionsName(string, type2);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Mac.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

