/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.plugins;

import com.jetbrains.toolbox.intellij.plugins.PluginDownloadData;
import com.jetbrains.toolbox.intellij.plugins.PluginDownloadResult;
import com.jetbrains.toolbox.intellij.plugins.PluginDownloaderCommon;
import com.jetbrains.toolbox.intellij.plugins.ToolPluginDownloader;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import java.util.UUID;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VSCodePluginDownloaderImpl
extends PluginDownloaderCommon
implements ToolPluginDownloader {
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path downloadDirectory;

    public VSCodePluginDownloaderImpl(@NotNull DownloadManager downloadManager, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        super(downloadManager, fileSystem);
        this.downloadManager = downloadManager;
        this.fileSystem = fileSystem;
        this.downloadDirectory = this.downloadManager.getDownloadDirectory();
    }

    @Override
    @Nullable
    public Object downloadZippedPlugin(@NotNull PluginDownloadData pluginDownloadData, @Nullable String eTag, @NotNull Continuation<? super PluginDownloadResult> $completion) {
        if (Intrinsics.areEqual((Object)pluginDownloadData.getSource(), (Object)"MARKETPLACE")) {
            return new PluginDownloadResult.Success(null, null, null, 4, null);
        }
        this.fileSystem.createDirectories(this.downloadDirectory);
        Path pluginFile = this.downloadDirectory.resolve(UUID.randomUUID() + ".vsix");
        return this.downloadZippedPlugin-qzOQ-yY(pluginDownloadData.getUrl(), pluginDownloadData.getPluginId-b6BwIdc(), eTag, pluginFile, $completion);
    }

    @Override
    public boolean matches(@NotNull InstalledTool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        return WellKnownApplications.INSTANCE.isVSCodeType-lOMW6pk(tool.getToolId-UtVBrGo());
    }
}

