/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.integration;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.CommandLine;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.StandardPathsKt;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.io.Copy_and_moveKt;
import com.jetbrains.toolbox.common.io.FileExtensionsKt;
import com.jetbrains.toolbox.common.io.Temp_directoryKt;
import com.jetbrains.toolbox.integration.OSIntegrationManagerImpl;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nOSIntegrationManagerMac.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSIntegrationManagerMac.kt\ncom/jetbrains/toolbox/integration/OSIntegrationManagerMac\n+ 2 FileSystem.kt\nokio/FileSystem\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n80#2:231\n165#2:232\n81#2:233\n82#2:238\n52#3,4:234\n60#3,10:239\n56#3,18:249\n1#4:267\n*S KotlinDebug\n*F\n+ 1 OSIntegrationManagerMac.kt\ncom/jetbrains/toolbox/integration/OSIntegrationManagerMac\n*L\n41#1:231\n41#1:232\n41#1:233\n41#1:238\n41#1:234,4\n41#1:239,10\n41#1:249,18\n*E\n"})
public final class OSIntegrationManagerMac
extends OSIntegrationManagerImpl {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final CommandLine commandLine;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Path logFile;
    @NotNull
    private final ShellEnvironment shellEnvironment;
    @NotNull
    private final ProcessRunner processRunner;
    @NotNull
    private final Path ourPath;

    public OSIntegrationManagerMac(@NotNull FileSystem fileSystem, @NotNull CommandLine commandLine, @NotNull CoroutineScope coroutineScope, @NotNull Path logFile, @NotNull ShellEnvironment shellEnvironment, @NotNull ProcessRunner processRunner) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        Intrinsics.checkNotNullParameter((Object)shellEnvironment, (String)"shellEnvironment");
        Intrinsics.checkNotNullParameter((Object)processRunner, (String)"processRunner");
        this.fileSystem = fileSystem;
        this.commandLine = commandLine;
        this.coroutineScope = coroutineScope;
        this.logFile = logFile;
        this.shellEnvironment = shellEnvironment;
        this.processRunner = processRunner;
        this.ourPath = StandardPaths.INSTANCE.getApplicationDir();
    }

    @Override
    @NotNull
    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    @NotNull
    protected CommandLine getCommandLine() {
        return this.commandLine;
    }

    @Override
    @NotNull
    public CoroutineScope getCoroutineScope$core() {
        return this.coroutineScope;
    }

    @Override
    @NotNull
    public Path getLogFile() {
        return this.logFile;
    }

    @Override
    @NotNull
    protected ShellEnvironment getShellEnvironment() {
        return this.shellEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final OSIntegrationManagerImpl.InstallationResult safeInstall(Path installTarget) {
        try {
            Logger.INSTANCE.debug("Moving new version from " + this.ourPath + " to " + installTarget + ", pid: " + OS.INSTANCE.getPID());
            try {
                this.getFileSystem().createDirectories(installTarget);
                Path testFile = installTarget.resolve(".testFile");
                try {
                    BufferedSink bufferedSink;
                    Throwable thrown$iv$iv;
                    BufferedSink $this$iv;
                    block33: {
                        FileSystem fileSystem = this.getFileSystem();
                        Path file$iv = testFile;
                        boolean mustCreate$iv = false;
                        boolean bl = false;
                        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                        boolean $i$f$use = false;
                        thrown$iv$iv = null;
                        try {
                            BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                            boolean bl2 = false;
                            BufferedSink $this$safeInstall_u24lambda_u240 = it$iv;
                            boolean bl3 = false;
                            bufferedSink = $this$safeInstall_u24lambda_u240.writeUtf8("test");
                        }
                        catch (Throwable t$iv$iv) {
                            try {
                                thrown$iv$iv = t$iv$iv;
                                bufferedSink = null;
                                break block33;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                block34: {
                                    try {
                                        Closeable closeable = $this$use$iv$iv;
                                        if (closeable != null) {
                                            closeable.close();
                                        }
                                    }
                                    catch (Throwable t$iv$iv2) {
                                        if (thrown$iv$iv == null) {
                                            thrown$iv$iv = t$iv$iv2;
                                            break block34;
                                        }
                                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                                    }
                                }
                            }
                        }
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv) {
                            thrown$iv$iv = t$iv$iv;
                        }
                    }
                    BufferedSink result$iv$iv = bufferedSink;
                    Throwable throwable = thrown$iv$iv;
                    if (throwable != null) {
                        throw throwable;
                    }
                    $this$iv = result$iv$iv;
                }
                finally {
                    this.getFileSystem().delete(testFile);
                }
            }
            catch (Throwable t2) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.failedToCreateTempDirectory(this, t2, installTarget, "Unable to create file in " + installTarget);
            }
            Path tempDirectory = Temp_directoryKt.getTempDirectory(this.getFileSystem(), StandardPaths.INSTANCE.getToolboxCacheLocation().resolve("temp"), "toolbox-app");
            try {
                Copy_and_moveKt.safeAtomicMove$default(this.getFileSystem(), installTarget, tempDirectory, true, 0, 8, null);
            }
            catch (Throwable t3) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles$default(OSIntegrationManagerImpl.InstallationResult.Companion, installTarget, tempDirectory, t3, false, 8, null);
            }
            try {
                Copy_and_moveKt.copyRecursively$default(this.getFileSystem(), this.ourPath, installTarget, null, false, 0, 28, null);
            }
            catch (Throwable t4) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles(this.ourPath, installTarget, t4, true);
            }
            try {
                this.getFileSystem().deleteRecursively(tempDirectory);
            }
            catch (Throwable t5) {
                Logger.INSTANCE.warn(t5, "Unable to delete " + tempDirectory);
            }
            try {
                Object[] t5 = new String[]{"-fR", "g+w", installTarget.toString()};
                ProcessRunner.executeProcessAndWait-9VgGkz4$default(this.processRunner, new File("/bin/chmod"), CollectionsKt.listOf((Object[])t5), null, null, 0L, 28, null);
            }
            catch (Throwable t6) {
                Logger.INSTANCE.warn("Failed to chmod new files at " + installTarget + " to allow write for group: " + t6.getMessage());
            }
            try {
                Path path2 = this.getShellEnvironment().findExecutable("touch");
                if (path2 == null) {
                    path2 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/usr/bin/touch", (boolean)false, (int)1, null);
                }
                ProcessRunner.forkProcessNoWait$default(this.processRunner, path2, CollectionsKt.listOf((Object)installTarget.toString()), null, null, null, null, null, 124, null);
                return OSIntegrationManagerImpl.InstallationResult.Success.INSTANCE;
            }
            catch (Throwable t7) {
                Logger.INSTANCE.error("Failed to touch application folder: " + t7.getMessage());
            }
            return OSIntegrationManagerImpl.InstallationResult.Success.INSTANCE;
        }
        catch (Throwable t8) {
            return OSIntegrationManagerImpl.InstallationResult.Companion.otherError(t8);
        }
    }

    @Override
    @NotNull
    protected OSIntegrationManagerImpl.InstallationResult install(@Nullable Path installTarget) {
        if (installTarget == null) {
            boolean $i$a$-checkNotNull-OSIntegrationManagerMac$install$22 = false;
            String $i$a$-checkNotNull-OSIntegrationManagerMac$install$22 = "Install target should be specified";
            throw new IllegalStateException($i$a$-checkNotNull-OSIntegrationManagerMac$install$22.toString());
        }
        OSIntegrationManagerImpl.InstallationResult result2 = this.safeInstall(installTarget);
        Path path2 = installTarget.resolve("Contents").resolve("MacOS").resolve("jetbrains-toolbox");
        List<String> args = this.getArgumentsForUpdatedToolbox(result2 instanceof OSIntegrationManagerImpl.InstallationResult.Success);
        try {
            Logger.INSTANCE.debug("Command line: " + this.getCommandLine() + ", pid: " + OS.INSTANCE.getPID() + ", targetDir = " + installTarget);
            ProcessRunner.forkProcessNoWait$default(this.processRunner, path2, args, null, null, null, null, null, 124, null);
        }
        catch (Throwable t2) {
            OSIntegrationManagerImpl.InstallationResult.Failed failed = result2 instanceof OSIntegrationManagerImpl.InstallationResult.Failed ? (OSIntegrationManagerImpl.InstallationResult.Failed)result2 : null;
            return failed != null ? (OSIntegrationManagerImpl.InstallationResult)failed : (OSIntegrationManagerImpl.InstallationResult)OSIntegrationManagerImpl.InstallationResult.Companion.failToLaunchToolbox(this, t2, path2);
        }
        return result2;
    }

    @Override
    protected void uninstall() {
        this.ensureAutorun(false);
    }

    private final boolean ensureProtocolHandlerAppIsRegistered() {
        boolean success = false;
        try {
            String helpersBundlePath = Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)this.ourPath, (String)"Contents", (boolean)false, (int)2, null), (String)"Helpers", (boolean)false, (int)2, null), (String)"JetBrains Toolbox.app", (boolean)false, (int)2, null).toString();
            Object[] objectArray = new String[]{"-a", helpersBundlePath, "--args", "--register"};
            ProcessRunner.forkProcessNoWait$default(this.processRunner, new File("/usr/bin/open"), CollectionsKt.listOf((Object[])objectArray), null, null, null, null, null, 124, null);
            success = true;
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to register helper app");
        }
        return success;
    }

    @Override
    protected void ensureOSIntegration(boolean runOnStartup, boolean startMenuShortcut) {
        if (this.getCommandLine().isUpdateFailed()) {
            return;
        }
        this.ensureProtocolHandlerAppIsRegistered();
        if (this.isAllowedToModifyAutostartOrStartMenu()) {
            this.ensureAutorun(runOnStartup);
        }
    }

    @Override
    protected void ensureAutorun(boolean enabled) {
        if (!this.isAllowedToModifyAutostartOrStartMenu()) {
            return;
        }
        ThreadGuardKt.assertNotMainThread("java.io.File.delete()|mkdirs()");
        File launchAgents = StandardPaths.INSTANCE.getHome().resolve("Library").resolve("LaunchAgents").toFile();
        File plist = FileExtensionsKt.div(launchAgents, "com.jetbrains.toolbox.plist");
        try {
            if (enabled) {
                launchAgents.mkdirs();
                Logger.INSTANCE.info("Registering autorun via " + plist);
                String plistText = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n  <dict>\n    <key>Label</key>\n    <string>com.jetbrains.toolbox</string>\n    <key>ProgramArguments</key>\n    <array>\n       <string>" + StandardPaths.INSTANCE.getApplicationFile() + "</string>\n       <string>--minimize</string>\n    </array>\n    <key>RunAtLoad</key>\n    <true/>\n    <key>StandardOutPath</key>\n    <string>" + StandardPathsKt.getLogsDirectory().resolve("launchd-stdout.log") + "</string>\n    <key>StandardErrorPath</key>\n    <string>" + StandardPathsKt.getLogsDirectory().resolve("launchd-stderr.log") + "</string>\n  </dict>\n</plist>";
                FilesKt.writeText$default((File)plist, (String)plistText, null, (int)2, null);
            } else {
                Logger.INSTANCE.info("Removing autorun via " + plist);
                plist.delete();
            }
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to modify autorun plist");
            Logger.INSTANCE.warn("Autorun plist path: " + plist);
            Logger.INSTANCE.warn("Autorun plist exists: " + plist.exists());
            Logger.INSTANCE.warn("Autorun plist permissions: canRead=" + plist.canRead() + ", canWrite=" + plist.canWrite() + ", canExecute=" + plist.canExecute());
        }
    }

    @Override
    protected void ensureStartMenuShortcut(boolean enabled) {
    }

    @Override
    protected void unsafeOpenPath(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String[] stringArray = new String[]{"-R", path2.toString()};
        OSIntegrationManagerImpl.tryRunSystemExecutable$default(this, "open", stringArray, null, 4, null);
    }

    @Override
    @Nullable
    protected Object unsafeEditFile(@NotNull Path path2, @NotNull Continuation<? super Unit> $completion) {
        String[] stringArray = new String[]{"-t", path2.toString()};
        OSIntegrationManagerImpl.tryRunSystemExecutable$default(this, "open", stringArray, null, 4, null);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object unsafeOpenUrl$core(@NotNull String url, @NotNull Continuation<? super Unit> $completion) {
        String[] stringArray = new String[]{url};
        if (OSIntegrationManagerImpl.tryRunSystemExecutable$default(this, "open", stringArray, null, 4, null)) {
            return Unit.INSTANCE;
        }
        Logger.INSTANCE.info("Failed to use 'open' to open " + url + ", trying to find browser executable");
        Object object = super.unsafeOpenUrl$core(url, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public String getFileManagerName() {
        return "Finder";
    }

    @Override
    public void openSystemProxySettings() {
        this.launch((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ OSIntegrationManagerMac this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (BuildNumber.compareTo-Szkhn3Q(OS.INSTANCE.getKernelVersion-Y_E1uuk(), BuildNumber.constructor-impl("13.0")) >= 0) {
                            String[] stringArray = new String[]{"x-apple.systempreferences:com.apple.Network-Settings.extension?Proxies"};
                            v0 = Boxing.boxBoolean((boolean)OSIntegrationManagerImpl.tryRunSystemExecutable$default(this.this$0, "open", stringArray, null, 4, null));
                        } else {
                            Object[] objectArray = new String[]{"-e", "tell application \"System Preferences\"\nactivate\nreveal anchor \"Proxies\" of pane id \"com.apple.preference.network\"\nend tell"};
                            v0 = ProcessRunner.forkProcessNoWait$default(OSIntegrationManagerMac.access$getProcessRunner$p(this.this$0), new File("/usr/bin/osascript"), CollectionsKt.listOf((Object[])objectArray), null, null, null, null, null, 124, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @NotNull
    protected List<Path> profileFiles() {
        String shell = this.getShellEnvironment().get("SHELL");
        if (shell != null) {
            if (StringsKt.endsWith$default((String)shell, (String)"bash", (boolean)false, (int)2, null)) {
                Path path2 = this.ifExists(StandardPaths.INSTANCE.getHome().resolve(".bash_profile"));
                if (path2 == null && (path2 = this.ifExists(StandardPaths.INSTANCE.getHome().resolve(".bash_login"))) == null) {
                    path2 = StandardPaths.INSTANCE.getHome().resolve(".profile");
                }
                return CollectionsKt.listOf((Object)path2);
            }
            if (StringsKt.endsWith$default((String)shell, (String)"zsh", (boolean)false, (int)2, null)) {
                return CollectionsKt.listOf((Object)StandardPaths.INSTANCE.getHome().resolve(".zprofile"));
            }
        }
        Logger.INSTANCE.debug("Can't find profile, unknown shell " + shell);
        return CollectionsKt.listOf((Object)StandardPaths.INSTANCE.getHome().resolve(".profile"));
    }

    public static final /* synthetic */ ProcessRunner access$getProcessRunner$p(OSIntegrationManagerMac $this) {
        return $this.processRunner;
    }
}

