/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.integration;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.CommandLine;
import com.jetbrains.toolbox.ErrorsHelperKt;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.common.io.File_infoKt;
import com.jetbrains.toolbox.integration.OSIntegrationManager;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.interop.Processes;
import com.jetbrains.toolbox.interop.RunAsMode;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.settings.UpdateSettings;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import com.jetbrains.toolbox.tools.model.FailedUpdate;
import com.jetbrains.toolbox.tools.model.UpdateFilter;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nOSIntegrationManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSIntegrationManagerImpl.kt\ncom/jetbrains/toolbox/integration/OSIntegrationManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 5 ErrorsHelper.kt\ncom/jetbrains/toolbox/ErrorsHelperKt\n+ 6 Okio.kt\nokio/Okio__OkioKt\n+ 7 FileSystem.kt\nokio/FileSystem\n*L\n1#1,477:1\n1#2:478\n1#2:495\n1374#3:479\n1460#3,2:480\n774#3:482\n865#3,2:483\n1617#3,9:485\n1869#3:494\n1870#3:496\n1626#3:497\n1462#3,3:498\n360#3,7:571\n7#4,7:501\n8#5,4:508\n66#6:512\n52#6,4:514\n60#6,10:519\n56#6,3:529\n71#6,3:532\n52#6,4:538\n60#6,10:543\n56#6,18:553\n67#7:513\n68#7:518\n80#7:535\n165#7:536\n81#7:537\n82#7:542\n*S KotlinDebug\n*F\n+ 1 OSIntegrationManagerImpl.kt\ncom/jetbrains/toolbox/integration/OSIntegrationManagerImpl\n*L\n179#1:495\n171#1:479\n171#1:480,2\n178#1:482\n178#1:483,2\n179#1:485,9\n179#1:494\n179#1:496\n179#1:497\n171#1:498,3\n415#1:571,7\n236#1:501,7\n312#1:508,4\n385#1:512\n385#1:514,4\n385#1:519,10\n385#1:529,3\n385#1:532,3\n404#1:538,4\n404#1:543,10\n404#1:553,18\n385#1:513\n385#1:518\n404#1:535\n404#1:536\n404#1:537\n404#1:542\n*E\n"})
public abstract class OSIntegrationManagerImpl
implements OSIntegrationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy applicationExecutable$delegate = LazyKt.lazy(OSIntegrationManagerImpl::applicationExecutable_delegate$lambda$0);
    @NotNull
    private final Lazy installationPath$delegate = LazyKt.lazy(OSIntegrationManagerImpl::installationPath_delegate$lambda$1);

    @NotNull
    protected abstract FileSystem getFileSystem();

    @NotNull
    protected abstract CommandLine getCommandLine();

    @NotNull
    protected abstract ShellEnvironment getShellEnvironment();

    @NotNull
    public abstract CoroutineScope getCoroutineScope$core();

    @Override
    @NotNull
    public abstract Path getLogFile();

    @Override
    @NotNull
    public Path getApplicationExecutable() {
        Lazy lazy = this.applicationExecutable$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    public Path getInstallationPath() {
        Lazy lazy = this.installationPath$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    protected abstract InstallationResult install(@Nullable Path var1);

    protected abstract void uninstall();

    protected final boolean isAllowedToModifyAutostartOrStartMenu() {
        return !Build.INSTANCE.isSNAPSHOT() && !this.getCommandLine().isUpdateFailed() || this.getCommandLine().isForceAutostartIntegration();
    }

    protected abstract void ensureOSIntegration(boolean var1, boolean var2);

    protected abstract void ensureAutorun(boolean var1);

    protected abstract void ensureStartMenuShortcut(boolean var1);

    protected final void launch(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope$core(), null, null, block, (int)3, null);
    }

    @Nullable
    protected Object unsafeEditFile(@NotNull Path path2, @NotNull Continuation<? super Unit> $completion) {
        return OSIntegrationManagerImpl.unsafeEditFile$suspendImpl(this, path2, $completion);
    }

    static /* synthetic */ Object unsafeEditFile$suspendImpl(OSIntegrationManagerImpl $this, Path path2, Continuation<? super Unit> $completion) {
        Object object = $this.unsafeOpenUrl$core(path2.toString(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public final void editFile(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.launch((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, path2, null){
            int label;
            final /* synthetic */ OSIntegrationManagerImpl this$0;
            final /* synthetic */ Path $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.unsafeEditFile(this.$path, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Throwable t2) {
                            Logger.INSTANCE.error(t2, "Can't open '" + this.$path + "' in editor.");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public Object unsafeOpenUrl$core(@NotNull String url, @NotNull Continuation<? super Unit> $completion) {
        return OSIntegrationManagerImpl.unsafeOpenUrl$suspendImpl(this, url, $completion);
    }

    static /* synthetic */ Object unsafeOpenUrl$suspendImpl(OSIntegrationManagerImpl $this, String url, Continuation<? super Unit> $completion) {
        String[] stringArray = new String[]{"google-chrome", "firefox", "mozilla"};
        List browsers = CollectionsKt.listOf((Object[])stringArray);
        for (String browser : browsers) {
            String[] stringArray2 = new String[]{url};
            if (!OSIntegrationManagerImpl.tryRunSystemExecutable$default($this, browser, stringArray2, null, 4, null)) continue;
            return Unit.INSTANCE;
        }
        Logger.INSTANCE.error("Didn't find any executable to handle " + url);
        return Unit.INSTANCE;
    }

    @NotNull
    public final Deferred<Throwable> openUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return BuildersKt.async$default((CoroutineScope)this.getCoroutineScope$core(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Throwable>, Object>(this, url, null){
            int label;
            final /* synthetic */ OSIntegrationManagerImpl this$0;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.validate$core(this.$url);
                        this.label = 1;
                        Object object2 = this.this$0.unsafeOpenUrl$core(this.$url, (Continuation<? super Unit>)((Continuation)this));
                        Object object3 = object2;
                        if (object2 != object) return null;
                        return object;
                    }
                    case 1: {
                        Object object3;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return null;
                        }
                        catch (ValidationException ex) {
                            ValidationException validationException = ex;
                            String string = this.$url;
                            ValidationException it = validationException;
                            boolean bl = false;
                            Logger.INSTANCE.error("URL " + string + " contains illegal characters: " + ex.getMessage());
                            return validationException;
                        }
                        catch (Throwable t2) {
                            Throwable throwable = t2;
                            String string = this.$url;
                            Throwable it = throwable;
                            boolean bl = false;
                            Logger.INSTANCE.error(t2, "Can't open URL: '" + string + "'");
                            return throwable;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Throwable> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void validate$core(@NotNull String url) throws ValidationException {
        String message2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = !StringsKt.startsWith$default((String)url, (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"jetbrains://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"mailto:", (boolean)false, (int)2, null) ? "url started without http://, https:// or jetbrains:// prefix" : (message2 = new Regex("[ \"';\\t<>|^\\\\]").containsMatchIn((CharSequence)url) ? "url contains characters such as spaces, quotes, semicolons or other forbidden symbols" : null);
        if (message2 != null) {
            throw new ValidationException(message2, null, 2, null);
        }
        try {
            URL url2 = new URI(url).toURL();
            String string2 = url2.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
            if (!(!StringsKt.contains$default((CharSequence)string2, (CharSequence)"&", (boolean)false, (int)2, null))) {
                boolean bl = false;
                String string3 = "url contains '&' character in host";
                throw new IllegalArgumentException(string3.toString());
            }
        }
        catch (Throwable e) {
            throw new ValidationException("Failed to validate URL: " + url, e);
        }
    }

    @Override
    public void openLogFile() {
        this.openPath(this.getLogFile());
    }

    protected abstract void unsafeOpenPath(@NotNull Path var1);

    @Override
    public final void openPath(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.launch((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, path2, null){
            int label;
            final /* synthetic */ OSIntegrationManagerImpl this$0;
            final /* synthetic */ Path $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        OSIntegrationManagerImpl.access$openPathSafely(this.this$0, this.$path);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final boolean openPathSafely(Path path2) {
        boolean bl;
        try {
            this.unsafeOpenPath(path2);
            bl = true;
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Can't open '" + path2 + "', skipping");
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean performStartupTasks(@NotNull SelfSettings settings2, @NotNull Clock clock, @NotNull Function1<? super SelfSettings, Unit> saveSettings2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(saveSettings2, (String)"saveSettings");
        try {
            if (this.getCommandLine().isUninstallMode()) {
                Logger.INSTANCE.info("Uninstalling");
                this.uninstall();
                this.openUrl("https://www.jetbrains.com/toolbox-app/uninstall/");
                boolean bl = true;
                return bl;
            }
            if (this.getCommandLine().isInstallMode()) {
                Object object;
                Object object2;
                Logger.INSTANCE.debug("Installing pid: " + OS.INSTANCE.getPID());
                if (this.getCommandLine().getWaitForPid() > 0L && com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows()) {
                    Logger.INSTANCE.info("Waiting additional 5 seconds to let OS unblock files");
                    Thread.sleep(5000L);
                }
                Path installTargetPath = this.getCommandLine().getInstallTarget();
                Logger.INSTANCE.info("Installing to '" + installTargetPath + "'");
                boolean $i$f$catching22 = false;
                try {
                    boolean bl = false;
                    object2 = Result.constructor-impl((Object)this.install(installTargetPath));
                }
                catch (CancellationException c$iv) {
                    throw c$iv;
                }
                catch (Throwable t$iv) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                }
                Object $i$f$catching22 = object2;
                Throwable throwable = Result.exceptionOrNull-impl((Object)$i$f$catching22);
                if (throwable == null) {
                    object = $i$f$catching22;
                } else {
                    Throwable t2 = throwable;
                    boolean bl = false;
                    object = InstallationResult.Companion.otherError(t2);
                }
                InstallationResult result2 = (InstallationResult)object;
                if (result2 instanceof InstallationResult.Failed) {
                    Instant instant = clock.now().plus-LRDsOJo(settings2.getInternal().getFailedSelfUpdatePostponeDuration-UwyO8pc());
                    Logger.INSTANCE.warn("Postponing the Toolbox App update till " + instant + " due to " + ((InstallationResult.Failed)result2).getReason());
                    saveSettings2.invoke((Object)SelfSettings.copy$default(settings2, null, null, false, false, null, 0, null, null, null, null, null, null, null, null, UpdateSettings.copy$default(settings2.getUpdate(), UpdateFilter.copy-6hF8Tw4$default(settings2.getUpdate().getFilter(), null, null, null, null, new FailedUpdate(Build.INSTANCE.getBuildNumber-Y_E1uuk(), instant, ((InstallationResult.Failed)result2).getReason(), null), 15, null), false, 2, null), null, null, 114687, null));
                }
                Logger.INSTANCE.info("Returning true, pid: " + OS.INSTANCE.getPID());
                boolean bl = true;
                return bl;
            }
            try {
                this.ensureOSIntegration(settings2.getAutostart(), settings2.getStartMenuShortcut());
            }
            catch (ExitAfterStartupTaskPerformedException e) {
                Logger.INSTANCE.info((Object)e.getMessage());
                boolean bl = true;
                Logger.INSTANCE.info("performStartupTasks finished");
                Logger.INSTANCE.debug("osIntegrationManager started from: " + OS.INSTANCE.getPID());
                return bl;
            }
            if (this.getCommandLine().isIntegrateIntoSystem()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Logger.INSTANCE.info("performStartupTasks finished");
            Logger.INSTANCE.debug("osIntegrationManager started from: " + OS.INSTANCE.getPID());
        }
    }

    public final void onSettingsChange(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        if (!this.isAllowedToModifyAutostartOrStartMenu()) {
            return;
        }
        SelfSettings settings2 = (SelfSettings)settingsManager.getSettings().getValue();
        this.ensureAutorun(settings2.getAutostart());
        this.ensureStartMenuShortcut(settings2.getStartMenuShortcut());
    }

    @Override
    public boolean runToolboxApp() {
        Path path2 = this.getApplicationExecutable().parent();
        if (path2 == null) {
            return false;
        }
        Path bin = path2;
        return this.runProduct(bin, true);
    }

    @NotNull
    protected final LaunchResult safeLaunchToolboxApp(@NotNull Path bin, boolean isUpdated) {
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        String executableName = this.getApplicationExecutable().name();
        Path exeFromBin = bin.resolve(executableName);
        Logger.INSTANCE.info("Launching " + exeFromBin);
        List<String> args = this.getArgumentsForUpdatedToolbox(isUpdated);
        try {
            ProcessRunner.forkProcessNoWait$default((ProcessRunner)Processes.INSTANCE, exeFromBin, args, bin, null, RunAsMode.RunAsUser, null, null, 104, null);
        }
        catch (Exception e) {
            return new LaunchResult.Failed(e, exeFromBin);
        }
        Logger.INSTANCE.info("successfully started " + exeFromBin);
        return LaunchResult.Success.INSTANCE;
    }

    protected final boolean runProduct(@NotNull Path bin, boolean isUpdated) {
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        LaunchResult result2 = this.safeLaunchToolboxApp(bin, isUpdated);
        if (result2 instanceof LaunchResult.Failed) {
            String errorMessagePrefix$iv = "startup failed";
            boolean $i$f$wrapError = false;
            try {
                boolean bl = false;
                throw ((LaunchResult.Failed)result2).getT();
            }
            catch (Throwable t$iv) {
                ErrorsHelperKt.errorResult(errorMessagePrefix$iv + ": " + t$iv.getMessage(), t$iv);
                throw new KotlinNothingValueException();
            }
        }
        if (Intrinsics.areEqual((Object)result2, (Object)LaunchResult.Success.INSTANCE)) {
            return true;
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    protected final List<String> getArgumentsForUpdatedToolbox(boolean isUpdated) {
        String string;
        Object[] objectArray = new String[6];
        objectArray[0] = "--wait-for-pid";
        objectArray[1] = String.valueOf(OS.INSTANCE.getPID());
        objectArray[2] = isUpdated ? "--update-successful" : "--update-failed";
        String string2 = string = "--minimize";
        int n = 3;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = this.getCommandLine().isMinimize();
        objectArray2[n] = bl2 ? string : null;
        String it = string = "--trace";
        n = 4;
        objectArray2 = objectArray;
        boolean bl3 = false;
        bl2 = this.getCommandLine().isTrace();
        objectArray2[n] = bl2 ? string : null;
        it = string = "--debug";
        n = 5;
        objectArray2 = objectArray;
        boolean bl4 = false;
        bl2 = this.getCommandLine().isDebug() && !this.getCommandLine().isTrace();
        objectArray2[n] = bl2 ? string : null;
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    protected final boolean tryRunSystemExecutable(@NotNull String executable, @NotNull String[] args, @NotNull Path workingDir) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        try {
            boolean bl2;
            Path path2 = this.getShellEnvironment().findExecutable(executable);
            if (path2 == null) {
                Logger.INSTANCE.error("Cannot find system executable for '" + executable + "'");
                bl2 = false;
            } else {
                ProcessRunner.forkProcessNoWait$default((ProcessRunner)Processes.INSTANCE, path2, ArraysKt.toList((Object[])args), workingDir, null, null, null, null, 120, null);
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Unable to run system executable for '" + executable + "'");
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean tryRunSystemExecutable$default(OSIntegrationManagerImpl oSIntegrationManagerImpl, String string, String[] stringArray, Path path2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tryRunSystemExecutable");
        }
        if ((n & 4) != 0) {
            Path path3 = oSIntegrationManagerImpl.getApplicationExecutable().parent();
            if (path3 == null) {
                path3 = StandardPaths.INSTANCE.getApplicationDir();
            }
            path2 = path3;
        }
        return oSIntegrationManagerImpl.tryRunSystemExecutable(string, stringArray, path2);
    }

    @NotNull
    protected List<Path> profileFiles() {
        return CollectionsKt.emptyList();
    }

    @Nullable
    protected final Path ifExists(@NotNull Path $this$ifExists) {
        Intrinsics.checkNotNullParameter((Object)$this$ifExists, (String)"<this>");
        return this.getFileSystem().exists($this$ifExists) ? $this$ifExists : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addLocationToPath(@NotNull Path location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        String string = Companion.getEscapedOrNull$core(location);
        if (string == null) {
            return false;
        }
        String escapedLocation = string;
        String lineToAdd = "export PATH=\"$PATH:" + escapedLocation + "\"";
        boolean atLeastOneProfileUpdated = false;
        Iterator<Path> iterator2 = this.profileFiles().iterator();
        while (iterator2.hasNext()) {
            FileSystem backupFile;
            Path file$iv;
            String contents;
            Path profileFile;
            block45: {
                profileFile = iterator2.next();
                contents = null;
                if (this.getFileSystem().exists(profileFile)) {
                    String this_$iv;
                    if (!FileSystemExtKt.isWritable(this.getFileSystem(), profileFile)) {
                        Logger.INSTANCE.debug("The profile file " + profileFile + " is not writable, skipping");
                        continue;
                    }
                    FileMetadata fileMetadata2 = this.getFileSystem().metadataOrNull(profileFile);
                    if (!(fileMetadata2 != null ? fileMetadata2.isRegularFile() : false)) {
                        Logger.INSTANCE.debug("The profile file " + profileFile + " is not regular file, skipping");
                        continue;
                    }
                    if (Files.isSymbolicLink(profileFile.toNioPath())) {
                        Logger.INSTANCE.warn("The profile file " + profileFile + " is a symbolic link, skipping");
                        continue;
                    }
                    try {
                        String $i$a$-use-FileSystem$read$1$iv23332;
                        Throwable thrown$iv$iv;
                        block43: {
                            FileSystem fileSystem = this.getFileSystem();
                            file$iv = profileFile;
                            boolean bl = false;
                            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                            boolean $i$f$use = false;
                            thrown$iv$iv = null;
                            try {
                                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                                boolean $i$a$-use-FileSystem$read$1$iv23332 = false;
                                BufferedSource $this$addLocationToPath_u24lambda_u2413 = it$iv;
                                boolean bl2 = false;
                                $i$a$-use-FileSystem$read$1$iv23332 = $this$addLocationToPath_u24lambda_u2413.readUtf8();
                            }
                            catch (Throwable t$iv$iv) {
                                try {
                                    thrown$iv$iv = t$iv$iv;
                                    $i$a$-use-FileSystem$read$1$iv23332 = null;
                                    break block43;
                                }
                                catch (Throwable t$iv$iv2) {
                                    throw t$iv$iv2;
                                }
                                finally {
                                    block44: {
                                        try {
                                            Closeable closeable = $this$use$iv$iv;
                                            if (closeable != null) {
                                                closeable.close();
                                            }
                                        }
                                        catch (Throwable t$iv$iv2) {
                                            if (thrown$iv$iv == null) {
                                                thrown$iv$iv = t$iv$iv2;
                                                break block44;
                                            }
                                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                                        }
                                    }
                                }
                            }
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv) {
                                thrown$iv$iv = t$iv$iv;
                            }
                        }
                        String result$iv$iv = $i$a$-use-FileSystem$read$1$iv23332;
                        Throwable throwable = thrown$iv$iv;
                        if (throwable != null) {
                            throw throwable;
                        }
                        this_$iv = result$iv$iv;
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.warn((Throwable)e, "Cannot read from " + profileFile);
                        continue;
                    }
                    contents = this_$iv;
                    if (SequencesKt.contains((Sequence)StringsKt.lineSequence((CharSequence)contents), (Object)lineToAdd)) {
                        return true;
                    }
                    backupFile = Path.Companion.get$default((Path.Companion)Path.Companion, (String)(profileFile + ".bak"), (boolean)false, (int)1, null);
                    try {
                        this.getFileSystem().atomicMove(profileFile, (Path)backupFile);
                        break block45;
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.debug((Throwable)e, "Couldn't back up " + profileFile + " to " + (Path)backupFile);
                        continue;
                    }
                }
                contents = "";
            }
            Logger.INSTANCE.info("Adding '" + location + "' to PATH in " + profileFile);
            try {
                BufferedSink bufferedSink;
                Throwable thrown$iv$iv;
                block46: {
                    void $this$iv;
                    backupFile = this.getFileSystem();
                    file$iv = profileFile;
                    boolean mustCreate$iv = false;
                    boolean bl = false;
                    Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                    boolean $i$f$use = false;
                    thrown$iv$iv = null;
                    try {
                        BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                        boolean bl3 = false;
                        BufferedSink $this$addLocationToPath_u24lambda_u2414 = it$iv;
                        boolean bl4 = false;
                        bufferedSink = $this$addLocationToPath_u24lambda_u2414.writeUtf8(this.updateContents(contents, lineToAdd));
                    }
                    catch (Throwable t$iv$iv) {
                        try {
                            thrown$iv$iv = t$iv$iv;
                            bufferedSink = null;
                            break block46;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            block47: {
                                try {
                                    Closeable closeable = $this$use$iv$iv;
                                    if (closeable != null) {
                                        closeable.close();
                                    }
                                }
                                catch (Throwable t$iv$iv3) {
                                    if (thrown$iv$iv == null) {
                                        thrown$iv$iv = t$iv$iv3;
                                        break block47;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv3);
                                }
                            }
                        }
                    }
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                }
                BufferedSink result$iv$iv = bufferedSink;
                Throwable throwable = thrown$iv$iv;
                if (throwable != null) {
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logger.INSTANCE.debug((Throwable)e, "Couldn't write to " + profileFile);
            }
            atLeastOneProfileUpdated = true;
        }
        return atLeastOneProfileUpdated;
    }

    private final String updateContents(String contents, String lineToAdd) {
        String exportLine;
        int markerLineIdx;
        List lines;
        block3: {
            int n;
            List $this$indexOfFirst$iv = lines = StringsKt.lines((CharSequence)contents);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                String it = (String)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)"# Added by Toolbox App")) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = markerLineIdx = -1;
        }
        boolean bl = 0 <= markerLineIdx ? markerLineIdx < CollectionsKt.getLastIndex((List)lines) - 1 : false;
        if (bl && StringsKt.startsWith$default((String)(exportLine = (String)lines.get(markerLineIdx + 1)), (String)"export PATH=", (boolean)false, (int)2, null)) {
            return StringsKt.replace$default((String)contents, (String)("# Added by Toolbox App\n" + exportLine), (String)("# Added by Toolbox App\n" + lineToAdd), (boolean)false, (int)4, null);
        }
        return contents + "\n\n# Added by Toolbox App\n" + lineToAdd + "\n\n";
    }

    private static final Path applicationExecutable_delegate$lambda$0() {
        return StandardPaths.INSTANCE.getApplicationFile();
    }

    private static final Path installationPath_delegate$lambda$1() {
        return StandardPaths.INSTANCE.getApplicationDir();
    }

    public static final /* synthetic */ boolean access$openPathSafely(OSIntegrationManagerImpl $this, Path path2) {
        return $this.openPathSafely(path2);
    }

    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getEscapedOrNull$core(@NotNull Path $this$escapedOrNull) {
            Intrinsics.checkNotNullParameter((Object)$this$escapedOrNull, (String)"<this>");
            String path2 = $this$escapedOrNull.toString();
            if (StringsKt.contains$default((CharSequence)path2, (CharSequence)":", (boolean)false, (int)2, null)) {
                return null;
            }
            return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)path2, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"$", (String)"\\$", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"`", (String)"\\`", (boolean)false, (int)4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class ExitAfterStartupTaskPerformedException
    extends Throwable {
        public ExitAfterStartupTaskPerformedException(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2);
        }
    }

    protected static sealed interface InstallationResult {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Failed cannotMoveFiles(@NotNull Path sourcePath, @NotNull Path targetPath, @Nullable Throwable throwable, boolean copy2) {
                Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
                Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
                String operation = copy2 ? "copy" : "move";
                String message2 = "Update: unable to " + operation + " files from " + sourcePath + " to " + targetPath + ", terminating update";
                if (throwable == null) {
                    Logger.INSTANCE.error(message2);
                } else {
                    Logger.INSTANCE.error(throwable, message2);
                }
                return new Failed(new FailedUpdate.Reason.Failed.CannotMoveFiles(targetPath.toString()));
            }

            public static /* synthetic */ Failed cannotMoveFiles$default(Companion companion, Path path2, Path path3, Throwable throwable, boolean bl, int n, Object object) {
                if ((n & 4) != 0) {
                    throwable = null;
                }
                if ((n & 8) != 0) {
                    bl = false;
                }
                return companion.cannotMoveFiles(path2, path3, throwable, bl);
            }

            @NotNull
            public final Failed failedToCreateTempDirectory(@NotNull OSIntegrationManagerImpl impl2, @NotNull Throwable t2, @NotNull Path path2, @Nullable String message2) {
                Intrinsics.checkNotNullParameter((Object)impl2, (String)"impl");
                Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Logger.INSTANCE.error(t2, message2 + ", terminating update\n  " + File_infoKt.info(impl2.getFileSystem(), path2) + "\n");
                return new Failed(new FailedUpdate.Reason.Failed.FailedToCreateTempDirectory(message2));
            }

            @NotNull
            public final Failed otherError(@NotNull Throwable t2) {
                Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
                Logger.INSTANCE.error(t2, "Failed to install application: " + t2.getMessage());
                String string = t2.getMessage();
                if (string == null) {
                    string = "";
                }
                return new Failed(new FailedUpdate.Reason.Failed.Other(string));
            }

            @NotNull
            public final Failed failedToRemove(@NotNull OSIntegrationManagerImpl impl2, @NotNull Throwable t2, @NotNull Path path2) {
                Intrinsics.checkNotNullParameter((Object)impl2, (String)"impl");
                Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Logger.INSTANCE.error(t2, "Update: unable to remove existing " + path2 + ", terminating update\n  " + File_infoKt.info(impl2.getFileSystem(), path2) + "\n");
                return new Failed(new FailedUpdate.Reason.Failed.FailedToRemoveFiles(path2.toString()));
            }

            @NotNull
            public final Failed failToLaunchToolbox(@NotNull OSIntegrationManagerImpl impl2, @NotNull Throwable t2, @NotNull Path path2) {
                Intrinsics.checkNotNullParameter((Object)impl2, (String)"impl");
                Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Logger.INSTANCE.error(t2, "Update: unable to start Toolbox App at path=" + path2 + ", terminating update\n  " + File_infoKt.info(impl2.getFileSystem(), path2) + "\n");
                return new Failed(new FailedUpdate.Reason.Failed.FailedToLaunch("Toolbox"));
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        public static final class Failed
        implements InstallationResult {
            @NotNull
            private final FailedUpdate.Reason.Failed reason;

            public Failed(@NotNull FailedUpdate.Reason.Failed reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                this.reason = reason;
            }

            @NotNull
            public final FailedUpdate.Reason.Failed getReason() {
                return this.reason;
            }

            @NotNull
            public String toString() {
                return "Failed(reason=" + this.reason + ")";
            }

            public int hashCode() {
                return this.reason.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                return Intrinsics.areEqual((Object)this.reason, (Object)failed.reason);
            }
        }

        public static final class Success
        implements InstallationResult {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
            }

            @NotNull
            public String toString() {
                return "Success";
            }

            public int hashCode() {
                return 850501571;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success cfr_ignored_0 = (Success)other;
                return true;
            }
        }
    }

    protected static sealed interface LaunchResult {
        @NotNull
        default public InstallationResult toInstallationResult(@NotNull OSIntegrationManagerImpl oSIntegrationManagerImpl) {
            InstallationResult installationResult;
            Intrinsics.checkNotNullParameter((Object)oSIntegrationManagerImpl, (String)"<unused var>");
            LaunchResult launchResult = this;
            if (launchResult instanceof Failed) {
                installationResult = InstallationResult.Companion.failToLaunchToolbox(oSIntegrationManagerImpl, ((Failed)this).getT(), ((Failed)this).getPath());
            } else if (Intrinsics.areEqual((Object)launchResult, (Object)Success.INSTANCE)) {
                installationResult = InstallationResult.Success.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return installationResult;
        }

        public static final class Failed
        implements LaunchResult {
            @NotNull
            private final Throwable t;
            @NotNull
            private final Path path;

            public Failed(@NotNull Throwable t2, @NotNull Path path2) {
                Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                this.t = t2;
                this.path = path2;
            }

            @NotNull
            public final Throwable getT() {
                return this.t;
            }

            @NotNull
            public final Path getPath() {
                return this.path;
            }

            @NotNull
            public String toString() {
                return "Failed(t=" + this.t + ", path=" + this.path + ")";
            }

            public int hashCode() {
                int result2 = this.t.hashCode();
                result2 = result2 * 31 + this.path.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                if (!Intrinsics.areEqual((Object)this.t, (Object)failed.t)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.path, (Object)failed.path);
            }

            @Override
            @NotNull
            public InstallationResult toInstallationResult(@NotNull OSIntegrationManagerImpl oSIntegrationManagerImpl) {
                return LaunchResult.super.toInstallationResult(oSIntegrationManagerImpl);
            }
        }

        public static final class Success
        implements LaunchResult {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
            }

            @NotNull
            public String toString() {
                return "Success";
            }

            public int hashCode() {
                return -1113306436;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success cfr_ignored_0 = (Success)other;
                return true;
            }

            @Override
            @NotNull
            public InstallationResult toInstallationResult(@NotNull OSIntegrationManagerImpl oSIntegrationManagerImpl) {
                return LaunchResult.super.toInstallationResult(oSIntegrationManagerImpl);
            }
        }
    }

    public static final class ValidationException
    extends Exception {
        public ValidationException(@NotNull String message2, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2, cause);
        }

        public /* synthetic */ ValidationException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }
    }
}

