/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.installCommands;

import com.jetbrains.toolbox.installCommands.InstallCommand;
import com.jetbrains.toolbox.installCommands.InstallCommandCoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nInstallCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallCommands.kt\ncom/jetbrains/toolbox/installCommands/InstallCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1563#2:65\n1634#2,3:66\n*S KotlinDebug\n*F\n+ 1 InstallCommands.kt\ncom/jetbrains/toolbox/installCommands/InstallCommands\n*L\n17#1:65\n17#1:66,3\n*E\n"})
public final class InstallCommands {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    @NotNull
    private final List<InstallCommand> commands;
    @NotNull
    private static final List<InstallCommandCoder<? extends InstallCommand>> commandCoders;

    public InstallCommands(int version, @NotNull List<? extends InstallCommand> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        this.version = version;
        this.commands = commands;
    }

    @NotNull
    public final List<InstallCommand> getCommands() {
        return this.commands;
    }

    @NotNull
    public String toString() {
        return "InstallCommands(version=" + this.version + ", commands=" + this.commands + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.version);
        result2 = result2 * 31 + ((Object)this.commands).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InstallCommands)) {
            return false;
        }
        InstallCommands installCommands = (InstallCommands)other;
        if (this.version != installCommands.version) {
            return false;
        }
        return Intrinsics.areEqual(this.commands, installCommands.commands);
    }

    static {
        Object[] objectArray = new InstallCommandCoder[]{InstallCommand.JoinTbe.Companion.getCoder$install_commands(), InstallCommand.JoinCwmInTbe.Companion.getCoder$install_commands(), InstallCommand.JoinPublicCwm.Companion.getCoder$install_commands(), InstallCommand.DownloadToolsCommand.Companion.getCoder$install_commands()};
        commandCoders = CollectionsKt.listOf((Object[])objectArray);
    }

    @SourceDebugExtension(value={"SMAP\nInstallCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallCommands.kt\ncom/jetbrains/toolbox/installCommands/InstallCommands$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1#2:65\n1563#3:66\n1634#3,2:67\n295#3,2:69\n1636#3:71\n*S KotlinDebug\n*F\n+ 1 InstallCommands.kt\ncom/jetbrains/toolbox/installCommands/InstallCommands$Companion\n*L\n53#1:66\n53#1:67,2\n56#1:69,2\n53#1:71\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InstallCommands decode(@NotNull String encodedCommands, @NotNull Function1<? super byte[], ? extends Map<String, ? extends Object>> jsonDecoder) {
            Intrinsics.checkNotNullParameter((Object)encodedCommands, (String)"encodedCommands");
            Intrinsics.checkNotNullParameter(jsonDecoder, (String)"jsonDecoder");
            byte[] decodedCommands = Base64.getDecoder().decode(encodedCommands);
            Intrinsics.checkNotNull((Object)decodedCommands);
            Map decodedMap = (Map)jsonDecoder.invoke((Object)decodedCommands);
            return this.fromMap(decodedMap);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final InstallCommands fromMap(@NotNull Map<String, ? extends Object> map2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            Object version = map2.get("v");
            if (!Intrinsics.areEqual((Object)version, (Object)1)) {
                boolean $i$a$-check-InstallCommands$Companion$fromMap$22 = false;
                String $i$a$-check-InstallCommands$Companion$fromMap$22 = "version " + version + " is not supported in install commands";
                throw new IllegalStateException($i$a$-check-InstallCommands$Companion$fromMap$22.toString());
            }
            Object object = map2.get("cs");
            if (object == null) {
                throw new IllegalStateException("cannot find commands from map".toString());
            }
            Object commands = object;
            List list2 = commands instanceof List ? (List)commands : null;
            if (list2 == null) {
                throw new IllegalStateException("cannot find commands from map".toString());
            }
            List commandsList = list2;
            Iterable $this$map$iv = commandsList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                InstallCommandCoder commandCoder;
                Object v2;
                Object commandId;
                void command2;
                Collection collection;
                block8: {
                    Object item$iv$iv;
                    Object t2 = item$iv$iv = iterator2.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    if ((command2 instanceof Map ? (Map)command2 : null) == null) {
                        throw new IllegalStateException("cannot find commands from map".toString());
                    }
                    if (((Map)command2).get("c") == null) {
                        throw new IllegalStateException("failed to find command id from map".toString());
                    }
                    Iterable $this$firstOrNull$iv = commandCoders;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        InstallCommandCoder it = (InstallCommandCoder)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(commandId, (Object)it.getCommandId())) continue;
                        v2 = element$iv;
                        break block8;
                    }
                    v2 = null;
                }
                if ((InstallCommandCoder)v2 == null) {
                    throw new IllegalStateException(("cannot find command coder for command " + commandId).toString());
                }
                void v3 = command2;
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                collection.add(commandCoder.decode((Map)v3));
            }
            List decodedCommands = (List)destination$iv$iv;
            Intrinsics.checkNotNull((Object)version, (String)"null cannot be cast to non-null type kotlin.Int");
            return new InstallCommands((Integer)version, decodedCommands);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

